/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.geometricdescriptor;

import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Callable;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.mpicbg.PointMatchGeneric;
import net.imglib2.util.Pair;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.process.interestpointregistration.Detection;
import spim.process.interestpointregistration.PairwiseMatch;
import spim.process.interestpointregistration.RANSAC;
import spim.process.interestpointregistration.RANSACParameters;
import spim.process.interestpointregistration.TransformationModel;
import spim.process.interestpointregistration.geometricdescriptor.RGLDMMatcher;
import spim.process.interestpointregistration.geometricdescriptor.RGLDMParameters;

public class RGLDMPairwise
implements Callable<PairwiseMatch> {
    final PairwiseMatch pair;
    final TransformationModel model;
    final RANSACParameters rp;
    final RGLDMParameters dp;
    final String comparison;

    public RGLDMPairwise(PairwiseMatch pair, TransformationModel model, String comparison, RANSACParameters rp, RGLDMParameters dp) {
        this.pair = pair;
        this.rp = rp;
        this.dp = dp;
        this.model = model;
        this.comparison = comparison;
    }

    @Override
    public PairwiseMatch call() {
        ArrayList<Detection> listA = new ArrayList<Detection>();
        ArrayList<Detection> listB = new ArrayList<Detection>();
        for (InterestPoint i : this.pair.getListA()) {
            listA.add(new Detection(i.getId(), i.getL()));
        }
        for (InterestPoint i : this.pair.getListB()) {
            listB.add(new Detection(i.getId(), i.getL()));
        }
        if (listA.size() < this.dp.getNumNeighbors() + this.dp.getRedundancy() + 1 || listB.size() < this.dp.getNumNeighbors() + this.dp.getRedundancy() + 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): " + this.comparison + ": Not enough detections to match (" + (this.dp.getNumNeighbors() + this.dp.getRedundancy() + 1) + " required per list, |listA|= " + listA.size() + ", |listB|= " + listB.size() + ")");
            this.pair.setCandidates(new ArrayList<PointMatchGeneric<Detection>>());
            this.pair.setInliers(new ArrayList<PointMatchGeneric<Detection>>(), Double.NaN);
            return this.pair;
        }
        RGLDMMatcher matcher = new RGLDMMatcher();
        ArrayList<PointMatchGeneric<Detection>> candidates = matcher.extractCorrespondenceCandidates(listA, listB, this.dp.getNumNeighbors(), this.dp.getRedundancy(), this.dp.getRatioOfDistance(), this.dp.getDifferenceThreshold());
        this.pair.setCandidates(candidates);
        ArrayList<PointMatchGeneric<Detection>> inliers = new ArrayList<PointMatchGeneric<Detection>>();
        Pair<String, Double> result = RANSAC.computeRANSAC(candidates, inliers, this.model.getModel(), this.rp.getMaxEpsilon(), this.rp.getMinInlierRatio(), this.rp.getMinInlierFactor(), this.rp.getNumIterations());
        this.pair.setInliers(inliers, (Double)result.getB());
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): " + this.comparison + ": " + (String)result.getA());
        return this.pair;
    }
}

