/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.mamba;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;

class FileDownloader {
    private static final long CHUNK_SIZE = 0x500000L;
    private final ReadableByteChannel rbc;
    private final FileOutputStream fos;

    public FileDownloader(ReadableByteChannel rbc, FileOutputStream fos) {
        this.rbc = rbc;
        this.fos = fos;
    }

    public void call() throws IOException {
        this.fos.getChannel().transferFrom(this.rbc, 0L, Long.MAX_VALUE);
    }

    public void call(Thread parentThread) throws IOException, InterruptedException {
        long transferred;
        long position = 0L;
        while ((transferred = this.fos.getChannel().transferFrom(this.rbc, position, 0x500000L)) != 0L) {
            position += transferred;
            if (parentThread.isAlive()) continue;
            this.closeResources();
            throw new InterruptedException("File download was interrupted.");
        }
    }

    private void closeResources() throws IOException {
        if (this.rbc != null) {
            this.rbc.close();
        }
        if (this.fos != null) {
            this.fos.close();
        }
    }
}

