/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.shm;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import org.apposed.appose.SharedMemory;
import org.apposed.appose.ShmFactory;
import org.apposed.appose.shm.ShmBase;
import org.apposed.appose.shm.ShmUtils;

public class ShmWindows
implements ShmFactory {
    @Override
    public SharedMemory create(String name, boolean create, int size) {
        if (ShmUtils.os != ShmUtils.OS.WINDOWS) {
            return null;
        }
        return new SharedMemoryWindows(name, create, size);
    }

    private static void cleanup(Pointer pointer, Pointer writePointer, WinNT.HANDLE handle) {
        if (!ShmWindows.isNull(writePointer)) {
            Kernel32.INSTANCE.UnmapViewOfFile(writePointer);
        }
        if (!ShmWindows.isNull(pointer)) {
            Kernel32.INSTANCE.UnmapViewOfFile(pointer);
        }
        if (handle != null) {
            Kernel32.INSTANCE.CloseHandle(handle);
        }
    }

    private static boolean isNull(Pointer p) {
        return p == null || p == Pointer.NULL;
    }

    private static class SharedMemoryWindows
    extends ShmBase<WinNT.HANDLE> {
        private SharedMemoryWindows(String name, boolean create, int size) {
            super(SharedMemoryWindows.prepareShm(name, create, size));
        }

        @Override
        protected void doClose() {
            ShmWindows.cleanup(this.info.pointer, this.info.writePointer, (WinNT.HANDLE)this.info.handle);
        }

        @Override
        protected void doUnlink() {
        }

        private static ShmBase.ShmInfo<WinNT.HANDLE> prepareShm(String name, boolean create, int size) {
            String shm_name;
            long prevSize;
            if (name == null) {
                while ((prevSize = SharedMemoryWindows.getSHMSize(shm_name = ShmUtils.make_filename(14, "wnsm_"))) >= 0L) {
                }
            } else {
                shm_name = name;
                prevSize = SharedMemoryWindows.getSHMSize(shm_name);
            }
            ShmUtils.checkSize(shm_name, prevSize, size);
            WinNT.HANDLE hMapFile = Kernel32.INSTANCE.CreateFileMapping(WinBase.INVALID_HANDLE_VALUE, null, 4, 0, size, shm_name);
            if (hMapFile == null) {
                throw new RuntimeException("Error creating shared memory array. CreateFileMapping failed: " + Kernel32.INSTANCE.GetLastError());
            }
            int shm_size = (int)SharedMemoryWindows.getSHMSize(hMapFile);
            Pointer pointer = Kernel32.INSTANCE.MapViewOfFile(hMapFile, 2, 0, 0, size);
            if (ShmWindows.isNull(pointer)) {
                Kernel32.INSTANCE.CloseHandle(hMapFile);
                throw new RuntimeException("Error creating shared memory array. " + Kernel32.INSTANCE.GetLastError());
            }
            Pointer writePointer = Kernel32.INSTANCE.VirtualAllocEx(Kernel32.INSTANCE.GetCurrentProcess(), pointer, new BaseTSD.SIZE_T((long)size), 4096, 4);
            if (ShmWindows.isNull(writePointer)) {
                ShmWindows.cleanup(pointer, writePointer, hMapFile);
                throw new RuntimeException("Error committing to the shared memory pages. Errno: " + Kernel32.INSTANCE.GetLastError());
            }
            ShmBase.ShmInfo<WinNT.HANDLE> info = new ShmBase.ShmInfo<WinNT.HANDLE>();
            info.size = shm_size;
            info.name = shm_name;
            info.pointer = pointer;
            info.writePointer = writePointer;
            info.handle = hMapFile;
            info.unlinkOnClose = create;
            return info;
        }

        private static boolean checkSHMExists(String name) {
            WinNT.HANDLE hMapFile = Kernel32.INSTANCE.OpenFileMapping(4, false, name);
            if (hMapFile == null) {
                return false;
            }
            Kernel32.INSTANCE.CloseHandle(hMapFile);
            return true;
        }

        private static long getSHMSize(String name) {
            WinNT.HANDLE hMapFile = Kernel32.INSTANCE.OpenFileMapping(4, false, name);
            if (hMapFile == null) {
                return -1L;
            }
            return SharedMemoryWindows.getSHMSize(hMapFile);
        }

        private static long getSHMSize(WinNT.HANDLE hMapFile) {
            if (hMapFile == null) {
                throw new NullPointerException("hMapFile is null.");
            }
            Pointer pSharedMemory = Kernel32.INSTANCE.MapViewOfFile(hMapFile, 4, 0, 0, 0);
            if (pSharedMemory == null) {
                Kernel32.INSTANCE.CloseHandle(hMapFile);
                throw new RuntimeException("MapViewOfFile failed with error: " + Kernel32.INSTANCE.GetLastError());
            }
            WinNT.MEMORY_BASIC_INFORMATION mbi = new WinNT.MEMORY_BASIC_INFORMATION();
            if (Kernel32.INSTANCE.VirtualQueryEx(Kernel32.INSTANCE.GetCurrentProcess(), pSharedMemory, mbi, new BaseTSD.SIZE_T((long)mbi.size())).intValue() == 0) {
                throw new RuntimeException("Failed to get shared memory segment size. Errno: " + Kernel32.INSTANCE.GetLastError());
            }
            int size = mbi.regionSize.intValue();
            Kernel32.INSTANCE.UnmapViewOfFile(pSharedMemory);
            Kernel32.INSTANCE.CloseHandle(hMapFile);
            return size;
        }
    }
}

