/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.utils.scenegraph.io.retained.StreamControl;
import org.jogamp.java3d.utils.universe.ConfiguredUniverse;

public class SceneGraphStreamReader {
    private StreamControl control;
    private DataInputStream in;

    public SceneGraphStreamReader(InputStream stream) throws IOException {
        this.in = new DataInputStream(stream);
        this.control = new StreamControl(this.in);
        this.control.readStreamHeader();
    }

    public ConfiguredUniverse readUniverse() throws IOException {
        return this.control.readUniverse(this.in, true, null);
    }

    public ConfiguredUniverse readUniverse(Canvas3D canvas) throws IOException {
        return this.control.readUniverse(this.in, true, canvas);
    }

    public BranchGroup readBranchGraph(HashMap namedObjects) throws IOException {
        return this.control.readBranchGraph(namedObjects);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.control.setClassLoader(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.control.getClassLoader();
    }

    public void close() throws IOException {
        this.in.close();
        this.control.close();
    }
}

