/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.CachedTargets;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.GroupRetained;
import org.jogamp.java3d.HashKey;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.J3dStructure;
import org.jogamp.java3d.ObjectUpdate;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.SwitchState;
import org.jogamp.java3d.TargetsInterface;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroupData;
import org.jogamp.java3d.TransformGroupRetained;
import org.jogamp.java3d.UnorderList;
import org.jogamp.java3d.UpdateTargets;
import org.jogamp.java3d.VirtualUniverse;

class TransformStructure
extends J3dStructure
implements ObjectUpdate {
    private HashSet<TransformData> transformSet = new HashSet();
    private ArrayList objectList = new ArrayList();
    private ArrayList blUsers = new ArrayList();
    private UpdateTargets targets = new UpdateTargets();
    private ArrayList collisionObjectList = new ArrayList();
    private ArrayList<TransformGroupRetained> dirtyTransformGroups = new ArrayList();
    private ArrayList keySet = new ArrayList();
    private ArrayList<TransformGroupRetained> activeTraverseList = new ArrayList();
    private ArrayList<TransformGroupRetained> switchDirtyTgList = new ArrayList(1);
    private boolean lazyUpdate = false;
    private ArrayList switchChangedList = new ArrayList();
    private boolean inUpdateObjectList = false;

    TransformStructure(VirtualUniverse u) {
        super(u, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void processMessages(long referenceTime) {
        Object[] messages = this.getMessages(referenceTime);
        int nMsg = this.getNumMessage();
        if (nMsg <= 0) {
            return;
        }
        this.targets.clearNodes();
        this.objectList.clear();
        this.blUsers.clear();
        this.inUpdateObjectList = false;
        Object object = this.universe.sceneGraphLock;
        synchronized (object) {
            J3dMessage m;
            int i;
            for (i = nMsg - 1; i >= 0; --i) {
                m = messages[i];
                if (m.type != 3) continue;
                this.transformSet.add(new TransformData((TransformGroupRetained)m.args[1], (Transform3D)m.args[2]));
            }
            for (i = 0; i < nMsg; ++i) {
                m = messages[i];
                switch (m.type) {
                    case 0: {
                        this.objectList.add(m.args[0]);
                        if (m.args[1] == null) break;
                        TargetsInterface ti = (TargetsInterface)m.args[1];
                        ti.updateCachedTargets(0, (CachedTargets[])m.args[2]);
                        break;
                    }
                    case 1: {
                        this.removeNodes(m);
                        break;
                    }
                    case 27: {
                        this.processSwitchChanged(m);
                        break;
                    }
                    case 24: {
                        this.objectList.add(m.args[3]);
                        if (m.args[4] == null) break;
                        TargetsInterface ti = (TargetsInterface)m.args[4];
                        ti.updateCachedTargets(0, (CachedTargets[])m.args[5]);
                        break;
                    }
                    case 17: {
                        this.objectList.add(m.args[0]);
                        break;
                    }
                    case 16: {
                        this.objectList.add(m.args[3]);
                        break;
                    }
                    case 26: {
                        this.objectList.add(m.args[1]);
                        Object[] tiArr = (Object[])m.args[2];
                        if (tiArr == null) break;
                        Object[] newCtArr = (Object[])m.args[3];
                        for (int j = 0; j < tiArr.length; ++j) {
                            TargetsInterface ti = (TargetsInterface)tiArr[j];
                            ti.updateCachedTargets(0, (CachedTargets[])newCtArr[j]);
                        }
                        break;
                    }
                    case 25: {
                        this.objectList.add(m.args[0]);
                        break;
                    }
                    case 37: {
                        this.processBoundsAutoComputeChanged(m);
                        break;
                    }
                    case 35: {
                        this.processRegionBoundChanged(m);
                        break;
                    }
                    case 34: {
                        this.processCollisionBoundChanged(m);
                    }
                }
                m.decRefcount();
            }
            this.processCurrentLocalToVworld();
            if (this.objectList.size() > 0) {
                this.processGeometryAtomVwcBounds();
            }
            this.processVwcBounds();
        }
        this.objectList.clear();
        Arrays.fill(messages, 0, nMsg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCurrentLocalToVworld() {
        this.lazyUpdate = false;
        int tSize = this.transformSet.size();
        int sSize = this.switchDirtyTgList.size();
        if (tSize <= 0 && sSize <= 0) {
            return;
        }
        if (tSize > 0) {
            for (TransformData lData : this.transformSet) {
                TransformGroupRetained tg = lData.getTransformGroupRetained();
                tg.currentTransform.set(lData.getTransform3D());
                TransformGroupRetained transformGroupRetained = tg;
                synchronized (transformGroupRetained) {
                    if (tg.perPathData != null) {
                        TransformGroupData data;
                        if (!tg.inSharedGroup) {
                            data = tg.perPathData[0];
                            if (!data.switchState.inSwitch) {
                                this.activeTraverseList.add(tg);
                                data.markedDirty = true;
                                data.switchDirty = false;
                            } else if (data.switchState.currentSwitchOn) {
                                this.activeTraverseList.add(tg);
                                data.switchDirty = false;
                                data.markedDirty = true;
                            } else {
                                data.switchDirty = true;
                                data.markedDirty = false;
                            }
                        } else {
                            int npaths = tg.perPathData.length;
                            boolean added = false;
                            for (int k = 0; k < npaths; ++k) {
                                data = tg.perPathData[k];
                                if (!data.switchState.inSwitch) {
                                    if (!added) {
                                        added = true;
                                        this.activeTraverseList.add(tg);
                                    }
                                    data.markedDirty = true;
                                    data.switchDirty = false;
                                    continue;
                                }
                                if (data.switchState.currentSwitchOn) {
                                    if (!added) {
                                        added = true;
                                        this.activeTraverseList.add(tg);
                                    }
                                    data.switchDirty = false;
                                    data.markedDirty = true;
                                    continue;
                                }
                                data.switchDirty = true;
                                data.markedDirty = false;
                            }
                        }
                    }
                }
            }
        }
        if (sSize > 0) {
            this.activeTraverseList.addAll(this.switchDirtyTgList);
            this.switchDirtyTgList.clear();
            this.lazyUpdate = true;
        }
        tSize = this.activeTraverseList.size();
        TransformGroupRetained[] tgs = this.activeTraverseList.toArray(new TransformGroupRetained[tSize]);
        if (tSize > 0) {
            this.sortTransformGroups(tSize, tgs);
            for (int i = 0; i < tSize; ++i) {
                tgs[i].processChildLocalToVworld(this.dirtyTransformGroups, this.keySet, this.targets, this.blUsers);
            }
            if (!this.inUpdateObjectList) {
                VirtualUniverse.mc.addMirrorObject(this);
                this.inUpdateObjectList = true;
            }
        }
        this.transformSet.clear();
        this.activeTraverseList.clear();
    }

    private void sortTransformGroups(int size, TransformGroupRetained[] tgs) {
        if (size < 7) {
            this.insertSort(size, tgs);
        } else {
            this.quicksort(0, size - 1, tgs);
        }
    }

    private void insertSort(int size, TransformGroupRetained[] tgs) {
        for (int i = 0; i < size; ++i) {
            for (int j = i; j > 0 && tgs[j - 1].maxTransformLevel > tgs[j].maxTransformLevel; --j) {
                TransformGroupRetained tmptg = tgs[j];
                tgs[j] = tgs[j - 1];
                tgs[j - 1] = tmptg;
            }
        }
    }

    private void quicksort(int l, int r, TransformGroupRetained[] tgs) {
        int i = l;
        int j = r;
        double k = tgs[(l + r) / 2].maxTransformLevel;
        while (true) {
            if ((double)tgs[i].maxTransformLevel < k) {
                ++i;
                continue;
            }
            while (k < (double)tgs[j].maxTransformLevel) {
                --j;
            }
            if (i <= j) {
                TransformGroupRetained tmptg = tgs[i];
                tgs[i] = tgs[j];
                tgs[j] = tmptg;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (l < j) {
            this.quicksort(l, j, tgs);
        }
        if (l < r) {
            this.quicksort(i, r, tgs);
        }
    }

    @Override
    public void updateObject() {
        this.processLastLocalToVworld();
        this.processLastSwitchOn();
    }

    void processLastSwitchOn() {
        int size = this.switchChangedList.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                SwitchState switchState = (SwitchState)this.switchChangedList.get(i);
                switchState.updateLastSwitchOn();
            }
            this.switchChangedList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processLastLocalToVworld() {
        int dTGSize = this.dirtyTransformGroups.size();
        int k = 0;
        for (int i = 0; i < dTGSize; ++i) {
            TransformGroupRetained tg;
            TransformGroupRetained transformGroupRetained = tg = this.dirtyTransformGroups.get(i);
            synchronized (transformGroupRetained) {
                if (tg.childLocalToVworld != null) {
                    if (tg.inSharedGroup) {
                        int j;
                        HashKey key = (HashKey)this.keySet.get(k++);
                        for (j = 0; j < tg.localToVworldKeys.length && !tg.localToVworldKeys[j].equals((Object)key); ++j) {
                        }
                        if (j < tg.localToVworldKeys.length) {
                            tg.childLocalToVworldIndex[j][0] = tg.childLocalToVworldIndex[j][1];
                        }
                    } else {
                        tg.childLocalToVworldIndex[0][0] = tg.childLocalToVworldIndex[0][1];
                    }
                }
                continue;
            }
        }
        this.dirtyTransformGroups.clear();
        this.keySet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processGeometryAtomVwcBounds() {
        Shape3DRetained ms;
        GeometryAtom ga;
        Object object;
        int j;
        Object[] nodes;
        int i;
        int oSize = this.objectList.size();
        for (i = 0; i < oSize; ++i) {
            nodes = (Object[])this.objectList.get(i);
            for (j = 0; j < nodes.length; ++j) {
                object = nodes[j];
                synchronized (object) {
                    if (nodes[j] instanceof GeometryAtom) {
                        ga = (GeometryAtom)nodes[j];
                        ms = ga.source;
                        Bounds bounds = ms.bounds;
                        synchronized (bounds) {
                            ms.vwcBounds.transform(ms.bounds, ms.getCurrentLocalToVworld(0));
                        }
                        if (ms.collisionBound != null) {
                            ms.collisionVwcBound.transform(ms.collisionBound, ms.getCurrentLocalToVworld(0));
                        }
                        ga.centroidIsDirty = true;
                    } else if (nodes[j] instanceof GroupRetained) {
                        GroupRetained g = (GroupRetained)nodes[j];
                        Bounds bound = g.sourceNode.collisionBound != null ? g.sourceNode.collisionBound : g.sourceNode.getEffectiveBounds();
                        g.collisionVwcBounds.transform(bound, g.getCurrentLocalToVworld());
                    }
                    continue;
                }
            }
        }
        for (i = 0; i < this.collisionObjectList.size(); ++i) {
            nodes = (Object[])this.collisionObjectList.get(i);
            for (j = 0; j < nodes.length; ++j) {
                object = nodes[j];
                synchronized (object) {
                    if (nodes[j] instanceof GeometryAtom) {
                        ga = (GeometryAtom)nodes[j];
                        ms = ga.source;
                        if (ms.collisionVwcBound != null) {
                            ms.collisionVwcBound.transform(ms.collisionBound, ms.getCurrentLocalToVworld(0));
                        }
                    }
                    continue;
                }
            }
        }
        this.collisionObjectList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processVwcBounds() {
        Shape3DRetained ms;
        GeometryAtom ga;
        Object object;
        int j;
        Object[] nodes;
        int i;
        Object[] nodesArr;
        int size;
        UnorderList arrList = this.targets.targetList[0];
        if (arrList != null) {
            size = arrList.size();
            nodesArr = arrList.toArray(false);
            for (i = 0; i < size; ++i) {
                nodes = (Object[])nodesArr[i];
                for (j = 0; j < nodes.length; ++j) {
                    object = nodes[j];
                    synchronized (object) {
                        ga = (GeometryAtom)nodes[j];
                        ms = ga.source;
                        Bounds bounds = ms.bounds;
                        synchronized (bounds) {
                            ms.vwcBounds.transform(ms.bounds, ms.getCurrentLocalToVworld(0));
                        }
                        if (ms.collisionBound != null) {
                            ms.collisionVwcBound.transform(ms.collisionBound, ms.getCurrentLocalToVworld(0));
                        }
                        ga.centroidIsDirty = true;
                        continue;
                    }
                }
            }
        }
        if ((arrList = this.targets.targetList[6]) != null) {
            size = arrList.size();
            nodesArr = arrList.toArray(false);
            for (i = 0; i < size; ++i) {
                nodes = (Object[])nodesArr[i];
                for (j = 0; j < nodes.length; ++j) {
                    GroupRetained g = (GroupRetained)nodes[j];
                    Bounds bound = g.sourceNode.collisionBound != null ? g.sourceNode.collisionBound : g.sourceNode.getEffectiveBounds();
                    g.collisionVwcBounds.transform(bound, g.getCurrentLocalToVworld());
                }
            }
        }
        for (i = 0; i < this.collisionObjectList.size(); ++i) {
            nodes = (Object[])this.collisionObjectList.get(i);
            for (j = 0; j < nodes.length; ++j) {
                object = nodes[j];
                synchronized (object) {
                    if (nodes[j] instanceof GeometryAtom) {
                        ga = (GeometryAtom)nodes[j];
                        ms = ga.source;
                        if (ms.collisionVwcBound != null) {
                            ms.collisionVwcBound.transform(ms.collisionBound, ms.getCurrentLocalToVworld(0));
                        }
                    }
                    continue;
                }
            }
        }
        this.collisionObjectList.clear();
    }

    void processRegionBoundChanged(J3dMessage m) {
        this.processBoundsChanged((Object[])m.args[0], (Bounds)m.args[1]);
    }

    void processBoundsChanged(Object[] gaArray, Bounds updateBounds) {
        for (int i = 0; i < gaArray.length; ++i) {
            GeometryAtom ga = (GeometryAtom)gaArray[i];
            Shape3DRetained ms = ga.source;
            ms.bounds = updateBounds;
            if (ms.collisionBound != null) continue;
            ms.collisionVwcBound = ms.vwcBounds;
        }
        this.objectList.add(gaArray);
    }

    void processCollisionBoundChanged(J3dMessage m) {
        Bounds collisionBound = (Bounds)m.args[1];
        if (m.args[0] instanceof GroupRetained) {
            GroupRetained g = (GroupRetained)m.args[0];
            if (g.mirrorGroup != null) {
                this.objectList.add(g.mirrorGroup.toArray());
            }
        } else {
            Object[] gaArray = (Object[])m.args[0];
            for (int i = 0; i < gaArray.length; ++i) {
                GeometryAtom ga = (GeometryAtom)gaArray[i];
                Shape3DRetained ms = ga.source;
                ms.collisionBound = collisionBound;
                ms.collisionVwcBound = ms.collisionBound != null ? (Bounds)ms.collisionBound.clone() : ms.vwcBounds;
            }
            this.collisionObjectList.add(gaArray);
        }
    }

    void processBoundsAutoComputeChanged(J3dMessage m) {
        this.processBoundsChanged((Object[])m.args[0], (Bounds)m.args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSwitchChanged(J3dMessage m) {
        ArrayList switchList = (ArrayList)m.args[2];
        int size = switchList.size();
        if (size > 0) {
            for (int j = 0; j < size; ++j) {
                SwitchState switchState = (SwitchState)switchList.get(j);
                switchState.updateCurrentSwitchOn();
            }
            UpdateTargets targets = (UpdateTargets)m.args[0];
            UnorderList arrList = targets.targetList[6];
            if (arrList != null) {
                Object[] nodesArr = arrList.toArray(false);
                int aSize = arrList.size();
                for (int j = 0; j < aSize; ++j) {
                    Object[] nodes = (Object[])nodesArr[j];
                    for (int i = 0; i < nodes.length; ++i) {
                        TransformGroupRetained tg;
                        boolean added = false;
                        TransformGroupRetained transformGroupRetained = tg = (TransformGroupRetained)nodes[i];
                        synchronized (transformGroupRetained) {
                            if (tg.perPathData != null) {
                                for (TransformGroupData data : tg.perPathData) {
                                    if (!data.switchState.currentSwitchOn || !data.switchDirty) continue;
                                    if (!added) {
                                        this.switchDirtyTgList.add(tg);
                                        added = true;
                                    }
                                    data.switchDirty = false;
                                    data.markedDirty = true;
                                }
                            }
                            continue;
                        }
                    }
                }
            }
            this.switchChangedList.addAll(switchList);
            if (!this.inUpdateObjectList) {
                VirtualUniverse.mc.addMirrorObject(this);
                this.inUpdateObjectList = true;
            }
        }
    }

    UpdateTargets getTargetList() {
        return this.targets;
    }

    ArrayList getBlUsers() {
        return this.blUsers;
    }

    boolean getLazyUpdate() {
        return this.lazyUpdate;
    }

    @Override
    void removeNodes(J3dMessage m) {
        if (m.args[1] != null) {
            TargetsInterface ti = (TargetsInterface)m.args[1];
            ti.updateCachedTargets(0, (CachedTargets[])m.args[2]);
        }
    }

    @Override
    void cleanup() {
    }

    private class TransformData {
        private TransformGroupRetained transformGroupRetained;
        private Transform3D transform3D;

        TransformData(TransformGroupRetained tgr, Transform3D t3d) {
            this.transformGroupRetained = tgr;
            this.transform3D = t3d;
        }

        public int hashCode() {
            return this.transformGroupRetained.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof TransformData)) {
                return false;
            }
            return this.transformGroupRetained.equals(((TransformData)o).getTransformGroupRetained());
        }

        TransformGroupRetained getTransformGroupRetained() {
            return this.transformGroupRetained;
        }

        Transform3D getTransform3D() {
            return this.transform3D;
        }
    }
}

