/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.table;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import org.scijava.table.DefaultDoubleTable;
import org.scijava.table.DoubleTable;

public class TableLoader {
    private int rows;
    private int cols;

    public DoubleTable valuesFromTextFile(BufferedInputStream str) throws IOException {
        this.countRowsAndCols(str);
        if (this.rows == 0) {
            return null;
        }
        DefaultDoubleTable values = new DefaultDoubleTable(this.cols, this.rows);
        str.reset();
        this.read(str, values);
        int firstRowNaNCount = 0;
        for (int i = 0; i < this.cols; ++i) {
            if (!Double.isNaN(values.getValue(i, 0))) continue;
            ++firstRowNaNCount;
        }
        if (firstRowNaNCount == this.cols) {
            --this.rows;
            DefaultDoubleTable oldValues = values;
            values = new DefaultDoubleTable(this.cols, this.rows);
            for (int c = 0; c < this.cols; ++c) {
                String colHeader = oldValues.getColumnHeader(c);
                values.setColumnHeader(c, colHeader);
            }
            for (int row = 0; row < this.rows; ++row) {
                for (int col = 0; col < this.cols; ++col) {
                    double val = oldValues.getValue(col, row + 1);
                    values.setValue(col, row, val);
                }
            }
        }
        return values;
    }

    public DoubleTable valuesFromTextFile(String urlString) throws IOException {
        return this.valuesFromTextFile(new URL(urlString));
    }

    public DoubleTable valuesFromTextFile(File file) throws IOException {
        FileInputStream fstr = new FileInputStream(file);
        BufferedInputStream stream = new BufferedInputStream(fstr);
        stream.mark((int)file.length());
        return this.valuesFromTextFile(stream);
    }

    public DoubleTable valuesFromTextFile(URL url) throws IOException {
        InputStream istr = url.openStream();
        BufferedInputStream stream = new BufferedInputStream(istr);
        stream.mark(8000000);
        return this.valuesFromTextFile(stream);
    }

    private void countRowsAndCols(InputStream str) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(str));
        StreamTokenizer tok = new StreamTokenizer(r);
        tok.resetSyntax();
        tok.wordChars(43, 43);
        tok.wordChars(45, 126);
        tok.whitespaceChars(0, 42);
        tok.whitespaceChars(44, 44);
        tok.whitespaceChars(127, 255);
        tok.eolIsSignificant(true);
        int words = 0;
        int wordsPrevLine = 0;
        while (tok.nextToken() != -1) {
            switch (tok.ttype) {
                case 10: {
                    ++this.rows;
                    if (words == 0) {
                        --this.rows;
                    }
                    if (this.rows == 1 && words > 0) {
                        this.cols = words;
                    }
                    if (this.rows > 1 && words != 0 && words != wordsPrevLine) {
                        throw new IOException("Line " + this.rows + " is not the same length as the first line.");
                    }
                    if (words != 0) {
                        wordsPrevLine = words;
                    }
                    words = 0;
                    break;
                }
                case -3: {
                    ++words;
                }
            }
        }
        if (words == this.cols) {
            ++this.rows;
        }
    }

    private void read(InputStream str, DoubleTable values) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(str));
        StreamTokenizer tok = new StreamTokenizer(r);
        tok.resetSyntax();
        tok.wordChars(43, 43);
        tok.wordChars(45, 126);
        tok.whitespaceChars(0, 42);
        tok.whitespaceChars(44, 44);
        tok.whitespaceChars(127, 255);
        int row = 0;
        int col = 0;
        while (tok.nextToken() != -1) {
            double value;
            block3: {
                if (tok.ttype != -3) continue;
                try {
                    value = Double.parseDouble(tok.sval);
                }
                catch (NumberFormatException e) {
                    value = Double.NaN;
                    if (row != 0) break block3;
                    values.setColumnHeader(col, tok.sval);
                }
            }
            values.setValue(col, row, value);
            if (++col != this.cols) continue;
            ++row;
            col = 0;
        }
    }
}

