/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.crop;

import edu.utexas.clm.crop.AreaListCrop;
import ij.IJ;
import ij.gui.GenericDialog;
import ini.trakem2.display.AreaList;
import ini.trakem2.plugin.TPlugIn;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class AreaList_Crop
implements TPlugIn {
    private static AreaListCrop areaListCrop = null;
    private static Frame frame = null;
    private static Label areaNameLabel = null;

    private static void cancel() {
        GenericDialog gd = new GenericDialog("Cancel?");
        gd.addMessage("Really Cancel?");
        gd.showDialog();
        boolean ok = gd.wasOKed();
        if (ok) {
            AreaList_Crop.clear();
        }
    }

    private static void clear() {
        frame.setVisible(false);
        frame.removeAll();
        areaListCrop = null;
        frame = null;
        areaNameLabel = null;
    }

    public void init() {
        Panel panel = new Panel();
        Panel buttonPanel = new Panel();
        final Button okButton = new Button("Create");
        final Button cancelButton = new Button("Cancel");
        areaListCrop = new AreaListCrop(){

            @Override
            protected void progress(double p) {
                IJ.showStatus((String)"AreaList crop");
                areaNameLabel.setText("Processing " + (int)(100.0 * p) + "%");
            }
        };
        frame = new Frame("Do Crop");
        areaNameLabel = new Label("");
        areaNameLabel.setSize(new Dimension(120, 240));
        areaNameLabel.setPreferredSize(new Dimension(120, 240));
        panel.setLayout(new GridLayout(2, 1));
        panel.setSize(new Dimension(240, 240));
        panel.setPreferredSize(new Dimension(240, 240));
        buttonPanel.setSize(new Dimension(240, 64));
        buttonPanel.setPreferredSize(new Dimension(240, 64));
        buttonPanel.add(cancelButton);
        buttonPanel.add(okButton);
        panel.add(areaNameLabel);
        panel.add(buttonPanel);
        frame.add(panel);
        frame.setSize(new Dimension(240, 240));
        frame.addWindowListener(new WindowCloseAdapter());
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                okButton.setEnabled(false);
                cancelButton.setEnabled(false);
                new Thread(){

                    @Override
                    public void run() {
                        GenericDialog gd = new GenericDialog("Background Value");
                        gd.addNumericField("Background Value (0-255)", 255.0, 0);
                        gd.showDialog();
                        if (gd.wasOKed()) {
                            int val = (int)gd.getNextNumber();
                            val = val > 255 ? 255 : (val < 0 ? 0 : val);
                            areaNameLabel.setText(areaNameLabel.getText() + ". Processing...");
                            areaListCrop.getCropImage(val).show();
                            AreaList_Crop.clear();
                        }
                    }
                }.start();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaList_Crop.cancel();
            }
        });
        frame.validate();
        frame.setVisible(true);
    }

    public boolean setup(Object ... params) {
        return true;
    }

    public Object invoke(Object ... params) {
        if (areaListCrop == null) {
            this.init();
        }
        for (Object ob : params) {
            if (!(ob instanceof AreaList)) continue;
            AreaList al = (AreaList)ob;
            String list = "";
            areaListCrop.addAreaList(al);
            for (AreaList areaList : areaListCrop.getAreaLists()) {
                if (list.equals("")) {
                    list = areaList.getProject().findProjectThing((Object)areaList).getParent().getTitle();
                    continue;
                }
                list = list + ", " + areaList.getProject().findProjectThing((Object)areaList).getParent().getTitle();
            }
            areaNameLabel.setText(list);
            frame.validate();
        }
        return null;
    }

    public boolean applies(Object ob) {
        return ob != null && ob instanceof AreaList;
    }

    private class WindowCloseAdapter
    extends WindowAdapter {
        private WindowCloseAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            AreaList_Crop.cancel();
        }
    }
}

