/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.dirgra;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jruby.dirgra.Edge;
import org.jruby.dirgra.ExplicitVertexID;

public class EdgeTypeIterator<T extends ExplicitVertexID>
implements Iterator<Edge<T>> {
    private Edge<T>[] edges;
    private int edgesLength;
    private int edgeIteratorIndex = 0;
    private Object type;
    private Edge nextEdge = null;
    private boolean negate;

    public EdgeTypeIterator(Edge<T>[] edges, int edgesLength, Object type, boolean negate) {
        this.edges = edges;
        this.edgesLength = edgesLength;
        this.type = type;
        this.negate = negate;
    }

    @Override
    public boolean hasNext() {
        if (this.nextEdge != null) {
            return true;
        }
        for (int i = this.edgeIteratorIndex; i < this.edgesLength; ++i) {
            Edge<T> edge = this.edges[i];
            Object edgeType = edge.getType();
            if (this.negate) {
                if ((edgeType == null || edgeType.equals(this.type)) && (edgeType != null || edgeType == this.type)) continue;
                this.nextEdge = edge;
                this.edgeIteratorIndex = i + 1;
                return true;
            }
            if ((edgeType == null || !edgeType.equals(this.type)) && (edgeType != null || edgeType != this.type)) continue;
            this.nextEdge = edge;
            this.edgeIteratorIndex = i + 1;
            return true;
        }
        this.edgeIteratorIndex = this.edgesLength;
        return false;
    }

    @Override
    public Edge<T> next() {
        if (this.hasNext()) {
            Edge tmp = this.nextEdge;
            this.nextEdge = null;
            return tmp;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }
}

