/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.kdtree.node;

import mpicbg.imglib.algorithm.kdtree.node.Leaf;

public class SimpleNode
implements Leaf<SimpleNode> {
    final float[] p;
    final int numDimensions;

    public SimpleNode(SimpleNode node) {
        this.p = (float[])node.p.clone();
        this.numDimensions = this.p.length;
    }

    public SimpleNode(float[] p) {
        this.p = (float[])p.clone();
        this.numDimensions = p.length;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public boolean equals(SimpleNode o) {
        if (o.getNumDimensions() != this.numDimensions) {
            return false;
        }
        for (int d = 0; d < this.numDimensions; ++d) {
            if (this.p[d] == o.p[d]) continue;
            return false;
        }
        return true;
    }

    @Override
    public float distanceTo(SimpleNode o) {
        double dist = 0.0;
        for (int d = 0; d < this.numDimensions; ++d) {
            double v = o.get(d) - this.get(d);
            dist += v * v;
        }
        return (float)Math.sqrt(dist);
    }

    @Override
    public float get(int k) {
        return this.p[k];
    }

    public String toString() {
        String s = "(" + this.p[0];
        for (int d = 1; d < this.numDimensions; ++d) {
            s = s + ", " + this.p[d];
        }
        s = s + ")";
        return s;
    }

    public SimpleNode[] createArray(int n) {
        return new SimpleNode[n];
    }

    @Override
    public int getNumDimensions() {
        return this.numDimensions;
    }

    @Override
    public SimpleNode getEntry() {
        return this;
    }
}

