/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.roi;

import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.roi.MorphDilate;
import mpicbg.imglib.algorithm.roi.MorphErode;
import mpicbg.imglib.algorithm.roi.StructuringElement;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

public class MorphClose<T extends RealType<T>>
implements OutputAlgorithm<T>,
Benchmark {
    private final Image<T> image;
    private Image<T> outputImage;
    private final MorphDilate<T> dilater;
    private MorphErode<T> eroder;
    private final StructuringElement strel;
    private final OutOfBoundsStrategyFactory<T> outsideFactory;
    private long pTime;

    public MorphClose(Image<T> imageIn, StructuringElement strelIn) {
        this(imageIn, strelIn, null);
    }

    public MorphClose(Image<T> imageIn, StructuringElement strelIn, OutOfBoundsStrategyFactory<T> inOutsideFactory) {
        this.image = imageIn;
        this.strel = strelIn;
        this.dilater = new MorphDilate<T>(this.image, this.strel, inOutsideFactory);
        this.eroder = null;
        this.outputImage = null;
        this.outsideFactory = inOutsideFactory;
        this.pTime = 0L;
    }

    @Override
    public Image<T> getResult() {
        return this.outputImage;
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        String errorMsg = "";
        errorMsg = errorMsg + this.dilater.getErrorMessage();
        if (this.eroder != null) {
            errorMsg = errorMsg + this.eroder.getErrorMessage();
        }
        return errorMsg;
    }

    @Override
    public boolean process() {
        long sTime = System.currentTimeMillis();
        this.pTime = 0L;
        boolean rVal = false;
        if (this.dilater.process()) {
            this.eroder = new MorphErode(this.dilater.getResult(), this.strel, this.outsideFactory);
            this.eroder.setName(this.image.getName() + " Closed");
            rVal = this.eroder.process();
        }
        this.outputImage = rVal ? this.eroder.getResult() : null;
        this.pTime = System.currentTimeMillis() - sTime;
        return rVal;
    }

    @Override
    public long getProcessingTime() {
        return this.pTime;
    }
}

