/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.array;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.PixelGridContainerImpl;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.array.Array3D;
import mpicbg.imglib.container.basictypecontainer.BitAccess;
import mpicbg.imglib.container.basictypecontainer.ByteAccess;
import mpicbg.imglib.container.basictypecontainer.CharAccess;
import mpicbg.imglib.container.basictypecontainer.DoubleAccess;
import mpicbg.imglib.container.basictypecontainer.FloatAccess;
import mpicbg.imglib.container.basictypecontainer.IntAccess;
import mpicbg.imglib.container.basictypecontainer.LongAccess;
import mpicbg.imglib.container.basictypecontainer.ShortAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;
import mpicbg.imglib.container.basictypecontainer.array.BitArray;
import mpicbg.imglib.container.basictypecontainer.array.ByteArray;
import mpicbg.imglib.container.basictypecontainer.array.CharArray;
import mpicbg.imglib.container.basictypecontainer.array.DoubleArray;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.container.basictypecontainer.array.IntArray;
import mpicbg.imglib.container.basictypecontainer.array.LongArray;
import mpicbg.imglib.container.basictypecontainer.array.NIOByteArray;
import mpicbg.imglib.container.basictypecontainer.array.NIOCharArray;
import mpicbg.imglib.container.basictypecontainer.array.NIODoubleArray;
import mpicbg.imglib.container.basictypecontainer.array.NIOFloatArray;
import mpicbg.imglib.container.basictypecontainer.array.NIOIntArray;
import mpicbg.imglib.container.basictypecontainer.array.NIOLongArray;
import mpicbg.imglib.container.basictypecontainer.array.NIOShortArray;
import mpicbg.imglib.container.basictypecontainer.array.ShortArray;
import mpicbg.imglib.type.Type;

public class ArrayContainerFactory
extends DirectAccessContainerFactory {
    protected boolean useNIO = false;

    public void setNIOUse(boolean useNIO) {
        this.useNIO = useNIO;
    }

    public boolean useNIO() {
        return this.useNIO;
    }

    public <T extends Type<T>> DirectAccessContainer<T, BitAccess> createBitInstance(int[] dimensions, int entitiesPerPixel) {
        if (this.useNIO) {
            throw new IllegalStateException("Cannot create NIO bit arrays");
        }
        int numPixels = PixelGridContainerImpl.getNumEntities(dimensions, entitiesPerPixel);
        BitArray access = new BitArray(numPixels);
        if (dimensions.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, access, dimensions[0], dimensions[1], dimensions[2], entitiesPerPixel);
        }
        return new Array(this, access, dimensions, entitiesPerPixel);
    }

    public <T extends Type<T>> DirectAccessContainer<T, ByteAccess> createByteInstance(int[] dimensions, int entitiesPerPixel) {
        int numPixels = PixelGridContainerImpl.getNumEntities(dimensions, entitiesPerPixel);
        ByteAccess access = this.useNIO ? new NIOByteArray(numPixels) : new ByteArray(numPixels);
        if (dimensions.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, (NIOByteArray)access, dimensions[0], dimensions[1], dimensions[2], entitiesPerPixel);
        }
        return new Array(this, (NIOByteArray)access, dimensions, entitiesPerPixel);
    }

    public <T extends Type<T>> DirectAccessContainer<T, CharAccess> createCharInstance(int[] dimensions, int entitiesPerPixel) {
        int numPixels = PixelGridContainerImpl.getNumEntities(dimensions, entitiesPerPixel);
        ArrayDataAccess<NIOCharArray> access = this.useNIO ? new NIOCharArray(numPixels) : new CharArray(numPixels);
        if (dimensions.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, (NIOCharArray)access, dimensions[0], dimensions[1], dimensions[2], entitiesPerPixel);
        }
        return new Array(this, (NIOCharArray)access, dimensions, entitiesPerPixel);
    }

    public <T extends Type<T>> DirectAccessContainer<T, DoubleAccess> createDoubleInstance(int[] dimensions, int entitiesPerPixel) {
        int numPixels = PixelGridContainerImpl.getNumEntities(dimensions, entitiesPerPixel);
        ArrayDataAccess<NIODoubleArray> access = this.useNIO ? new NIODoubleArray(numPixels) : new DoubleArray(numPixels);
        if (dimensions.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, (NIODoubleArray)access, dimensions[0], dimensions[1], dimensions[2], entitiesPerPixel);
        }
        return new Array(this, (NIODoubleArray)access, dimensions, entitiesPerPixel);
    }

    public <T extends Type<T>> DirectAccessContainer<T, FloatAccess> createFloatInstance(int[] dimensions, int entitiesPerPixel) {
        int numPixels = PixelGridContainerImpl.getNumEntities(dimensions, entitiesPerPixel);
        ArrayDataAccess<NIOFloatArray> access = this.useNIO ? new NIOFloatArray(numPixels) : new FloatArray(numPixels);
        if (dimensions.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, (NIOFloatArray)access, dimensions[0], dimensions[1], dimensions[2], entitiesPerPixel);
        }
        return new Array(this, (NIOFloatArray)access, dimensions, entitiesPerPixel);
    }

    public <T extends Type<T>> DirectAccessContainer<T, IntAccess> createIntInstance(int[] dimensions, int entitiesPerPixel) {
        int numPixels = PixelGridContainerImpl.getNumEntities(dimensions, entitiesPerPixel);
        IntAccess access = this.useNIO ? new NIOIntArray(numPixels) : new IntArray(numPixels);
        if (dimensions.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, (NIOIntArray)access, dimensions[0], dimensions[1], dimensions[2], entitiesPerPixel);
        }
        return new Array(this, (NIOIntArray)access, dimensions, entitiesPerPixel);
    }

    public <T extends Type<T>> DirectAccessContainer<T, LongAccess> createLongInstance(int[] dimensions, int entitiesPerPixel) {
        int numPixels = PixelGridContainerImpl.getNumEntities(dimensions, entitiesPerPixel);
        LongAccess access = this.useNIO ? new NIOLongArray(numPixels) : new LongArray(numPixels);
        if (dimensions.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, (NIOLongArray)access, dimensions[0], dimensions[1], dimensions[2], entitiesPerPixel);
        }
        return new Array(this, (NIOLongArray)access, dimensions, entitiesPerPixel);
    }

    public <T extends Type<T>> DirectAccessContainer<T, ShortAccess> createShortInstance(int[] dimensions, int entitiesPerPixel) {
        int numPixels = PixelGridContainerImpl.getNumEntities(dimensions, entitiesPerPixel);
        ShortAccess access = this.useNIO ? new NIOShortArray(numPixels) : new ShortArray(numPixels);
        if (dimensions.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, (NIOShortArray)access, dimensions[0], dimensions[1], dimensions[2], entitiesPerPixel);
        }
        return new Array(this, (NIOShortArray)access, dimensions, entitiesPerPixel);
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public void printProperties() {
    }

    @Override
    public void setParameters(String configuration) {
    }
}

