/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.special;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.cursor.CursorImpl;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;

public class LocalNeighborhoodCursor<T extends Type<T>>
extends CursorImpl<T> {
    final ArrayLocalizableCursor<FakeType> neigborhoodCursor;
    final LocalizableByDimCursor<T> cursor;
    final int[] position;
    final int[] tmp;
    final int numDimensions;
    final int centralPositionIndex;
    boolean isActive;
    boolean debug = false;

    public LocalNeighborhoodCursor(LocalizableByDimCursor<T> cursor) {
        super(cursor.getStorageContainer(), cursor.getImage());
        int d;
        this.cursor = cursor;
        this.position = cursor.getPosition();
        this.numDimensions = cursor.getImage().getNumDimensions();
        this.tmp = new int[this.numDimensions];
        int[] dim = new int[this.numDimensions];
        for (d = 0; d < this.numDimensions; ++d) {
            dim[d] = 3;
        }
        this.neigborhoodCursor = ArrayLocalizableCursor.createLinearCursor(dim);
        this.isActive = true;
        for (d = 0; d < this.numDimensions; ++d) {
            dim[d] = 1;
        }
        this.centralPositionIndex = ((Array)this.neigborhoodCursor.getStorageContainer()).getPos(dim);
    }

    @Override
    public boolean hasNext() {
        return this.neigborhoodCursor.hasNext();
    }

    @Override
    public void close() {
        this.neigborhoodCursor.close();
        this.isActive = false;
    }

    public void update() {
        this.cursor.getPosition(this.position);
        this.neigborhoodCursor.reset();
    }

    @Override
    public T getType() {
        return this.cursor.getType();
    }

    @Override
    public void reset() {
        this.cursor.setPosition(this.position);
        this.neigborhoodCursor.reset();
    }

    @Override
    public void fwd() {
        this.neigborhoodCursor.fwd();
        if (((FakeType)this.neigborhoodCursor.getType()).getIndex() == this.centralPositionIndex) {
            this.neigborhoodCursor.fwd();
        }
        this.neigborhoodCursor.getPosition(this.tmp);
        for (int d = 0; d < this.numDimensions; ++d) {
            this.tmp[d] = this.position[d] + (this.tmp[d] - 1);
        }
        this.cursor.moveTo(this.tmp);
    }

    public LocalizableByDimCursor<T> getParentCursor() {
        return this.cursor;
    }

    public int getRelativePosition(int d) {
        return this.neigborhoodCursor.getPosition(d);
    }

    @Override
    public int getArrayIndex() {
        return this.cursor.getArrayIndex();
    }

    @Override
    public int getStorageIndex() {
        return this.cursor.getStorageIndex();
    }

    @Override
    public boolean isActive() {
        return this.cursor.isActive() && this.isActive;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

