/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.special;

import mpicbg.imglib.cursor.CursorImpl;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.util.Util;

public class RegionOfInterestCursor<T extends Type<T>>
extends CursorImpl<T>
implements LocalizableCursor<T> {
    final LocalizableByDimCursor<T> cursor;
    final int[] offset;
    final int[] size;
    final int[] roiPosition;
    final boolean[] currentDirectionDim;
    final int numDimensions;
    final int numPixels;
    final int numPixelsMinus1;
    boolean isActive;
    boolean debug = false;
    int i;

    public RegionOfInterestCursor(LocalizableByDimCursor<T> cursor, int[] offset, int[] size) {
        super(cursor.getStorageContainer(), cursor.getImage());
        this.offset = (int[])offset.clone();
        this.size = (int[])size.clone();
        this.cursor = cursor;
        this.numDimensions = cursor.getImage().getNumDimensions();
        this.roiPosition = new int[this.numDimensions];
        this.currentDirectionDim = new boolean[this.numDimensions];
        int count = 1;
        for (int d = 0; d < this.numDimensions; ++d) {
            count *= size[d];
        }
        this.numPixels = count;
        this.numPixelsMinus1 = count - 1;
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.i < this.numPixelsMinus1;
    }

    @Override
    public void close() {
        this.isActive = false;
    }

    @Override
    public T getType() {
        return this.cursor.getType();
    }

    public void reset(int[] o) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.offset[d] = o[d];
        }
        this.reset();
    }

    public void reset(int[] o, int[] s) {
        int d;
        for (d = 0; d < this.numDimensions; ++d) {
            this.offset[d] = o[d];
        }
        if (this.size != null) {
            for (d = 0; d < this.numDimensions; ++d) {
                this.size[d] = s[d];
            }
        }
        this.reset();
    }

    @Override
    public void reset() {
        this.i = -1;
        this.cursor.setPosition(this.offset);
        this.cursor.bck(0);
        for (int d = 0; d < this.numDimensions; ++d) {
            this.currentDirectionDim[d] = true;
            this.roiPosition[d] = 0;
        }
        this.roiPosition[0] = -1;
    }

    @Override
    public void fwd() {
        ++this.i;
        for (int dim = 0; dim < this.numDimensions; ++dim) {
            int d = dim;
            if (this.currentDirectionDim[d]) {
                if (this.roiPosition[d] >= this.size[d] - 1) continue;
                this.cursor.fwd(d);
                int n = d;
                this.roiPosition[n] = this.roiPosition[n] + 1;
                for (int e = 0; e < d; ++e) {
                    this.currentDirectionDim[e] = !this.currentDirectionDim[e];
                }
                return;
            }
            if (this.roiPosition[d] <= 0) continue;
            this.cursor.bck(d);
            int n = d;
            this.roiPosition[n] = this.roiPosition[n] - 1;
            for (int e = 0; e < d; ++e) {
                this.currentDirectionDim[e] = !this.currentDirectionDim[e];
            }
            return;
        }
    }

    @Override
    public int getArrayIndex() {
        return this.cursor.getArrayIndex();
    }

    @Override
    public int getStorageIndex() {
        return this.cursor.getStorageIndex();
    }

    @Override
    public boolean isActive() {
        return this.cursor.isActive() && this.isActive;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void getPosition(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            position[d] = this.roiPosition[d];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.roiPosition.clone();
    }

    @Override
    public int getPosition(int dim) {
        return this.roiPosition[dim];
    }

    @Override
    public String getPositionAsString() {
        String pos = "(" + this.roiPosition[0];
        for (int d = 1; d < this.numDimensions; ++d) {
            pos = pos + ", " + this.roiPosition[d];
        }
        pos = pos + ")";
        return pos;
    }

    public String toString() {
        return Util.printCoordinates(this.roiPosition) + " [" + Util.printCoordinates(this.cursor.getPosition()) + "] " + this.getType();
    }
}

