/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.control.mcu;

import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.Interpolation;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.ViewerFrame;
import bdv.viewer.ViewerPanel;
import java.util.function.IntConsumer;
import net.imglib2.realtransform.AffineTransform3D;
import org.janelia.saalfeldlab.control.mcu.MCUButtonControl;
import org.janelia.saalfeldlab.control.mcu.MCUControlPanel;
import org.janelia.saalfeldlab.control.mcu.MCUVPotControl;

public class MCUBDVControls {
    private static final double step = Math.PI / 180;
    private final ViewerPanel viewerPanel;

    public MCUBDVControls(ViewerPanel viewer, MCUControlPanel panel) {
        this.viewerPanel = viewer;
        MCUVPotControl control = panel.getVPotControl(0);
        control.setAbsolute(false);
        control.setMinMax(-10, 10);
        control.setDisplayType(2);
        control.addListener(new VPotAxisShiftHandler(0));
        control = panel.getVPotControl(1);
        control.setAbsolute(false);
        control.setMinMax(-10, 10);
        control.setDisplayType(2);
        control.addListener(new VPotAxisShiftHandler(1));
        control = panel.getVPotControl(2);
        control.setAbsolute(false);
        control.setMinMax(-10, 10);
        control.setDisplayType(2);
        control.addListener(new VPotAxisShiftHandler(2));
        control = panel.getVPotControl(3);
        control.setAbsolute(false);
        control.setMinMax(-10, 10);
        control.setDisplayType(2);
        control.addListener(new VPotAxisRotationHandler(0));
        control = panel.getVPotControl(4);
        control.setAbsolute(false);
        control.setMinMax(-10, 10);
        control.setDisplayType(2);
        control.addListener(new VPotAxisRotationHandler(1));
        control = panel.getVPotControl(5);
        control.setAbsolute(false);
        control.setMinMax(-10, 10);
        control.setDisplayType(2);
        control.addListener(new VPotAxisRotationHandler(2));
        control = panel.getVPotControl(6);
        control.setAbsolute(false);
        control.setMinMax(-10, 10);
        control.setDisplayType(2);
        control.addListener(new VPotZoomHandler());
        MCUButtonControl key = panel.getButtonControl(0);
        key.setToggle(true);
        key.addListener(new InterpolationSwitcher());
        key = panel.getButtonControl(18);
        key.setToggle(false);
        key.addListener(i -> {
            if (i != 0) {
                viewer.align(AbstractViewerPanel.AlignPlane.ZY);
            }
        });
        key = panel.getButtonControl(19);
        key.setToggle(false);
        key.addListener(i -> {
            if (i != 0) {
                viewer.align(AbstractViewerPanel.AlignPlane.XZ);
            }
        });
        key = panel.getButtonControl(20);
        key.setToggle(false);
        key.addListener(i -> {
            if (i != 0) {
                viewer.align(AbstractViewerPanel.AlignPlane.XY);
            }
        });
        System.out.println((ViewerFrame)this.viewerPanel.getRootPane().getParent());
    }

    public class InterpolationSwitcher
    implements IntConsumer {
        @Override
        public void accept(int value) {
            SynchronizedViewerState state = MCUBDVControls.this.viewerPanel.state();
            state.setInterpolation(value == 0 ? Interpolation.NEARESTNEIGHBOR : Interpolation.NLINEAR);
        }
    }

    public class VPotZoomHandler
    implements IntConsumer {
        @Override
        public void accept(int value) {
            SynchronizedViewerState state = MCUBDVControls.this.viewerPanel.state();
            AffineTransform3D viewerTransform = state.getViewerTransform();
            double cX = 0.5 * (double)MCUBDVControls.this.viewerPanel.getWidth();
            double cY = 0.5 * (double)MCUBDVControls.this.viewerPanel.getHeight();
            viewerTransform.set(viewerTransform.get(0, 3) - cX, 0, 3);
            viewerTransform.set(viewerTransform.get(1, 3) - cY, 1, 3);
            double dScale = 1.05;
            viewerTransform.scale(Math.pow(1.05, value));
            viewerTransform.set(viewerTransform.get(0, 3) + cX, 0, 3);
            viewerTransform.set(viewerTransform.get(1, 3) + cY, 1, 3);
            state.setViewerTransform(viewerTransform);
        }
    }

    public class VPotAxisShiftHandler
    implements IntConsumer {
        private final int axis;

        public VPotAxisShiftHandler(int axis) {
            this.axis = axis;
        }

        @Override
        public void accept(int value) {
            SynchronizedViewerState state = MCUBDVControls.this.viewerPanel.state();
            AffineTransform3D viewerTransform = state.getViewerTransform();
            viewerTransform.set(viewerTransform.get(this.axis, 3) + (double)value, this.axis, 3);
            state.setViewerTransform(viewerTransform);
        }
    }

    public class VPotAxisRotationHandler
    implements IntConsumer {
        private final int axis;

        public VPotAxisRotationHandler(int axis) {
            this.axis = axis;
        }

        @Override
        public void accept(int value) {
            SynchronizedViewerState state = MCUBDVControls.this.viewerPanel.state();
            AffineTransform3D viewerTransform = state.getViewerTransform();
            double cX = 0.5 * (double)MCUBDVControls.this.viewerPanel.getWidth();
            double cY = 0.5 * (double)MCUBDVControls.this.viewerPanel.getHeight();
            viewerTransform.set(viewerTransform.get(0, 3) - cX, 0, 3);
            viewerTransform.set(viewerTransform.get(1, 3) - cY, 1, 3);
            viewerTransform.rotate(this.axis, (double)value * (Math.PI / 180));
            viewerTransform.set(viewerTransform.get(0, 3) + cX, 0, 3);
            viewerTransform.set(viewerTransform.get(1, 3) + cY, 1, 3);
            state.setViewerTransform(viewerTransform);
        }
    }
}

