/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.metadata;

import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisSlicer;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.DefaultAxisMetadata;

public class MetadataSource<T extends NumericType<T> & NativeType<T>>
implements Source<T> {
    private final N5DatasetMetadata metadata;
    private CachedCellImg<T, ?> imgRaw;
    private int timeDimension;
    private int channelDimension;
    private int channelPos;
    private int nSpaceDims;
    private int nTimeDims;
    private int nChannelDims;
    private int nOtherDims;
    private AxisMetadata axes;
    private AffineTransform3D sourceTransform;
    private boolean isValid;

    public MetadataSource(N5Reader n5, N5DatasetMetadata metadata, int channelDim, int channelPos) {
        this.metadata = metadata;
        this.sourceTransform = metadata instanceof SpatialMetadata ? ((SpatialMetadata)metadata).spatialTransform3d() : new AffineTransform3D();
        this.channelDimension = channelDim;
        this.channelPos = channelPos;
        this.axes = metadata instanceof AxisMetadata ? (AxisMetadata)metadata : MetadataSource.defaultAxes(metadata);
        this.isValid = this.checkAxes(this.axes, metadata);
        this.timeDimension = MetadataSource.getTimeIndex(this.axes);
        this.channelDimension = MetadataSource.getChannelIndex(this.axes);
        if (this.isValid) {
            try {
                this.imgRaw = N5Utils.open((N5Reader)n5, (String)metadata.getPath());
            }
            catch (N5Exception e) {
                e.printStackTrace();
            }
        }
    }

    public MetadataSource(N5Reader n5, N5TreeNode node) {
        this(n5, (N5DatasetMetadata)node.getMetadata());
    }

    public MetadataSource(N5Reader n5, N5DatasetMetadata metadata) {
        this(n5, metadata, -1, 0);
    }

    public MetadataSource(N5Reader n5, N5DatasetMetadata metadata, int channelPos) {
        this(n5, metadata, -1, channelPos);
    }

    public static List<MetadataSource<?>> buildMetadataSources(N5Reader n5, N5DatasetMetadata metadata) {
        MetadataSource src0 = new MetadataSource(n5, metadata);
        if (!src0.isValid()) {
            return null;
        }
        int nc = src0.getNumChannels();
        ArrayList sources = new ArrayList();
        sources.add(src0);
        for (int i = 1; i < nc; ++i) {
            sources.add(new MetadataSource(n5, metadata, i));
        }
        return sources;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int getChannelDimension() {
        return this.channelDimension;
    }

    public int getNumChannels() {
        return (int)this.imgRaw.dimension(this.channelDimension);
    }

    public int getChannelIndex() {
        return this.channelPos;
    }

    public int getTimeDimension() {
        return this.timeDimension;
    }

    public CachedCellImg<T, ?> getRawImage() {
        return this.imgRaw;
    }

    public static int getTimeIndex(AxisMetadata axes) {
        int[] idxs = axes.indexesOfType("time");
        if (idxs == null || idxs.length == 0) {
            return -1;
        }
        return idxs[0];
    }

    public static int getChannelIndex(AxisMetadata axes) {
        int[] idxs = axes.indexesOfType("channel");
        if (idxs == null || idxs.length == 0) {
            return -1;
        }
        return idxs[0];
    }

    public static DefaultAxisMetadata defaultAxes(N5DatasetMetadata meta) {
        if (meta.getAttributes().getNumDimensions() <= 3 && (meta instanceof N5CosemMetadata || meta instanceof N5SingleScaleMetadata)) {
            return MetadataSource.defaultAxesSpatial(meta);
        }
        return MetadataSource.defaultAxesIJ(meta);
    }

    public static DefaultAxisMetadata defaultAxesSpatial(N5DatasetMetadata meta) {
        int nd = meta.getAttributes().getNumDimensions();
        if (nd > 3) {
            return null;
        }
        String[] labels = (String[])Arrays.stream(new String[]{"x", "y", "z"}).limit(nd).toArray(String[]::new);
        String[] types = AxisUtils.getDefaultTypes((String[])labels);
        String[] units = (String[])Stream.generate(() -> "pixel").limit(nd).toArray(String[]::new);
        return new DefaultAxisMetadata(meta.getPath(), labels, types, units);
    }

    public static DefaultAxisMetadata defaultAxesIJ(N5DatasetMetadata meta) {
        int nd = meta.getAttributes().getNumDimensions();
        String[] labels = (String[])Arrays.stream(new String[]{"x", "y", "c", "z", "t"}).limit(nd).toArray(String[]::new);
        String[] types = AxisUtils.getDefaultTypes((String[])labels);
        String[] units = (String[])Stream.generate(() -> "pixel").limit(nd).toArray(String[]::new);
        return new DefaultAxisMetadata(meta.getPath(), labels, types, units);
    }

    public boolean checkAxes(AxisMetadata axes, N5DatasetMetadata metadata) {
        long[] dims = metadata.getAttributes().getDimensions();
        int ndData = dims.length;
        int nd = axes.getAxisLabels().length;
        if (nd != ndData) {
            return false;
        }
        this.nSpaceDims = 0;
        this.nTimeDims = 0;
        this.nChannelDims = 0;
        this.nOtherDims = 0;
        for (int i = 0; i < nd; ++i) {
            String type = axes.getAxisTypes()[i];
            if (type.equals("space")) {
                ++this.nSpaceDims;
                continue;
            }
            if (type.equals("time")) {
                ++this.nTimeDims;
                continue;
            }
            if (type.equals("channel")) {
                ++this.nChannelDims;
                continue;
            }
            ++this.nOtherDims;
        }
        if (this.nSpaceDims > 3) {
            return false;
        }
        return this.nTimeDims <= 1;
    }

    @Deprecated
    public boolean inferDimensions(AxisMetadata axes, int channel) {
        ArrayList<Integer> spaceDims = new ArrayList<Integer>();
        ArrayList<Integer> timeDims = new ArrayList<Integer>();
        ArrayList<Integer> channelDims = new ArrayList<Integer>();
        int nd = axes.getAxisLabels().length;
        for (int i = 0; i < nd; ++i) {
            String type = axes.getAxisTypes()[i];
            if (type.equals("space")) {
                spaceDims.add(i);
                continue;
            }
            if (type.equals("time")) {
                timeDims.add(i);
                continue;
            }
            channelDims.add(i);
        }
        if (spaceDims.size() > 3) {
            return false;
        }
        if (timeDims.size() > 1) {
            return false;
        }
        this.timeDimension = timeDims.size() == 0 ? -1 : (Integer)timeDims.get(0);
        if (channelDims.size() > 1) {
            return false;
        }
        this.channelDimension = channelDims.size() == 0 ? -1 : (Integer)channelDims.get(0);
        return true;
    }

    public boolean isPresent(int t) {
        if (this.timeDimension < 0) {
            return t == 0;
        }
        return t >= 0 && (long)t < this.imgRaw.dimension(this.timeDimension);
    }

    public int numTimePoints() {
        return this.timeDimension < 0 ? 1 : (int)this.imgRaw.dimension(this.timeDimension);
    }

    public RandomAccessibleInterval<T> getSource(int t, int level) {
        AxisSlicer slicer = new AxisSlicer(this.axes);
        for (int i = 0; i < this.axes.getAxisLabels().length; ++i) {
            String type = this.axes.getAxisTypes()[i];
            String label = this.axes.getAxisLabels()[i];
            if (type.equals("space")) continue;
            if (type.equals("time")) {
                slicer.slice(label, t);
                continue;
            }
            if (type.equals("channel")) {
                slicer.slice(label, this.channelPos);
                continue;
            }
            slicer.slice(label, 0);
        }
        return slicer.apply(this.imgRaw);
    }

    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        RandomAccessibleInterval<T> src = this.getSource(t, level);
        if (method.equals((Object)Interpolation.NEARESTNEIGHBOR)) {
            return Views.interpolate((EuclideanSpace)Views.extendZero(src), (InterpolatorFactory)new NearestNeighborInterpolatorFactory());
        }
        return Views.interpolate((EuclideanSpace)Views.extendZero(src), (InterpolatorFactory)new NLinearInterpolatorFactory());
    }

    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        transform.set(this.sourceTransform);
    }

    public T getType() {
        return (T)((NumericType)Util.getTypeFromInterval(this.imgRaw));
    }

    public String getName() {
        return this.metadata.getName();
    }

    public VoxelDimensions getVoxelDimensions() {
        return null;
    }

    public int getNumMipmapLevels() {
        return 1;
    }
}

