/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search;

import java.io.IOException;
import java.net.URL;
import org.scijava.log.LogService;
import org.scijava.log.Logger;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Parameter;
import org.scijava.search.DefaultSearchAction;
import org.scijava.search.SearchAction;
import org.scijava.search.SearchActionFactory;
import org.scijava.search.SearchResult;
import org.scijava.search.SourceFinder;
import org.scijava.search.SourceNotFoundException;
import org.scijava.ui.UIService;

public abstract class SourceSearchActionFactory
implements SearchActionFactory {
    @Parameter
    private LogService log;
    @Parameter
    private UIService uiService;
    @Parameter
    private PlatformService platformService;

    protected abstract Class<?> classFromSearchResult(SearchResult var1);

    @Override
    public SearchAction create(SearchResult result) {
        return new DefaultSearchAction("Source", () -> this.source(this.classFromSearchResult(result)));
    }

    private void source(Class<?> c) {
        URL sourceLocation = null;
        try {
            sourceLocation = SourceFinder.sourceLocation(c, (Logger)this.log);
        }
        catch (SourceNotFoundException exc) {
            this.log.error((Throwable)exc);
        }
        if (sourceLocation == null) {
            this.uiService.showDialog("Source location unknown for " + c.getName());
            return;
        }
        try {
            this.platformService.open(sourceLocation);
        }
        catch (IOException exc) {
            this.log.error((Throwable)exc);
            this.uiService.showDialog("Platform error opening source URL: " + sourceLocation);
        }
    }
}

