/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.pivanalyser;

import fiji.plugin.pivanalyser.DateUtils;
import fiji.plugin.pivanalyser.PIV_analyser;
import fiji.plugin.pivanalyser.Stopwatch;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class PIVAnalyserTestDrive {
    private static final String TESTPIV = "testpiv-1.tif";
    private static boolean LOG = false;
    private static boolean DISPLAY_COLOR_WHEEL = true;

    public static void main(String[] args) {
        int[][] pairs = new int[][]{{1, 2}};
        PIV_analyser.WINDOW_SIZE blocksize = PIV_analyser.WINDOW_SIZE._64x64;
        System.out.println("Loading the image...");
        FileInfo fi = new FileInfo();
        fi.width = 256;
        fi.height = 64;
        fi.offset = 177;
        fi.nImages = 2;
        fi.fileName = TESTPIV;
        fi.directory = ".";
        new FileOpener(fi).open();
        ImagePlus imp = WindowManager.getCurrentImage();
        System.out.println("Initializing the plugin...");
        PIV_analyser piv = new PIV_analyser();
        piv.setup("", imp);
        piv.setImagePairs(pairs);
        piv.setWinsize(blocksize);
        System.out.println("Running the plugin...");
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        piv.exec(false);
        stopwatch.stop();
        System.out.println("Done in: " + stopwatch);
        System.out.println("Exiting.");
        if (LOG) {
            File log = new File("log.txt");
            try {
                BufferedWriter output = new BufferedWriter(new FileWriter(log, true));
                output.append("[+] Test - " + DateUtils.now() + "\n");
                output.append("\t Image: testpiv-1.tif\n");
                output.append("\t Image pairs: " + pairs.length + " pair(s).\n");
                output.append("\t Image size: " + imp.getWidth() + " x " + imp.getHeight() + ".\n");
                output.append("\t Block size: " + blocksize.toString() + ".\n");
                output.append("\t Exec time: " + stopwatch + "\n\n");
                ((Writer)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        imp.changes = false;
        imp.close();
        if (DISPLAY_COLOR_WHEEL) {
            ColorProcessor cp = new ColorProcessor(256, 256);
            PIV_analyser.colorCircle(cp);
            new ImagePlus("Color coded orientation", (ImageProcessor)cp).show();
        }
    }
}

