/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.random.Normal;
import org.ojalgo.random.RandomUtils;
import org.ojalgo.random.process.AbstractProcess;

public final class WienerProcess
extends AbstractProcess<Normal> {
    private static final Normal GENERATOR = new Normal();

    public WienerProcess() {
        this.setValue(PrimitiveMath.ZERO);
    }

    private WienerProcess(double initialValue) {
        this.setValue(initialValue);
    }

    @Override
    public Normal getDistribution(double evaluationPoint) {
        return new Normal(this.getValue(), PrimitiveFunction.SQRT.invoke(evaluationPoint));
    }

    @Override
    protected double getNormalisedRandomIncrement() {
        return GENERATOR.doubleValue();
    }

    @Override
    protected double step(double currentValue, double stepSize, double normalisedRandomIncrement) {
        double retVal = currentValue + PrimitiveFunction.SQRT.invoke(stepSize) * normalisedRandomIncrement;
        this.setValue(retVal);
        return retVal;
    }

    @Override
    double getExpected(double stepSize) {
        return this.getValue();
    }

    @Override
    double getLowerConfidenceQuantile(double stepSize, double confidence) {
        return this.getValue() - PrimitiveFunction.SQRT.invoke(stepSize) * PrimitiveMath.SQRT_TWO * RandomUtils.erfi(confidence);
    }

    @Override
    double getStandardDeviation(double stepSize) {
        return PrimitiveFunction.SQRT.invoke(stepSize);
    }

    @Override
    double getUpperConfidenceQuantile(double stepSize, double confidence) {
        return this.getValue() + PrimitiveFunction.SQRT.invoke(stepSize) * PrimitiveMath.SQRT_TWO * RandomUtils.erfi(confidence);
    }

    @Override
    double getVariance(double stepSize) {
        return stepSize;
    }
}

