/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.imagej.ops.Contingent;
import net.imagej.ops.Op;
import net.imagej.ops.OpCandidate;
import net.imagej.ops.OpEnvironment;
import net.imagej.ops.OpInfo;
import net.imagej.ops.OpMatchingService;
import net.imagej.ops.OpMatchingUtil;
import net.imagej.ops.OpRef;
import net.imagej.ops.OpUtils;
import org.scijava.Context;
import org.scijava.Initializable;
import org.scijava.InstantiableException;
import org.scijava.command.CommandInfo;
import org.scijava.convert.ConvertService;
import org.scijava.log.LogService;
import org.scijava.module.Module;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.util.Types;

@Plugin(type=Service.class)
public class DefaultOpMatchingService
extends AbstractService
implements OpMatchingService {
    @Parameter
    private Context context;
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private ConvertService convertService;
    @Parameter
    private LogService log;

    @Override
    public OpCandidate findMatch(OpEnvironment ops, OpRef ref) {
        return this.findMatch(ops, Collections.singletonList(ref));
    }

    @Override
    public OpCandidate findMatch(OpEnvironment ops, List<OpRef> refs) {
        List<OpCandidate> candidates = this.findCandidates(ops, refs);
        this.assertCandidates(candidates, refs.get(0));
        List<OpCandidate> matches = this.filterMatches(candidates);
        return this.singleMatch(candidates, matches);
    }

    @Override
    public List<OpCandidate> findCandidates(OpEnvironment ops, OpRef ref) {
        return this.findCandidates(ops, Collections.singletonList(ref));
    }

    @Override
    public List<OpCandidate> findCandidates(OpEnvironment ops, List<OpRef> refs) {
        ArrayList<OpCandidate> candidates = new ArrayList<OpCandidate>();
        for (OpInfo info : ops.infos()) {
            for (OpRef ref : refs) {
                if (!this.isCandidate(info, ref)) continue;
                candidates.add(new OpCandidate(ops, ref, info));
            }
        }
        return candidates;
    }

    @Override
    public List<OpCandidate> filterMatches(List<OpCandidate> candidates) {
        List<OpCandidate> validCandidates = this.validCandidates(candidates);
        List<OpCandidate> matches = this.filterMatches(validCandidates, cand -> this.typesPerfectMatch((OpCandidate)cand));
        if (!matches.isEmpty()) {
            return matches;
        }
        matches = this.castMatches(validCandidates);
        if (!matches.isEmpty()) {
            return matches;
        }
        matches = this.filterMatches(validCandidates, cand -> this.typesMatch((OpCandidate)cand));
        return matches;
    }

    @Override
    public Module match(OpCandidate candidate) {
        if (!this.valid(candidate)) {
            return null;
        }
        if (!this.outputsMatch(candidate)) {
            return null;
        }
        Object[] args = this.padArgs(candidate);
        return args == null ? null : this.match(candidate, args);
    }

    @Override
    public boolean typesMatch(OpCandidate candidate) {
        if (!this.valid(candidate)) {
            return false;
        }
        Object[] args = this.padArgs(candidate);
        return args == null ? false : this.typesMatch(candidate, args) < 0;
    }

    @Override
    public Module assignInputs(Module module, Object ... args) {
        int i = 0;
        for (ModuleItem<?> item : OpUtils.inputs(module.getInfo())) {
            this.assign(module, args[i++], item);
        }
        return module;
    }

    @Override
    public Object[] padArgs(OpCandidate candidate) {
        int inputCount = 0;
        int requiredCount = 0;
        for (ModuleItem<?> item : candidate.inputs()) {
            ++inputCount;
            if (!item.isRequired()) continue;
            ++requiredCount;
        }
        Object[] args = candidate.getRef().getArgs();
        if (args.length == inputCount) {
            return args;
        }
        if (args.length > inputCount) {
            candidate.setStatus(OpCandidate.StatusCode.TOO_MANY_ARGS, args.length + " > " + inputCount);
            return null;
        }
        if (args.length < requiredCount) {
            candidate.setStatus(OpCandidate.StatusCode.TOO_FEW_ARGS, args.length + " < " + requiredCount);
            return null;
        }
        int argsToPad = inputCount - args.length;
        int optionalCount = inputCount - requiredCount;
        int optionalsToFill = optionalCount - argsToPad;
        Object[] paddedArgs = new Object[inputCount];
        int argIndex = 0;
        int paddedIndex = 0;
        int optionalIndex = 0;
        for (ModuleItem<?> item : candidate.inputs()) {
            if (!item.isRequired() && optionalIndex++ >= optionalsToFill) {
                ++paddedIndex;
                continue;
            }
            paddedArgs[paddedIndex++] = args[argIndex++];
        }
        return paddedArgs;
    }

    private boolean isCandidate(OpInfo info, OpRef ref) {
        Class opClass;
        if (!info.nameMatches(ref.getName())) {
            return false;
        }
        try {
            opClass = info.cInfo().loadClass();
        }
        catch (InstantiableException exc) {
            String msg = "Invalid op: " + info.cInfo().getClassName();
            if (this.log.isDebug()) {
                this.log.debug((Object)msg, (Throwable)exc);
            } else {
                this.log.error((Object)msg);
            }
            return false;
        }
        return ref.typesMatch(opClass);
    }

    private void assertCandidates(List<OpCandidate> candidates, OpRef ref) {
        if (candidates.isEmpty()) {
            throw new IllegalArgumentException("No candidate '" + ref.getLabel() + "' ops");
        }
    }

    private List<OpCandidate> validCandidates(List<OpCandidate> candidates) {
        ArrayList<OpCandidate> validCandidates = new ArrayList<OpCandidate>();
        for (OpCandidate candidate : candidates) {
            Object[] args;
            if (!this.valid(candidate) || !this.outputsMatch(candidate) || (args = this.padArgs(candidate)) == null) continue;
            candidate.setArgs(args);
            if (this.missArgs(candidate)) continue;
            validCandidates.add(candidate);
        }
        return validCandidates;
    }

    private boolean losslessMatch(OpCandidate candidate) {
        return false;
    }

    private List<OpCandidate> filterMatches(List<OpCandidate> candidates, Predicate<OpCandidate> filter) {
        OpCandidate candidate;
        CommandInfo info;
        double p;
        ArrayList<OpCandidate> matches = new ArrayList<OpCandidate>();
        double priority = Double.NaN;
        Iterator<OpCandidate> iterator = candidates.iterator();
        while (iterator.hasNext() && ((p = (info = (candidate = iterator.next()).cInfo()).getPriority()) == priority || matches.isEmpty())) {
            priority = p;
            if (!filter.test(candidate) || !this.moduleConforms(candidate)) continue;
            matches.add(candidate);
        }
        return matches;
    }

    private boolean missArgs(OpCandidate candidate) {
        int i = 0;
        for (ModuleItem<?> item : candidate.inputs()) {
            if (candidate.getArgs()[i++] != null || !item.isRequired()) continue;
            candidate.setStatus(OpCandidate.StatusCode.REQUIRED_ARG_IS_NULL, null, item);
            return true;
        }
        return false;
    }

    private boolean typesPerfectMatch(OpCandidate candidate) {
        int i = 0;
        Object[] args = candidate.getArgs();
        for (ModuleItem<?> item : candidate.inputs()) {
            Class<?> argClass;
            Class<?> typeClass;
            if (args[i] != null && !(typeClass = OpMatchingUtil.getClass(item.getType())).equals(argClass = OpMatchingUtil.getClass(args[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private List<OpCandidate> castMatches(List<OpCandidate> candidates) {
        OpCandidate candidate;
        CommandInfo info;
        double p;
        ArrayList<OpCandidate> matches = new ArrayList<OpCandidate>();
        int minLevels = Integer.MAX_VALUE;
        double priority = Double.NaN;
        Iterator<OpCandidate> iterator = candidates.iterator();
        while (iterator.hasNext() && ((p = (info = (candidate = iterator.next()).cInfo()).getPriority()) == priority || matches.isEmpty())) {
            priority = p;
            int nextLevels = this.findCastLevels(candidate);
            if (nextLevels < 0 || nextLevels > minLevels || !this.moduleConforms(candidate)) continue;
            if (nextLevels < minLevels) {
                matches.clear();
                minLevels = nextLevels;
            }
            matches.add(candidate);
        }
        return matches;
    }

    private int findCastLevels(OpCandidate candidate) {
        int level = 0;
        int i = 0;
        Object[] args = candidate.getArgs();
        for (ModuleItem<?> item : candidate.inputs()) {
            Class type = item.getType();
            if (args[i] != null) {
                int currLevel = OpMatchingUtil.findCastLevels(type, OpMatchingUtil.getClass(args[i]));
                if (currLevel < 0) {
                    return -1;
                }
                level += currLevel;
            }
            ++i;
        }
        return level;
    }

    private OpCandidate singleMatch(List<OpCandidate> candidates, List<OpCandidate> matches) {
        if (matches.size() == 1) {
            Module m = matches.get(0).getModule();
            if (this.log.isDebug()) {
                this.log.debug((Object)("Selected '" + matches.get(0).getRef().getLabel() + "' op: " + m.getDelegateObject().getClass().getName()));
            }
            if (m.getDelegateObject() instanceof Initializable) {
                ((Initializable)m.getDelegateObject()).initialize();
            }
            return matches.get(0);
        }
        String analysis = OpUtils.matchInfo(candidates, matches);
        throw new IllegalArgumentException(analysis);
    }

    private boolean valid(OpCandidate candidate) {
        if (candidate.cInfo().isValid()) {
            return true;
        }
        candidate.setStatus(OpCandidate.StatusCode.INVALID_MODULE);
        return false;
    }

    private boolean outputsMatch(OpCandidate candidate) {
        List<Type> outTypes = candidate.getRef().getOutTypes();
        if (outTypes == null) {
            return true;
        }
        Iterator<ModuleItem<?>> outItems = candidate.outputs().iterator();
        for (Type outType : outTypes) {
            if (!outItems.hasNext()) {
                candidate.setStatus(OpCandidate.StatusCode.TOO_FEW_OUTPUTS);
                return false;
            }
            Class raw = Types.raw((Type)outType);
            Class outItemClass = outItems.next().getType();
            if (Types.isAssignable((Type)outItemClass, (Type)raw)) continue;
            candidate.setStatus(OpCandidate.StatusCode.OUTPUT_TYPES_DO_NOT_MATCH, "request=" + raw.getName() + ", actual=" + outItemClass.getName());
            return false;
        }
        return true;
    }

    private boolean moduleConforms(OpCandidate candidate) {
        Contingent c;
        Module module = this.createModule(candidate, candidate.getArgs());
        candidate.setModule(module);
        Object op = module.getDelegateObject();
        if (op instanceof Contingent && !(c = (Contingent)op).conforms()) {
            candidate.setStatus(OpCandidate.StatusCode.DOES_NOT_CONFORM);
            return false;
        }
        return true;
    }

    private Module match(OpCandidate candidate, Object[] args) {
        Contingent c;
        int badIndex = this.typesMatch(candidate, args);
        if (badIndex >= 0) {
            String message = this.typeClashMessage(candidate, args, badIndex);
            candidate.setStatus(OpCandidate.StatusCode.ARG_TYPES_DO_NOT_MATCH, message);
            return null;
        }
        Module module = this.createModule(candidate, args);
        candidate.setModule(module);
        Object op = module.getDelegateObject();
        if (op instanceof Contingent && !(c = (Contingent)op).conforms()) {
            candidate.setStatus(OpCandidate.StatusCode.DOES_NOT_CONFORM);
            return null;
        }
        return module;
    }

    private int typesMatch(OpCandidate candidate, Object[] args) {
        int i = 0;
        for (ModuleItem<?> item : candidate.inputs()) {
            if (!this.canAssign(candidate, args[i], item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String typeClashMessage(OpCandidate candidate, Object[] args, int index) {
        int i = 0;
        for (ModuleItem<?> item : candidate.inputs()) {
            if (i++ != index) continue;
            Object arg = args[index];
            String argType = arg == null ? "null" : arg.getClass().getName();
            Type inputType = item.getGenericType();
            return index + ": cannot coerce " + argType + " -> " + inputType;
        }
        throw new IllegalArgumentException("Invalid index: " + index);
    }

    private Module createModule(OpCandidate candidate, Object ... args) {
        Module module = this.moduleService.createModule((ModuleInfo)candidate.cInfo());
        Op op = OpUtils.unwrap(module, candidate.getRef());
        op.setEnvironment(candidate.ops());
        return this.assignInputs(module, args);
    }

    private boolean canAssign(OpCandidate candidate, Object arg, ModuleItem<?> item) {
        if (arg == null) {
            if (item.isRequired()) {
                candidate.setStatus(OpCandidate.StatusCode.REQUIRED_ARG_IS_NULL, null, item);
                return false;
            }
            return true;
        }
        Type type = item.getGenericType();
        if (!this.canConvert(arg, type)) {
            candidate.setStatus(OpCandidate.StatusCode.CANNOT_CONVERT, arg.getClass().getName() + " => " + type, item);
            return false;
        }
        return true;
    }

    private boolean canConvert(Object arg, Type type) {
        return this.isMatchingTypedNullPlaceholder(arg, type) || this.convertService.supports(arg, type);
    }

    private void assign(Module module, Object arg, ModuleItem<?> item) {
        if (arg != null) {
            Type type = item.getGenericType();
            Object value = this.convert(arg, type);
            module.setInput(item.getName(), value);
        }
        module.resolveInput(item.getName());
    }

    private Object convert(Object arg, Type type) {
        if (this.isMatchingTypedNullPlaceholder(arg, type)) {
            return null;
        }
        return this.convertService.convert(arg, type);
    }

    private boolean isMatchingTypedNullPlaceholder(Object arg, Type type) {
        if (!Type.class.isInstance(arg)) {
            return false;
        }
        List srcClasses = Types.raws((Type)((Type)arg));
        List destClasses = Types.raws((Type)type);
        boolean castable = true;
        for (Class dest : destClasses) {
            if (srcClasses.stream().anyMatch(src -> dest.isAssignableFrom((Class<?>)src))) continue;
            castable = false;
            break;
        }
        if (castable) {
            return true;
        }
        return srcClasses.stream().anyMatch(src -> this.convertService.supports(src, type));
    }
}

