/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.commands.project;

import net.imagej.ImgPlus;
import net.imagej.axis.TypedAxis;
import net.imagej.ops.OpService;
import net.imagej.ops.commands.project.ProjectMethod;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class)
public class ProjectCommand<T extends RealType<T>>
implements Command {
    @Parameter(type=ItemIO.BOTH)
    private ImgPlus<T> out;
    @Parameter
    private ImgPlus<T> in;
    @Parameter
    private ProjectMethod<T> method;
    @Parameter
    private TypedAxis axis;
    @Parameter
    private OpService ops;

    public void run() {
        if (this.out == null) {
            Img img = this.in.factory().create(this.in, (Object)((RealType)this.in.firstElement()).createVariable());
            this.out = new ImgPlus(img, this.in);
        }
        int axisIndex = this.in.dimensionIndex(this.axis.type());
        this.ops.transform().project(this.out, this.in, this.method, axisIndex);
    }
}

