/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.deconvolve;

import net.imagej.ops.Ops;
import net.imagej.ops.filter.correlate.CorrelateFFTC;
import net.imagej.ops.map.MapBinaryInplace1s;
import net.imagej.ops.special.computer.AbstractBinaryComputerOp;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.inplace.AbstractBinaryInplace1Op;
import net.imagej.ops.special.inplace.BinaryInplace1Op;
import net.imagej.ops.special.inplace.Inplaces;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Deconvolve.RichardsonLucyCorrection.class, priority=100.0)
public class RichardsonLucyCorrection<I extends RealType<I>, O extends RealType<O>, C extends ComplexType<C>>
extends AbstractBinaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<O>, RandomAccessibleInterval<O>>
implements Ops.Deconvolve.RichardsonLucyCorrection {
    @Parameter
    private RandomAccessibleInterval<C> fftBuffer;
    @Parameter
    private RandomAccessibleInterval<C> fftKernel;
    private BinaryInplace1Op<RandomAccessibleInterval<O>, RandomAccessibleInterval<I>, RandomAccessibleInterval<O>> divide;
    private BinaryComputerOp<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> correlate;

    @Override
    public void initialize() {
        this.divide = new DivideHandleZeroMap1();
        this.divide.setEnvironment(this.ops());
        this.divide.initialize();
        this.correlate = Computers.binary(this.ops(), CorrelateFFTC.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, new Object[]{this.fftBuffer, this.fftKernel, true, false});
    }

    @Override
    public void compute(RandomAccessibleInterval<I> observed, RandomAccessibleInterval<O> reblurred, RandomAccessibleInterval<O> correction) {
        this.divide.mutate1(reblurred, observed);
        this.correlate.compute(reblurred, correction);
    }

    private static class DivideHandleZeroOp1<I extends RealType<I> & NumericType<I>, O extends RealType<O> & NumericType<O>>
    extends AbstractBinaryInplace1Op<O, I> {
        private DivideHandleZeroOp1() {
        }

        @Override
        public void mutate1(O outin, I input) {
            RealType tmp = (RealType)outin.copy();
            if (outin.getRealFloat() > 0.0f) {
                tmp.setReal(input.getRealFloat());
                tmp.div(outin);
                outin.set((Type)tmp);
            } else {
                outin.setReal(0.0);
            }
        }
    }

    private static class DivideHandleZeroMap1<I extends RealType<I>, O extends RealType<O>>
    extends AbstractBinaryInplace1Op<IterableInterval<O>, IterableInterval<I>> {
        private BinaryInplace1Op<O, I, O> divide;
        private BinaryInplace1Op<IterableInterval<O>, IterableInterval<I>, IterableInterval<O>> map;

        private DivideHandleZeroMap1() {
        }

        @Override
        public void initialize() {
            this.divide = new DivideHandleZeroOp1();
            this.divide.setEnvironment(this.ops());
            this.divide.initialize();
            this.map = Inplaces.binary1(this.ops(), MapBinaryInplace1s.IIAndII.class, IterableInterval.class, IterableInterval.class, new Object[]{this.divide});
        }

        @Override
        public void mutate1(IterableInterval<O> outin, IterableInterval<I> input2) {
            this.map.mutate1(outin, input2);
        }
    }
}

