/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.lbp2d;

import java.util.ArrayList;
import java.util.Iterator;
import net.imagej.ops.Contingent;
import net.imagej.ops.features.lbp2d.LBP2DFeature;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;

public abstract class AbstractLBP2DFeature<I extends RealType<I>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<I>, ArrayList<LongType>>
implements LBP2DFeature<I>,
Contingent {
    @Override
    public boolean conforms() {
        return ((RandomAccessibleInterval)this.in()).numDimensions() == 2;
    }

    final class ClockwiseDistanceNeighborhoodIterator<T extends Type<T>>
    implements Iterator<T> {
        private final RandomAccess<T> m_ra;
        private final int m_distance;
        private final int[][] CLOCKWISE_OFFSETS = new int[][]{{0, -1}, {1, 0}, {1, 0}, {0, 1}, {0, 1}, {-1, 0}, {-1, 0}, {0, -1}};
        private int m_curOffset = 0;
        private int m_startIndex = 8;

        public ClockwiseDistanceNeighborhoodIterator(RandomAccess<T> ra, int distance) {
            this.m_ra = ra;
            this.m_distance = distance;
        }

        @Override
        public final boolean hasNext() {
            return this.m_curOffset != this.m_startIndex;
        }

        @Override
        public final T next() {
            this.m_ra.move(this.CLOCKWISE_OFFSETS[this.m_curOffset][0] * this.m_distance, 0);
            this.m_ra.move(this.CLOCKWISE_OFFSETS[this.m_curOffset][1] * this.m_distance, 1);
            ++this.m_curOffset;
            return (T)((Type)this.m_ra.get());
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public final int getIndex() {
            return this.m_curOffset;
        }

        public final void reset() {
            this.m_curOffset = 0;
            this.m_startIndex = 8;
        }
    }
}

