/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.distancetransform;

import java.util.concurrent.Callable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;

class Phase1Runnable3D<B extends BooleanType<B>>
implements Callable<Void> {
    private final int[][][] tempValues;
    private final RandomAccess<B> raIn;
    private final int y;
    private final int z;
    private final int infinite;
    private final int width;

    public Phase1Runnable3D(int[][][] tempValues, RandomAccessibleInterval<B> raIn, int yPos, int zPos) {
        this.tempValues = tempValues;
        this.raIn = raIn.randomAccess();
        this.y = yPos;
        this.z = zPos;
        this.infinite = (int)(raIn.dimension(0) + raIn.dimension(1));
        this.width = (int)raIn.dimension(0);
    }

    @Override
    public Void call() throws Exception {
        int x;
        this.raIn.setPosition(0, 0);
        this.raIn.setPosition(this.y, 1);
        this.raIn.setPosition(this.z, 2);
        this.tempValues[0][this.y][this.z] = !((BooleanType)this.raIn.get()).get() ? 0 : this.infinite;
        for (x = 1; x < this.width; ++x) {
            this.raIn.setPosition(x, 0);
            this.tempValues[x][this.y][this.z] = !((BooleanType)this.raIn.get()).get() ? 0 : this.tempValues[x - 1][this.y][this.z] + 1;
        }
        for (x = this.width - 2; x >= 0; --x) {
            if (this.tempValues[x + 1][this.y][this.z] >= this.tempValues[x][this.y][this.z]) continue;
            this.tempValues[x][this.y][this.z] = 1 + this.tempValues[x + 1][this.y][this.z];
        }
        return null;
    }
}

