/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.segment.detectRidges;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import net.imagej.ops.OpEnvironment;
import net.imagej.ops.OpService;
import net.imagej.ops.Ops;
import net.imagej.ops.special.chain.RAIs;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;
import org.scijava.Context;

public class RidgeDetectionMetadata {
    protected Img<DoubleType> pValues;
    protected Img<DoubleType> nValues;
    protected Img<DoubleType> gradients;
    RandomAccessibleInterval<DoubleType> x;
    RandomAccessibleInterval<DoubleType> y;
    RandomAccessibleInterval<DoubleType> xx;
    RandomAccessibleInterval<DoubleType> xy;
    RandomAccessibleInterval<DoubleType> yy;

    public <T extends RealType<T>> RidgeDetectionMetadata(RandomAccessibleInterval<T> input, double sigma, double smallMax, double bigMax) {
        Context context = new Context();
        OpService opService = (OpService)context.getService(OpService.class);
        RandomAccessibleInterval converted = (RandomAccessibleInterval)opService.run(Ops.Convert.Float64.class, new Object[]{input});
        Img temp = opService.create().img(converted);
        UnaryFunctionOp copyOp = RAIs.function(opService, Ops.Copy.RAI.class, converted, new Object[0]);
        BinaryComputerOp partialDerivativeOp = Computers.binary((OpEnvironment)opService, Ops.Filter.DerivativeGauss.class, converted, temp, new int[]{0, 0}, new Object[]{new double[]{sigma, sigma}});
        long[] valuesArr = new long[input.numDimensions() + 1];
        for (int d = 0; d < input.numDimensions(); ++d) {
            valuesArr[d] = input.dimension(d);
        }
        valuesArr[valuesArr.length - 1] = 2L;
        this.pValues = opService.create().img(valuesArr);
        RandomAccess pRA = this.pValues.randomAccess();
        this.nValues = opService.create().img(valuesArr);
        RandomAccess nRA = this.nValues.randomAccess();
        this.gradients = opService.create().img((Dimensions)input, new DoubleType());
        RandomAccess gradientsRA = this.gradients.randomAccess();
        Cursor cursor = Views.iterable(input).localizingCursor();
        this.x = copyOp.calculate(converted);
        RandomAccess xRA = this.x.randomAccess();
        this.y = copyOp.calculate(converted);
        RandomAccess yRA = this.y.randomAccess();
        this.xx = copyOp.calculate(converted);
        RandomAccess xxRA = this.xx.randomAccess();
        this.xy = copyOp.calculate(converted);
        RandomAccess xyRA = this.xy.randomAccess();
        this.yy = copyOp.calculate(converted);
        RandomAccess yyRA = this.yy.randomAccess();
        partialDerivativeOp.compute(converted, new int[]{1, 0}, (RandomAccessibleInterval)this.x);
        partialDerivativeOp.compute(converted, new int[]{2, 0}, (RandomAccessibleInterval)this.xx);
        partialDerivativeOp.compute(converted, new int[]{1, 1}, (RandomAccessibleInterval)this.xy);
        partialDerivativeOp.compute(converted, new int[]{0, 1}, (RandomAccessibleInterval)this.y);
        partialDerivativeOp.compute(converted, new int[]{0, 2}, (RandomAccessibleInterval)this.yy);
        while (cursor.hasNext()) {
            cursor.fwd();
            xRA.setPosition((Localizable)cursor);
            yRA.setPosition((Localizable)cursor);
            xxRA.setPosition((Localizable)cursor);
            xyRA.setPosition((Localizable)cursor);
            yyRA.setPosition((Localizable)cursor);
            double rx = ((DoubleType)xRA.get()).getRealDouble();
            double ry = ((DoubleType)yRA.get()).getRealDouble();
            double rxx = ((DoubleType)xxRA.get()).getRealDouble();
            double rxy = ((DoubleType)xyRA.get()).getRealDouble();
            double ryy = ((DoubleType)yyRA.get()).getRealDouble();
            Matrix hessian = new Matrix(input.numDimensions(), input.numDimensions());
            hessian.set(0, 0, ((DoubleType)xxRA.get()).getRealDouble());
            hessian.set(0, 1, ((DoubleType)xyRA.get()).getRealDouble());
            hessian.set(1, 0, ((DoubleType)xyRA.get()).getRealDouble());
            hessian.set(1, 1, ((DoubleType)yyRA.get()).getRealDouble());
            EigenvalueDecomposition e = hessian.eig();
            Matrix eigenvalues = e.getD();
            Matrix eigenvectors = e.getV();
            int index = Math.abs(eigenvalues.get(0, 0)) > Math.abs(eigenvalues.get(1, 1)) ? 0 : 1;
            double nx = eigenvectors.get(0, index);
            double ny = eigenvectors.get(1, index);
            double t = -1.0 * (rx * nx + ry * ny) / (rxx * nx * nx + 2.0 * rxy * nx * ny + ryy * ny * ny);
            double px = t * nx;
            double py = t * ny;
            if (!(Math.abs(px) <= 0.5) || !(Math.abs(py) <= 0.5)) continue;
            valuesArr[0] = cursor.getLongPosition(0);
            valuesArr[1] = cursor.getLongPosition(1);
            valuesArr[2] = 0L;
            pRA.setPosition(valuesArr);
            ((DoubleType)pRA.get()).set(px);
            pRA.fwd(2);
            ((DoubleType)pRA.get()).set(py);
            nRA.setPosition(valuesArr);
            ((DoubleType)nRA.get()).set(nx);
            nRA.fwd(2);
            ((DoubleType)nRA.get()).set(ny);
            double gradient = eigenvalues.get(index, index) < -smallMax ? Math.abs(eigenvalues.get(index, index)) : 0.0;
            gradientsRA.setPosition((Localizable)cursor);
            ((DoubleType)gradientsRA.get()).set(gradient);
        }
    }

    protected Img<DoubleType> getPValues() {
        return this.pValues;
    }

    protected RandomAccess<DoubleType> getPValuesRandomAccess() {
        return this.pValues.randomAccess();
    }

    protected Img<DoubleType> getNValues() {
        return this.nValues;
    }

    protected RandomAccess<DoubleType> getNValuesRandomAccess() {
        return this.nValues.randomAccess();
    }

    protected Img<DoubleType> getGradients() {
        return this.gradients;
    }

    protected RandomAccess<DoubleType> getGradientsRandomAccess() {
        return this.gradients.randomAccess();
    }
}

