/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.transform;

import net.imglib2.Interval;
import net.imglib2.RealInterval;
import net.imglib2.algorithm.blocks.BlockProcessor;
import net.imglib2.algorithm.blocks.transform.AbstractTransformProcessor;
import net.imglib2.algorithm.blocks.transform.Transform;
import net.imglib2.algorithm.blocks.transform.TransformLine2D;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.type.PrimitiveType;

class Affine2DProcessor<P>
extends AbstractTransformProcessor<P> {
    private final AffineTransform2D transformToSource;
    private final TransformLine2D<P> transformLine;
    private final double[] pdest = new double[2];
    private final double[] psrc = new double[2];

    Affine2DProcessor(AffineTransform2D transformToSource, Transform.Interpolation interpolation, PrimitiveType primitiveType) {
        this(transformToSource, interpolation, primitiveType, TransformLine2D.of(interpolation, primitiveType));
    }

    private Affine2DProcessor(AffineTransform2D transformToSource, Transform.Interpolation interpolation, PrimitiveType primitiveType, TransformLine2D<P> transformLine) {
        super(2, interpolation, primitiveType);
        this.transformToSource = transformToSource;
        this.transformLine = transformLine;
    }

    private Affine2DProcessor(Affine2DProcessor<P> processor) {
        super(processor);
        this.transformToSource = processor.transformToSource;
        this.transformLine = processor.transformLine;
    }

    @Override
    public BlockProcessor<P, P> independentCopy() {
        return new Affine2DProcessor<P>(this);
    }

    @Override
    RealInterval estimateBounds(Interval interval) {
        return this.transformToSource.estimateBounds((RealInterval)interval);
    }

    @Override
    public void compute(P src, P dest) {
        float d0 = this.transformToSource.d(0).getFloatPosition(0);
        float d1 = this.transformToSource.d(0).getFloatPosition(1);
        int ds0 = this.destSize[0];
        int ss0 = this.sourceSize[0];
        this.pdest[0] = this.destPos[0];
        int i = 0;
        for (int y = 0; y < this.destSize[1]; ++y) {
            this.pdest[1] = (long)y + this.destPos[1];
            this.transformToSource.apply(this.pdest, this.psrc);
            float sf0 = (float)(this.psrc[0] - (double)this.sourcePos[0]);
            float sf1 = (float)(this.psrc[1] - (double)this.sourcePos[1]);
            this.transformLine.apply(src, dest, i, ds0, d0, d1, ss0, sf0, sf1);
            i += ds0;
        }
    }
}

