/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.hough;

import java.util.List;
import java.util.function.Predicate;
import net.imglib2.Dimensions;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.localextrema.LocalExtrema;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class HoughTransforms<T extends RealType<T> & Comparable<T>> {
    public static final int DEFAULT_THETA = 180;

    private static final double computeLength(long[] position) {
        double dist = 0.0;
        for (int d = 0; d < position.length; ++d) {
            long pos = position[d];
            dist += (double)(pos * pos);
        }
        return Math.sqrt(dist);
    }

    private static int defaultRho(Dimensions dimensions) {
        return (int)(2.0 * HoughTransforms.computeLength(Intervals.dimensionsAsLongArray(dimensions)));
    }

    public static long[] getVotespaceSize(Dimensions dimensions) {
        return new long[]{HoughTransforms.defaultRho(dimensions), 180L};
    }

    public static long[] getVotespaceSize(Dimensions dimensions, int nTheta) {
        return new long[]{HoughTransforms.defaultRho(dimensions), nTheta};
    }

    public static long[] getVotespaceSize(int nRho, int nTheta) {
        return new long[]{nRho, nTheta};
    }

    public static <T extends IntegerType<T>> List<Point> pickLinePeaks(RandomAccessibleInterval<T> voteSpace, long threshold) {
        IntegerType minPeak = (IntegerType)((IntegerType)Util.getTypeFromInterval(voteSpace)).createVariable();
        minPeak.setInteger(threshold);
        return HoughTransforms.pickLinePeaks(voteSpace, minPeak);
    }

    public static <T extends Comparable<T>> List<Point> pickLinePeaks(RandomAccessibleInterval<T> voteSpace, T minPeak) {
        LocalExtrema.MaximumCheck<T> maxCheck = new LocalExtrema.MaximumCheck<T>(minPeak);
        long[] translation = new long[]{-(voteSpace.dimension(0) / 2L), -(voteSpace.dimension(1) / 2L)};
        IntervalView<T> translatedVotes = Views.translate(voteSpace, translation);
        return LocalExtrema.findLocalExtrema(translatedVotes, maxCheck);
    }

    public static <T extends Comparable<T>, U extends IntegerType<U>> void voteLines(RandomAccessibleInterval<T> input, RandomAccessibleInterval<U> votespace) {
        HoughTransforms.voteLines(input, votespace, 180, HoughTransforms.defaultRho(input));
    }

    public static <T extends Comparable<T>, U extends IntegerType<U>> void voteLines(RandomAccessibleInterval<T> input, RandomAccessibleInterval<U> votespace, int nTheta) {
        HoughTransforms.voteLines(input, votespace, nTheta, HoughTransforms.defaultRho(input), (Comparable)HoughTransforms.getTypeFromInterval(input));
    }

    private static <T> T getTypeFromInterval(RandomAccessibleInterval<T> rai) {
        return rai.randomAccess().get();
    }

    public static <T extends Comparable<T>, U extends IntegerType<U>> void voteLines(RandomAccessibleInterval<T> input, RandomAccessibleInterval<U> votespace, int nTheta, int nRho) {
        HoughTransforms.voteLines(input, votespace, nTheta, nRho, (Comparable)HoughTransforms.getTypeFromInterval(input));
    }

    public static <T extends Comparable<T>, U extends IntegerType<U>> void voteLines(RandomAccessibleInterval<T> input, RandomAccessibleInterval<U> votespace, int nTheta, int nRho, T threshold) {
        Predicate<Comparable> p = o -> threshold.compareTo(o) <= 0;
        HoughTransforms.voteLines(input, votespace, nTheta, nRho, p);
    }

    public static <T, U extends IntegerType<U>> void voteLines(RandomAccessibleInterval<T> input, RandomAccessibleInterval<U> votespace, int nTheta, int nRho, Predicate<T> filter) {
        int t;
        long[] dims = new long[input.numDimensions()];
        input.dimensions(dims);
        double minRho = -HoughTransforms.computeLength(dims);
        double dRho = 2.0 * HoughTransforms.computeLength(dims) / (double)nRho;
        double minTheta = -1.5707963267948966;
        double dTheta = Math.PI / (double)nTheta;
        double[] cTheta = new double[nTheta];
        double[] sTheta = new double[nTheta];
        for (t = 0; t < nTheta; ++t) {
            cTheta[t] = Math.cos(dTheta * (double)t + -1.5707963267948966);
        }
        for (t = 0; t < nTheta; ++t) {
            sTheta[t] = Math.sin(dTheta * (double)t + -1.5707963267948966);
        }
        RealCursor imageCursor = Views.iterable(Views.zeroMin(input)).localizingCursor();
        RandomAccess outputRA = votespace.randomAccess();
        while (imageCursor.hasNext()) {
            imageCursor.fwd();
            if (!filter.test(imageCursor.get())) continue;
            double x = imageCursor.getDoublePosition(0);
            double y = imageCursor.getDoublePosition(1);
            for (int t2 = 0; t2 < nTheta; ++t2) {
                double fRho = cTheta[t2] * x + sTheta[t2] * y;
                long r = Math.round((fRho - minRho) / dRho);
                outputRA.setPosition(r, 0);
                outputRA.setPosition(t2, 1);
                ((IntegerType)outputRA.get()).inc();
            }
        }
    }

    public static double getIntercept(long rho, long theta) {
        double radians = Math.PI * (double)theta / 180.0;
        return (double)rho / Math.sin(radians);
    }

    public static double getSlope(long theta) {
        double radians = Math.PI * (double)theta / 180.0;
        double n = -Math.cos(radians);
        double d = Math.sin(radians);
        if (Math.abs(n) == 1.0) {
            return n > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        return n / d;
    }
}

