/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.neighborhood.HorizontalLineNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.HorizontalLineNeighborhoodLocalizableSampler;
import net.imglib2.algorithm.neighborhood.Neighborhood;

public class HorizontalLineNeighborhoodRandomAccess<T>
extends HorizontalLineNeighborhoodLocalizableSampler<T>
implements RandomAccess<Neighborhood<T>> {
    public HorizontalLineNeighborhoodRandomAccess(RandomAccessible<T> source, long span, int dim, boolean skipCenter, HorizontalLineNeighborhoodFactory<T> factory, Interval interval) {
        super(source, span, dim, skipCenter, factory, interval);
    }

    public HorizontalLineNeighborhoodRandomAccess(RandomAccessible<T> source, long span, int dim, boolean skipCenter, HorizontalLineNeighborhoodFactory<T> factory) {
        super(source, span, dim, skipCenter, factory, null);
    }

    private HorizontalLineNeighborhoodRandomAccess(HorizontalLineNeighborhoodRandomAccess<T> c) {
        super(c);
    }

    @Override
    public void fwd(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + 1L;
    }

    @Override
    public void bck(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] - 1L;
    }

    @Override
    public void move(int distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + (long)distance;
    }

    @Override
    public void move(long distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + distance;
    }

    @Override
    public void move(Localizable localizable) {
        int d = 0;
        while (d < this.n) {
            long distance = localizable.getLongPosition(d);
            int n = d++;
            this.currentPos[n] = this.currentPos[n] + distance;
        }
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + (long)distance[d];
        }
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + distance[d];
        }
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            long position;
            this.currentPos[d] = position = localizable.getLongPosition(d);
        }
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
        }
    }

    @Override
    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
        }
    }

    @Override
    public void setPosition(int position, int d) {
        this.currentPos[d] = position;
    }

    @Override
    public void setPosition(long position, int d) {
        this.currentPos[d] = position;
    }

    @Override
    public HorizontalLineNeighborhoodRandomAccess<T> copy() {
        return new HorizontalLineNeighborhoodRandomAccess<T>(this);
    }
}

