/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import java.util.Arrays;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.StackedRealTransform;

public class StackedInvertibleRealTransform
extends StackedRealTransform
implements InvertibleRealTransform {
    private final InvertibleRealTransform[] transforms;

    public StackedInvertibleRealTransform(InvertibleRealTransform ... transforms) {
        super((RealTransform[])transforms);
        this.transforms = transforms;
    }

    public InvertibleRealTransform copy() {
        return new StackedInvertibleRealTransform((InvertibleRealTransform[])Arrays.stream(this.transforms).map(InvertibleRealTransform::copy).toArray(InvertibleRealTransform[]::new));
    }

    public void applyInverse(double[] source, double[] target) {
        int startSrc = 0;
        int startTgt = 0;
        for (InvertibleRealTransform t : this.transforms) {
            System.arraycopy(target, startTgt, this.tmpTgt, 0, t.numTargetDimensions());
            t.applyInverse(this.tmpSrc, this.tmpTgt);
            System.arraycopy(this.tmpSrc, 0, source, startSrc, t.numSourceDimensions());
            startSrc += t.numSourceDimensions();
            startTgt += t.numTargetDimensions();
        }
    }

    public void applyInverse(RealPositionable source, RealLocalizable target) {
        int startSrc = 0;
        int startTgt = 0;
        for (InvertibleRealTransform t : this.transforms) {
            this.localizeFromIndex(target, this.tmpTgt, startTgt, t.numTargetDimensions());
            t.applyInverse(this.tmpSrc, this.tmpTgt);
            this.positionFromIndex(source, this.tmpSrc, startSrc, t.numSourceDimensions());
            startSrc += t.numSourceDimensions();
            startTgt += t.numTargetDimensions();
        }
    }

    public InvertibleRealTransform inverse() {
        return null;
    }
}

