/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.detection.ManualDetectorFactory;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.detection.SpotDetectorFactoryBase;
import fiji.plugin.trackmate.detection.SpotGlobalDetector;
import fiji.plugin.trackmate.detection.SpotGlobalDetectorFactory;
import fiji.plugin.trackmate.features.EdgeFeatureCalculator;
import fiji.plugin.trackmate.features.FeatureFilter;
import fiji.plugin.trackmate.features.SpotFeatureCalculator;
import fiji.plugin.trackmate.features.TrackFeatureCalculator;
import fiji.plugin.trackmate.tracking.SpotImageTrackerFactory;
import fiji.plugin.trackmate.tracking.SpotTracker;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.Threads;
import ij.gui.Roi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imglib2.Interval;
import net.imglib2.algorithm.Algorithm;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.MultiThreaded;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.scijava.Cancelable;
import org.scijava.Named;
import org.scijava.util.VersionUtils;

public class TrackMate
implements Benchmark,
MultiThreaded,
Algorithm,
Named,
Cancelable {
    public static final String PLUGIN_NAME_STR = "TrackMate";
    public static final String PLUGIN_NAME_VERSION = VersionUtils.getVersion(TrackMate.class);
    protected final Model model;
    protected final Settings settings;
    protected long processingTime;
    protected String errorMessage;
    protected int numThreads = Runtime.getRuntime().availableProcessors();
    private String name;
    private boolean isCanceled;
    private String cancelReason;
    private final List<Cancelable> cancelables = Collections.synchronizedList(new ArrayList());

    public TrackMate(Settings settings) {
        this(new Model(), settings);
    }

    public TrackMate(Model model, Settings settings) {
        this.model = model;
        this.settings = settings;
        this.name = "TrackMate_v" + PLUGIN_NAME_VERSION;
        if (settings.imp != null) {
            this.name = this.name + "_(" + settings.imp.getTitle().replace(' ', '_') + ")";
        }
        this.name = this.name + "_[" + Integer.toHexString(this.hashCode()) + "]";
    }

    public TrackMate() {
        this(new Model(), new Settings());
    }

    public Model getModel() {
        return this.model;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public boolean computeSpotFeatures(boolean doLogIt) {
        this.isCanceled = false;
        this.cancelReason = null;
        this.cancelables.clear();
        Logger logger = this.model.getLogger();
        SpotFeatureCalculator calculator = new SpotFeatureCalculator(this.model, this.settings, doLogIt);
        this.cancelables.add(calculator);
        calculator.setNumThreads(this.numThreads);
        if (calculator.checkInput() && calculator.process()) {
            if (doLogIt) {
                if (this.isCanceled()) {
                    logger.log("Spot feature calculation canceled. Reason:\n" + this.getCancelReason() + "\n");
                }
                logger.log("Computation done in " + calculator.getProcessingTime() + " ms.\n");
            }
            this.model.notifyFeaturesComputed();
            return true;
        }
        this.errorMessage = "Spot features calculation failed:\n" + calculator.getErrorMessage();
        return false;
    }

    public boolean computeEdgeFeatures(boolean doLogIt) {
        this.isCanceled = false;
        this.cancelReason = null;
        this.cancelables.clear();
        Logger logger = this.model.getLogger();
        EdgeFeatureCalculator calculator = new EdgeFeatureCalculator(this.model, this.settings, doLogIt);
        this.cancelables.add(calculator);
        calculator.setNumThreads(this.numThreads);
        if (!calculator.checkInput() || !calculator.process()) {
            this.errorMessage = "Edge features calculation failed:\n" + calculator.getErrorMessage();
            return false;
        }
        if (doLogIt) {
            if (this.isCanceled()) {
                logger.log("Spot feature calculation canceled. Reason:\n" + this.getCancelReason() + "\n");
            }
            logger.log("Computation done in " + calculator.getProcessingTime() + " ms.\n");
        }
        this.model.notifyFeaturesComputed();
        return true;
    }

    public boolean computeTrackFeatures(boolean doLogIt) {
        this.isCanceled = false;
        this.cancelReason = null;
        this.cancelables.clear();
        Logger logger = this.model.getLogger();
        TrackFeatureCalculator calculator = new TrackFeatureCalculator(this.model, this.settings, doLogIt);
        this.cancelables.add(calculator);
        calculator.setNumThreads(this.numThreads);
        if (calculator.checkInput() && calculator.process()) {
            if (doLogIt) {
                if (this.isCanceled()) {
                    logger.log("Spot feature calculation canceled. Reason:\n" + this.getCancelReason() + "\n");
                }
                logger.log("Computation done in " + calculator.getProcessingTime() + " ms.\n");
            }
            this.model.notifyFeaturesComputed();
            return true;
        }
        this.errorMessage = "Track features calculation failed:\n" + calculator.getErrorMessage();
        return false;
    }

    public boolean execTracking() {
        SpotTracker tracker;
        this.isCanceled = false;
        this.cancelReason = null;
        this.cancelables.clear();
        Logger logger = this.model.getLogger();
        logger.log("Starting tracking process.\n", Logger.BLUE_COLOR);
        if (this.settings.trackerFactory == null) {
            logger.log("Tracker factory is not defined. Skipping tracking.\n");
            return true;
        }
        if (SpotImageTrackerFactory.class.isInstance(this.settings.trackerFactory)) {
            SpotImageTrackerFactory f = (SpotImageTrackerFactory)this.settings.trackerFactory;
            tracker = f.create(this.model.getSpots(), this.settings.trackerSettings, this.settings.imp);
        } else {
            tracker = this.settings.trackerFactory.create(this.model.getSpots(), this.settings.trackerSettings);
        }
        if (tracker == null) {
            logger.log("Tracker returned by factory is null. Skipping tracking.\n");
            return true;
        }
        if (tracker instanceof Cancelable) {
            this.cancelables.add((Cancelable)tracker);
        }
        tracker.setNumThreads(this.numThreads);
        tracker.setLogger(logger);
        if (tracker.checkInput() && tracker.process()) {
            if (this.isCanceled()) {
                logger.log("Tracking canceled. Reason:\n" + this.getCancelReason() + "\n");
            }
            this.model.setTracks((SimpleWeightedGraph<Spot, DefaultWeightedEdge>)((SimpleWeightedGraph)tracker.getResult()), true);
            return true;
        }
        this.errorMessage = "Tracking process failed:\n" + tracker.getErrorMessage();
        return false;
    }

    public boolean execDetection() {
        this.isCanceled = false;
        this.cancelReason = null;
        this.cancelables.clear();
        Logger logger = this.model.getLogger();
        logger.log("Starting detection process using " + (this.numThreads > 1 ? this.numThreads + " threads" : "1 thread") + ".\n", Logger.BLUE_COLOR);
        SpotDetectorFactoryBase<?> factory = this.settings.detectorFactory;
        if (null == factory) {
            this.errorMessage = "Detector factory is null.\n";
            return false;
        }
        if (null == this.settings.detectorSettings) {
            this.errorMessage = "Detector settings is null.\n";
            return false;
        }
        if (factory instanceof ManualDetectorFactory) {
            return true;
        }
        ImgPlus img = TMUtils.rawWraps(this.settings.imp);
        if (!factory.setTarget(img, this.settings.detectorSettings)) {
            this.errorMessage = factory.getErrorMessage();
            return false;
        }
        if (factory instanceof SpotGlobalDetectorFactory) {
            return this.processGlobal((SpotGlobalDetectorFactory)factory, img, logger);
        }
        if (factory instanceof SpotDetectorFactory) {
            return this.processFrameByFrame((SpotDetectorFactory)factory, img, logger);
        }
        this.errorMessage = "Don't know how to handle detector factory of type: " + factory.getClass();
        return false;
    }

    private boolean processGlobal(SpotGlobalDetectorFactory factory, ImgPlus img, Logger logger) {
        SpotCollection spots;
        Interval interval = TMUtils.getIntervalWithTime(img, this.settings);
        double[] calibration = TMUtils.getSpatialCalibration(this.settings.imp);
        SpotGlobalDetector detector = factory.getDetector(interval);
        if (detector instanceof MultiThreaded) {
            MultiThreaded md = (MultiThreaded)detector;
            md.setNumThreads(this.numThreads);
        }
        if (detector instanceof Cancelable) {
            this.cancelables.add((Cancelable)detector);
        }
        logger.setStatus("Detection...");
        if (detector.checkInput() && detector.process()) {
            SpotCollection rawSpots = (SpotCollection)detector.getResult();
            rawSpots.setNumThreads(this.numThreads);
            Roi roi = this.settings.getRoi();
            if (roi != null) {
                spots = new SpotCollection();
                spots.setNumThreads(this.numThreads);
                for (int frame = this.settings.tstart; frame <= this.settings.tend; ++frame) {
                    ArrayList<Spot> spotsThisFrame = new ArrayList<Spot>();
                    Iterable<Spot> spotsIt = rawSpots.iterable(frame, false);
                    if (spotsIt == null) continue;
                    for (Spot spot : spotsIt) {
                        if (!roi.contains((int)Math.round(spot.getFeature("POSITION_X") / calibration[0]), (int)Math.round(spot.getFeature("POSITION_Y") / calibration[1]))) continue;
                        spotsThisFrame.add(spot);
                    }
                    spots.put(frame, spotsThisFrame);
                }
            } else {
                spots = rawSpots;
            }
            for (Spot spot : spots.iterable(false)) {
                spot.putFeature("POSITION_T", spot.getFeature("FRAME") * this.settings.dt);
            }
            this.model.setSpots(spots, true);
            logger.setStatus("");
            if (this.isCanceled()) {
                logger.log("Detection canceled. Reason:\n" + this.getCancelReason() + "\n");
            }
        } else {
            this.errorMessage = detector.getErrorMessage();
            return false;
        }
        logger.log("Found " + spots.getNSpots(false) + " spots.\n");
        return true;
    }

    private boolean processFrameByFrame(final SpotDetectorFactory factory, final ImgPlus img, final Logger logger) {
        final Interval interval = TMUtils.getInterval(img, this.settings);
        final int zindex = img.dimensionIndex(Axes.Z);
        final int numFrames = this.settings.tend - this.settings.tstart + 1;
        final SpotCollection spots = new SpotCollection();
        spots.setNumThreads(this.numThreads);
        final AtomicInteger spotFound = new AtomicInteger(0);
        final AtomicInteger progress = new AtomicInteger(0);
        final double[] calibration = TMUtils.getSpatialCalibration(this.settings.imp);
        int nSimultaneousFrames = factory.forbidMultithreading() ? 1 : Math.min(this.numThreads, numFrames);
        final int threadsPerFrame = Math.max(1, this.numThreads / nSimultaneousFrames);
        logger.log("Detection processes " + (nSimultaneousFrames > 1 ? nSimultaneousFrames + " frames" : "1 frame") + " simultaneously and allocates " + (threadsPerFrame > 1 ? threadsPerFrame + " threads" : "1 thread") + " per frame.\n");
        ExecutorService executorService = Threads.newFixedThreadPool(nSimultaneousFrames);
        ArrayList<Future<Boolean>> tasks = new ArrayList<Future<Boolean>>(numFrames);
        int i = this.settings.tstart;
        while (i <= this.settings.tend) {
            final int frame = i++;
            Callable<Boolean> callable = new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ArrayList<Spot> prunedSpots;
                    if (TrackMate.this.isCanceled()) {
                        return Boolean.TRUE;
                    }
                    SpotDetector detector = factory.getDetector(interval, frame);
                    if (detector instanceof MultiThreaded) {
                        MultiThreaded md = (MultiThreaded)detector;
                        md.setNumThreads(threadsPerFrame);
                    }
                    if (detector instanceof Cancelable) {
                        TrackMate.this.cancelables.add((Cancelable)detector);
                    }
                    if (detector.checkInput() && detector.process()) {
                        Roi roi;
                        ArrayList<Spot> spotsThisFrame = (ArrayList<Spot>)detector.getResult();
                        if (img.dimension(0) < 2L && zindex < 0) {
                            for (Spot spot : spotsThisFrame) {
                                spot.putFeature("POSITION_Y", spot.getDoublePosition(0));
                                spot.putFeature("POSITION_X", 0.0);
                            }
                        }
                        if ((roi = TrackMate.this.settings.getRoi()) != null) {
                            prunedSpots = new ArrayList<Spot>();
                            for (Spot spot : spotsThisFrame) {
                                if (!roi.contains((int)Math.round(spot.getFeature("POSITION_X") / calibration[0]), (int)Math.round(spot.getFeature("POSITION_Y") / calibration[1]))) continue;
                                prunedSpots.add(spot);
                            }
                        } else {
                            prunedSpots = spotsThisFrame;
                        }
                        for (Spot spot : prunedSpots) {
                            spot.putFeature("POSITION_T", (double)frame * TrackMate.this.settings.dt);
                        }
                    } else {
                        TrackMate.this.errorMessage = detector.getErrorMessage();
                        return Boolean.FALSE;
                    }
                    spots.put(frame, prunedSpots);
                    spotFound.addAndGet(prunedSpots.size());
                    logger.setProgress((double)progress.incrementAndGet() / (double)numFrames);
                    return Boolean.TRUE;
                }
            };
            Future<Boolean> task = executorService.submit(callable);
            tasks.add(task);
        }
        executorService.shutdown();
        logger.setStatus("Detection...");
        logger.setProgress(0.0);
        AtomicBoolean reportOk = new AtomicBoolean(true);
        try {
            for (Future future : tasks) {
                Boolean ok = (Boolean)future.get();
                if (ok.booleanValue()) continue;
                reportOk.set(false);
                break;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            this.errorMessage = "Problem during detection: " + e.getMessage();
            reportOk.set(false);
            e.printStackTrace();
        }
        this.model.setSpots(spots, true);
        if (reportOk.get()) {
            if (this.isCanceled()) {
                logger.log("Detection canceled after " + (progress.get() + 1) + " frames. Reason:\n" + this.getCancelReason() + "\n");
            }
            logger.log("Found " + spotFound.get() + " spots.\n");
        } else {
            logger.error("Detection failed after " + progress.get() + " frames:\n" + this.errorMessage);
            logger.log("Found " + spotFound.get() + " spots prior failure.\n");
        }
        logger.setProgress(1.0);
        logger.setStatus("");
        return reportOk.get();
    }

    public boolean execInitialSpotFiltering() {
        Logger logger = this.model.getLogger();
        logger.log("Starting initial filtering process.\n");
        Double initialSpotFilterValue = this.settings.initialSpotFilterValue;
        FeatureFilter featureFilter = new FeatureFilter("QUALITY", initialSpotFilterValue, true);
        SpotCollection spots = this.model.getSpots();
        spots.filter(featureFilter);
        spots.crop();
        return true;
    }

    public boolean execSpotFiltering(boolean doLogIt) {
        if (doLogIt) {
            Logger logger = this.model.getLogger();
            logger.log("Starting spot filtering process.\n");
        }
        this.model.filterSpots(this.settings.getSpotFilters(), true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execTrackFiltering(boolean doLogIt) {
        if (doLogIt) {
            Logger logger = this.model.getLogger();
            logger.log("Starting track filtering process.\n");
        }
        this.model.beginUpdate();
        try {
            for (Integer trackID : this.model.getTrackModel().trackIDs(false)) {
                boolean trackIsOk = true;
                for (FeatureFilter filter : this.settings.getTrackFilters()) {
                    Double tval = filter.value;
                    Double val = this.model.getFeatureModel().getTrackFeature(trackID, filter.feature);
                    if (null == val) continue;
                    if (filter.isAbove) {
                        if (!(val < tval)) continue;
                        trackIsOk = false;
                        break;
                    }
                    if (!(val > tval)) continue;
                    trackIsOk = false;
                    break;
                }
                this.model.setTrackVisibility(trackID, trackIsOk);
            }
        }
        finally {
            this.model.endUpdate();
        }
        return true;
    }

    public String toString() {
        return this.name;
    }

    public boolean checkInput() {
        if (null == this.model) {
            this.errorMessage = "The model is null.\n";
            return false;
        }
        if (null == this.settings) {
            this.errorMessage = "Settings are null";
            return false;
        }
        if (!this.settings.checkValidity()) {
            this.errorMessage = this.settings.getErrorMessage();
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean process() {
        if (!this.execDetection()) {
            return false;
        }
        if (this.isCanceled()) {
            return true;
        }
        if (!this.execInitialSpotFiltering()) {
            return false;
        }
        if (this.isCanceled()) {
            return true;
        }
        if (!this.computeSpotFeatures(true)) {
            return false;
        }
        if (this.isCanceled()) {
            return true;
        }
        if (!this.execSpotFiltering(true)) {
            return false;
        }
        if (this.isCanceled()) {
            return true;
        }
        if (!this.execTracking()) {
            return false;
        }
        if (this.isCanceled()) {
            return true;
        }
        if (!this.computeEdgeFeatures(true)) {
            return false;
        }
        if (this.isCanceled()) {
            return true;
        }
        if (!this.computeTrackFeatures(true)) {
            return false;
        }
        if (this.isCanceled()) {
            return true;
        }
        return this.execTrackFiltering(true);
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void cancel(String reason) {
        this.isCanceled = true;
        this.cancelReason = reason;
        this.cancelables.forEach(c -> c.cancel(reason));
        this.cancelables.clear();
    }

    public String getCancelReason() {
        return this.cancelReason;
    }
}

