/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.scijava.plugin.Plugin;

public class TrimNotVisibleAction
extends AbstractTMAction {
    public static final String INFO_TEXT = "<html>This action trims the tracking data by removing anything that is not marked as visible. <p>The spots that do not belong to a visible track will be removed. The tracks that are not marked as visible will be removed as well. <p>This action is irreversible. It helps limiting the memory and disk space of tracking data that has been properly curated.</html>";
    public static final String KEY = "TRIM_NOT_VISIBLE";
    public static final String NAME = "Trim non-visible data";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        Model model = trackmate.getModel();
        TrackModel tm = model.getTrackModel();
        SpotCollection spots = new SpotCollection();
        spots.setNumThreads(trackmate.getNumThreads());
        ArrayList<Spot> toRemove = new ArrayList<Spot>();
        for (Integer trackID : tm.unsortedTrackIDs(false)) {
            if (!tm.isVisible(trackID)) {
                for (Spot spot : tm.trackSpots(trackID)) {
                    toRemove.add(spot);
                }
                continue;
            }
            for (Spot spot : tm.trackSpots(trackID)) {
                spots.add(spot, spot.getFeature("FRAME").intValue());
            }
        }
        model.beginUpdate();
        try {
            for (Spot spot : toRemove) {
                model.removeSpot(spot);
            }
            model.setSpots(spots, false);
        }
        finally {
            model.endUpdate();
        }
    }

    @Plugin(type=TrackMateActionFactory.class)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return TrimNotVisibleAction.INFO_TEXT;
        }

        @Override
        public String getKey() {
            return TrimNotVisibleAction.KEY;
        }

        @Override
        public TrackMateAction create() {
            return new TrimNotVisibleAction();
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.BIN_ICON;
        }

        @Override
        public String getName() {
            return TrimNotVisibleAction.NAME;
        }
    }
}

