/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.fit;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.action.fit.SpotFitter;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.Threads;
import ij.ImagePlus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.imagej.ImgPlus;
import net.imglib2.Cursor;
import net.imglib2.Point;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.apache.commons.math3.fitting.leastsquares.LevenbergMarquardtOptimizer;

public abstract class AbstractSpotFitter
implements SpotFitter {
    protected final ImgPlus<RealType> img;
    protected final int channel;
    protected final double[] calibration;
    protected final LevenbergMarquardtOptimizer optimizer;
    private final ConcurrentHashMap<Integer, RandomAccessibleInterval<RealType>> hyperslices = new ConcurrentHashMap();
    private int numThreads;
    private long processingTime = -1L;

    public AbstractSpotFitter(ImagePlus imp, int channel) {
        this.channel = channel;
        this.img = TMUtils.rawWraps(imp);
        this.calibration = TMUtils.getSpatialCalibration(imp);
        this.optimizer = new LevenbergMarquardtOptimizer().withCostRelativeTolerance(1.0E-12).withParameterRelativeTolerance(1.0E-12);
        this.setNumThreads();
    }

    @Override
    public void process(Iterable<Spot> spots, Logger logger) {
        logger.log(String.format("Starting fitting with %d threads.\n", this.numThreads));
        logger.setStatus("Spot fitting");
        long start = System.currentTimeMillis();
        ExecutorService executorService = Threads.newFixedThreadPool(this.numThreads);
        ArrayList futures = new ArrayList();
        for (Spot spot : spots) {
            futures.add(executorService.submit(() -> this.fit(spot)));
        }
        int nspots = futures.size();
        try {
            int i = 0;
            for (Future future : futures) {
                future.get();
                logger.setProgress((double)i++ / (double)nspots);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        executorService.shutdown();
        long stop = System.currentTimeMillis();
        this.processingTime = stop - start;
        logger.setStatus("");
        logger.setProgress(0.0);
        logger.log(String.format("Fit completed for %d spots in %.1f s.\n", nspots, (double)this.processingTime / 1000.0));
    }

    protected RandomAccessibleInterval<RealType> getSlice(int frame) {
        return this.hyperslices.computeIfAbsent(frame, t -> TMUtils.hyperSlice(this.img, this.channel, t.intValue()));
    }

    @Override
    public abstract void fit(Spot var1);

    public void setNumThreads() {
        this.setNumThreads(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    protected static void clipBackground(Observation obs) {
        double bg = Util.median((double[])obs.values);
        int i = 0;
        while (i < obs.values.length) {
            int n = i++;
            obs.values[n] = obs.values[n] - bg;
        }
        for (i = 0; i < obs.values.length; ++i) {
            obs.values[i] = Math.max(0.0, obs.values[i]);
        }
    }

    protected Observation gatherObservationData(Point point, long[] span, int frame) {
        RandomAccessibleInterval<RealType> slice = this.getSlice(frame);
        int ndims = point.numDimensions();
        long[] min = new long[point.numDimensions()];
        long[] max = new long[point.numDimensions()];
        for (int d = 0; d < max.length; ++d) {
            min[d] = Math.max(point.getLongPosition(d) - span[d], slice.min(0));
            max[d] = Math.min(point.getLongPosition(d) + span[d], slice.max(0));
        }
        IntervalView view = Views.interval(slice, (long[])min, (long[])max);
        int nel = (int)view.size();
        double[] vals = new double[nel];
        long[][] pos = new long[ndims][nel];
        Cursor cursor = view.localizingCursor();
        int index = -1;
        while (cursor.hasNext()) {
            cursor.fwd();
            vals[++index] = ((RealType)cursor.get()).getRealDouble();
            for (int d = 0; d < ndims; ++d) {
                pos[d][index] = cursor.getLongPosition(d);
            }
        }
        return new Observation(vals, pos);
    }

    protected static class Observation {
        public final double[] values;
        public final long[][] pos;

        private Observation(double[] values, long[][] pos) {
            this.values = values;
            this.pos = pos;
        }

        public String toString() {
            StringBuilder str = new StringBuilder(super.toString());
            str.append("\nvalues: " + Util.printCoordinates((double[])this.values));
            for (int d = 0; d < this.pos.length; ++d) {
                str.append("\npos[" + d + "]: " + Util.printCoordinates((long[])this.pos[d]));
            }
            return str.toString();
        }

        public Img<DoubleType> toImg() {
            long[] dims = new long[this.pos.length];
            for (int d = 0; d < dims.length; ++d) {
                long max = Arrays.stream(this.pos[d]).max().getAsLong();
                long min = Arrays.stream(this.pos[d]).min().getAsLong();
                dims[d] = max - min + 1L;
            }
            ArrayImg img = ArrayImgs.doubles((double[])this.values, (long[])dims);
            return img;
        }
    }
}

