/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features.spot;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotRoi;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.features.spot.AbstractSpotFeatureAnalyzer;
import fiji.plugin.trackmate.features.spot.SpotIntensityMultiCAnalyzerFactory;
import fiji.plugin.trackmate.util.SpotNeighborhood;
import fiji.plugin.trackmate.util.SpotUtil;
import net.imagej.ImgPlus;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;

public class SpotContrastAndSNRAnalyzer<T extends RealType<T>>
extends AbstractSpotFeatureAnalyzer<T> {
    protected static final double RAD_PERCENTAGE = 1.0;
    private final int channel;
    private final ImgPlus<T> img;

    public SpotContrastAndSNRAnalyzer(ImgPlus<T> img, int channel) {
        this.img = img;
        this.channel = channel;
    }

    @Override
    public final void process(Spot spot) {
        double meanOut;
        String meanFeature = SpotIntensityMultiCAnalyzerFactory.makeFeatureKey("MEAN_INTENSITY_CH", this.channel);
        String stdFeature = SpotIntensityMultiCAnalyzerFactory.makeFeatureKey("STD_INTENSITY_CH", this.channel);
        double meanIn = spot.getFeature(meanFeature);
        double stdIn = spot.getFeature(stdFeature);
        double radius = spot.getFeature("RADIUS");
        double outterRadius = 2.0 * radius;
        SpotRoi roi = spot.getRoi();
        if (null != roi && DetectionUtils.is2D(this.img)) {
            double alpha = outterRadius / radius;
            SpotRoi outterRoi = roi.copy();
            outterRoi.scale(alpha);
            IterableInterval<T> neighborhood = SpotUtil.iterable(outterRoi, spot, this.img);
            double totalSum = 0.0;
            int nTotal = 0;
            for (RealType t : neighborhood) {
                double val = t.getRealDouble();
                if (Double.isNaN(val)) continue;
                ++nTotal;
                totalSum += val;
            }
            String sumFeature = SpotIntensityMultiCAnalyzerFactory.makeFeatureKey("TOTAL_INTENSITY_CH", this.channel);
            double innerSum = spot.getFeature(sumFeature);
            int nInner = (int)(innerSum / meanIn);
            int nOut = nTotal - nInner;
            double outterSum = totalSum - innerSum;
            meanOut = outterSum / (double)nOut;
        } else {
            Spot largeSpot = new Spot(spot);
            largeSpot.putFeature("RADIUS", outterRadius);
            SpotNeighborhood<T> neighborhood = new SpotNeighborhood<T>(largeSpot, this.img);
            if (neighborhood.size() <= 1L) {
                spot.putFeature(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey("CONTRAST_CH", this.channel), Double.NaN);
                spot.putFeature(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey("SNR_CH", this.channel), Double.NaN);
                return;
            }
            double radius2 = radius * radius;
            int nOut = 0;
            double sumOut = 0.0;
            Cursor cursor = neighborhood.cursor();
            while (cursor.hasNext()) {
                double val;
                cursor.fwd();
                double dist2 = cursor.getDistanceSquared();
                if (!(dist2 > radius2) || Double.isNaN(val = cursor.get().getRealDouble())) continue;
                ++nOut;
                sumOut += val;
            }
            meanOut = sumOut / (double)nOut;
        }
        double contrast = (meanIn - meanOut) / (meanIn + meanOut);
        double snr = (meanIn - meanOut) / stdIn;
        spot.putFeature(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey("CONTRAST_CH", this.channel), contrast);
        spot.putFeature(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey("SNR_CH", this.channel), snr);
    }
}

