/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.displaysettings;

import fiji.plugin.trackmate.gui.displaysettings.Colormap;
import java.awt.Color;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import org.scijava.util.IntArray;

public class ColormapIO {
    private static final List<URI> LUT_FOLDERS = new ArrayList<URI>();

    static List<Colormap> getLUTs() {
        return ColormapIO.loadLUTs();
    }

    private static List<Colormap> loadLUTs() {
        ArrayList<Colormap> luts = new ArrayList<Colormap>();
        for (URI lutFolder : LUT_FOLDERS) {
            try {
                luts.addAll(ColormapIO.loadLUTs(lutFolder));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return luts;
    }

    private static List<Colormap> loadLUTs(URI folder) throws IOException {
        if (folder.getScheme().equals("jar")) {
            String[] array = folder.toString().split("!");
            try (FileSystem fileSystem = FileSystems.newFileSystem(URI.create(array[0]), Collections.emptyMap());){
                Path folderPath = fileSystem.getPath(array[1], new String[0]);
                List<Colormap> list = ColormapIO.loadLUTs(folderPath);
                return list;
            }
        }
        Path folderPath = Paths.get(folder);
        return ColormapIO.loadLUTs(folderPath);
    }

    private static List<Colormap> loadLUTs(Path folderPath) throws IOException {
        ArrayList<Colormap> luts = new ArrayList<Colormap>();
        if (Files.exists(folderPath, new LinkOption[0])) {
            String glob = "*.lut";
            try (DirectoryStream<Path> folderStream = Files.newDirectoryStream(folderPath, "*.lut");){
                for (Path path : folderStream) {
                    Colormap lut = ColormapIO.importLUT(path);
                    if (null == lut) {
                        System.err.println("Could not read LUT file: " + path + ". Skipping.");
                    }
                    luts.add(lut);
                }
            }
        }
        return luts;
    }

    private static final Colormap importLUT(Path path) throws IOException {
        String fileName = path.getFileName().toString();
        String lutName = fileName.substring(0, fileName.indexOf(46));
        try (Scanner scanner = new Scanner(path);){
            Color color;
            ArrayList<Color> colors = new ArrayList<Color>();
            IntArray intAlphas = new IntArray();
            AtomicInteger nLines = new AtomicInteger(0);
            Colormap ips = new Colormap(lutName, 0.0, 1.0);
            while (scanner.hasNext()) {
                if (!scanner.hasNextInt()) {
                    scanner.next();
                    continue;
                }
                intAlphas.addValue(scanner.nextInt());
                color = new Color(scanner.nextInt(), scanner.nextInt(), scanner.nextInt());
                colors.add(color);
                nLines.incrementAndGet();
            }
            if (nLines.get() < 2) {
                color = null;
                return color;
            }
            double[] alphas = new double[intAlphas.size()];
            for (int i = 0; i < alphas.length; ++i) {
                double alpha = (double)intAlphas.get(i).intValue() / (double)(nLines.get() - 1);
                Color color2 = (Color)colors.get(i);
                ips.add(alpha, color2);
            }
            Colormap colormap = ips;
            return colormap;
        }
    }

    static {
        try {
            URI BUILTIN_LUT_FOLDER = ColormapIO.class.getResource("luts/").toURI();
            LUT_FOLDERS.add(BUILTIN_LUT_FOLDER);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

