/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.io;

import com.opencsv.CSVWriter;
import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.io.TmXmlReader;
import fiji.plugin.trackmate.util.TMUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CSVExporter {
    public static final String MISSING_STR = "\u00f8";

    public static final void exportSpots(String csvFile, Model model, boolean visibleOnly) throws IOException {
        TrackModel tm = model.getTrackModel();
        Set<Integer> trackIDs = tm.trackIDs(visibleOnly);
        ArrayList<String> features = new ArrayList<String>(model.getFeatureModel().getSpotFeatures());
        Map<String, Boolean> isInt = model.getFeatureModel().getSpotFeatureIsInt();
        BiFunction<Spot, String, Number> featureVal = (s, f) -> {
            Double obj = s.getFeature((String)f);
            if (obj == null) {
                return null;
            }
            if (isInt.getOrDefault(f, Boolean.FALSE).booleanValue()) {
                return obj.intValue();
            }
            return obj;
        };
        Function<Spot, String> labelFun = s -> s.getName();
        Function<Spot, String> idFun = s -> Integer.toString(s.ID());
        Function<Spot, String> trackIdFun = s -> {
            Integer trackID = tm.trackIDOf((Spot)s);
            if (trackID == null) {
                return MISSING_STR;
            }
            return Integer.toString(trackID);
        };
        Function<Spot, String> trackNameFun = s -> {
            Integer trackID = tm.trackIDOf((Spot)s);
            if (trackID == null) {
                return MISSING_STR;
            }
            return tm.name(trackID);
        };
        Function<Spot, String> trackVisiblityFun = s -> {
            Integer trackID = tm.trackIDOf((Spot)s);
            if (trackID == null || !tm.isVisible(trackID)) {
                return "0";
            }
            return "1";
        };
        List<Function<Spot, String>> extraFuns = Arrays.asList(idFun, labelFun, trackIdFun, trackNameFun, trackVisiblityFun);
        String[][] extraHeaders = new String[][]{{"ID", "ID", "ID", ""}, {"LABEL", "Label", "Label", ""}, {"TRACK_ID", "Track ID", "Track ID", ""}, {"TRACK_NAME", "Track name", "Track name", ""}, {"TRACK_VISIBLE", "Track visibility", "Track visibility", ""}};
        try (CSVWriter writer = new CSVWriter((Writer)new FileWriter(new File(csvFile)), ',', '\u0000', '\"', "\n");){
            CSVExporter.writeHeaderSpots(writer, model, extraHeaders);
            SpotWriter spotWriter = new SpotWriter(writer, features, featureVal, extraFuns);
            for (Integer trackID : trackIDs) {
                ArrayList<Spot> spots = new ArrayList<Spot>(tm.trackSpots(trackID));
                spots.sort(Spot.frameComparator);
                for (Spot spot : spots) {
                    spotWriter.write(spot);
                }
            }
            if (!visibleOnly) {
                for (Spot spot : model.getSpots().iterable(false)) {
                    if (tm.trackIDOf(spot) != null) continue;
                    spotWriter.write(spot);
                }
            }
        }
    }

    private static void writeHeaderSpots(CSVWriter writer, Model model, String[][] extra) {
        ArrayList<String> features = new ArrayList<String>(model.getFeatureModel().getSpotFeatures());
        Map<String, String> featureNames = model.getFeatureModel().getSpotFeatureNames();
        Map<String, String> featureShortNames = model.getFeatureModel().getSpotFeatureShortNames();
        HashMap<String, String> featureUnits = new HashMap<String, String>();
        for (String feature : features) {
            Dimension dimension = model.getFeatureModel().getSpotFeatureDimensions().get(feature);
            String units = TMUtils.getUnitsFor(dimension, model.getSpaceUnits(), model.getTimeUnits());
            featureUnits.put(feature, units);
        }
        CSVExporter.writeHeader(writer, features, featureNames, featureShortNames, featureUnits, extra);
    }

    private static void writeHeader(CSVWriter writer, List<String> features, Map<String, String> featureNames, Map<String, String> featureShortNames, Map<String, String> featureUnits, String[][] extra) {
        String feature;
        int i;
        int columnShift = extra.length;
        int nCols = columnShift + features.size();
        String[] content = new String[nCols];
        boolean skipThirdLine = true;
        boolean skipSecondLine = true;
        for (i = columnShift; i < content.length; ++i) {
            feature = features.get(i - columnShift);
            String name = featureNames.get(features.get(i - columnShift));
            String shortName = featureShortNames.get(features.get(i - columnShift));
            if (!feature.equals(name)) {
                skipSecondLine = false;
            }
            if (name.equals(shortName)) continue;
            skipThirdLine = false;
        }
        for (i = 0; i < extra.length; ++i) {
            content[i] = extra[i][0];
        }
        for (i = columnShift; i < content.length; ++i) {
            content[i] = features.get(i - columnShift);
        }
        writer.writeNext(content);
        if (!skipSecondLine) {
            for (i = 0; i < extra.length; ++i) {
                content[i] = extra[i][1];
            }
            for (i = columnShift; i < content.length; ++i) {
                content[i] = featureNames.get(features.get(i - columnShift));
            }
            writer.writeNext(content);
        }
        if (!skipThirdLine) {
            for (i = 0; i < extra.length; ++i) {
                content[i] = extra[i][2];
            }
            for (i = columnShift; i < content.length; ++i) {
                content[i] = featureShortNames.get(features.get(i - columnShift));
            }
            writer.writeNext(content);
        }
        for (i = 0; i < extra.length; ++i) {
            content[i] = extra[i][3];
        }
        for (i = columnShift; i < content.length; ++i) {
            String unitsStr;
            feature = features.get(i - columnShift);
            String units = featureUnits.get(feature);
            content[i] = unitsStr = units == null || units.isEmpty() ? "" : "(" + units + ")";
        }
        writer.writeNext(content);
    }

    public static void main(String[] args) throws IOException {
        String filename = "samples/FakeTracks.xml";
        TmXmlReader reader = new TmXmlReader(new File("samples/FakeTracks.xml"));
        if (!reader.isReadingOk()) {
            System.out.println(reader.getErrorMessage());
            return;
        }
        String csvFile = "samples/FakeTracks.xml".replace(".xml", "-spots_in_tracks.csv");
        CSVExporter.exportSpots(csvFile, reader.getModel(), false);
        System.out.println("Done.");
        System.out.println("__________________");
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            String line;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
    }

    private static class SpotWriter {
        private final CSVWriter writer;
        private final List<String> features;
        private final List<Function<Spot, String>> extraFuns;
        private final String[] content;
        private final BiFunction<Spot, String, Number> featureVal;
        private final int columnShift;

        public SpotWriter(CSVWriter writer, List<String> features, BiFunction<Spot, String, Number> featureVal, List<Function<Spot, String>> extraFuns) {
            this.writer = writer;
            this.features = features;
            this.featureVal = featureVal;
            this.extraFuns = extraFuns;
            this.columnShift = extraFuns.size();
            int nCols = this.columnShift + features.size();
            this.content = new String[nCols];
        }

        public void write(Spot spot) {
            int i;
            for (i = 0; i < this.columnShift; ++i) {
                this.content[i] = this.extraFuns.get(i).apply(spot);
            }
            for (i = this.columnShift; i < this.content.length; ++i) {
                Number val = this.featureVal.apply(spot, this.features.get(i - this.columnShift));
                this.content[i] = val == null ? CSVExporter.MISSING_STR : val.toString();
            }
            this.writer.writeNext(this.content);
        }
    }
}

