/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.tracker.LAPTrackerSettingsPanel;
import fiji.plugin.trackmate.io.IOUtils;
import fiji.plugin.trackmate.tracking.SpotTracker;
import fiji.plugin.trackmate.tracking.SpotTrackerFactory;
import fiji.plugin.trackmate.tracking.TrackerKeys;
import fiji.plugin.trackmate.tracking.jaqaman.LAPUtils;
import fiji.plugin.trackmate.tracking.jaqaman.SegmentTrackerFactory;
import fiji.plugin.trackmate.tracking.jaqaman.SparseLAPTracker;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.jdom2.Content;
import org.jdom2.Element;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotTrackerFactory.class)
public class SparseLAPTrackerFactory
extends SegmentTrackerFactory {
    public static final String THIS_TRACKER_KEY = "SPARSE_LAP_TRACKER";
    public static final String THIS_NAME = "LAP Tracker";
    public static final String THIS_INFO_TEXT = "<html>This tracker is based on the Linear Assignment Problem mathematical framework. <br>Its implementation is adapted from the following paper: <br><i>Robust single-particle tracking in live-cell time-lapse sequences</i> - <br>Jaqaman <i> et al.</i>, 2008, Nature Methods. <br><p>Tracking happens in 2 steps: First spots are linked from frame to frame to <br>build track segments. These track segments are investigated in a second step <br>for gap-closing (missing detection), splitting and merging events.  <br> <p>Linking costs are proportional to the square distance between source and  <br> target spots, which makes this tracker suitable for Brownian motion.  <br> Penalties can be set to favor linking between spots that have similar  <br> features. <p>Solving the LAP relies on the Jonker-Volgenant solver, and a sparse cost matrix formulation, allowing it to handle very large problems. </html>";

    @Override
    public String getInfoText() {
        return THIS_INFO_TEXT;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getKey() {
        return THIS_TRACKER_KEY;
    }

    @Override
    public String getName() {
        return THIS_NAME;
    }

    @Override
    public SpotTracker create(SpotCollection spots, Map<String, Object> settings) {
        return new SparseLAPTracker(spots, settings);
    }

    @Override
    public SparseLAPTrackerFactory copy() {
        return new SparseLAPTrackerFactory();
    }

    @Override
    public boolean marshall(Map<String, Object> settings, Element element) {
        boolean ok = true;
        StringBuilder str = new StringBuilder();
        Element linkingElement = new Element("Linking");
        ok &= IOUtils.writeAttribute(settings, linkingElement, "LINKING_MAX_DISTANCE", Double.class, str);
        Map lfpm = (Map)settings.get("LINKING_FEATURE_PENALTIES");
        Element lfpElement = new Element("FeaturePenalties");
        IOUtils.marshallMap(lfpm, lfpElement);
        linkingElement.addContent((Content)lfpElement);
        element.addContent((Content)linkingElement);
        return ok & super.marshall(settings, element);
    }

    @Override
    public boolean unmarshall(Element element, Map<String, Object> settings) {
        StringBuilder errorHolder = new StringBuilder();
        boolean ok = this.unmarshallSegment(element, settings, errorHolder);
        Element linkingElement = element.getChild("Linking");
        if (null == linkingElement) {
            errorHolder.append("Could not found the Linking element in XML.\n");
            ok = false;
        } else {
            ok &= IOUtils.readDoubleAttribute(linkingElement, settings, "LINKING_MAX_DISTANCE", errorHolder);
            HashMap<String, Double> lfpMap = new HashMap<String, Double>();
            Element lfpElement = linkingElement.getChild("FeaturePenalties");
            if (null != lfpElement) {
                ok &= IOUtils.unmarshallMap(lfpElement, lfpMap, errorHolder);
            }
            settings.put("LINKING_FEATURE_PENALTIES", lfpMap);
        }
        if (!this.checkSettingsValidity(settings)) {
            ok = false;
            errorHolder.append(this.errorMessage);
        }
        if (!ok) {
            this.errorMessage = errorHolder.toString();
        }
        return ok;
    }

    @Override
    public Map<String, Object> getDefaultSettings() {
        Map<String, Object> settings = LAPUtils.getDefaultSegmentSettingsMap();
        settings.put("LINKING_MAX_DISTANCE", 15.0);
        settings.put("LINKING_FEATURE_PENALTIES", new HashMap<String, Double>(TrackerKeys.DEFAULT_LINKING_FEATURE_PENALTIES));
        return settings;
    }

    @Override
    public boolean checkSettingsValidity(Map<String, Object> settings) {
        if (null == settings) {
            this.errorMessage = "Settings map is null.\n";
            return false;
        }
        StringBuilder str = new StringBuilder();
        boolean ok = LAPUtils.checkSettingsValidity(settings, str, true);
        if (!ok) {
            this.errorMessage = str.toString();
        }
        return ok;
    }

    @Override
    public String toString(Map<String, Object> sm) {
        if (!this.checkSettingsValidity(sm)) {
            return this.errorMessage;
        }
        StringBuilder str = new StringBuilder();
        str.append("  Linking conditions:\n");
        str.append(String.format("    - max distance: %.1f\n", (Double)sm.get("LINKING_MAX_DISTANCE")));
        str.append(LAPUtils.echoFeaturePenalties((Map)sm.get("LINKING_FEATURE_PENALTIES")));
        str.append(super.toString(sm));
        return str.toString();
    }

    @Override
    public ConfigurationPanel getTrackerConfigurationPanel(Model model) {
        String spaceUnits = model.getSpaceUnits();
        Collection<String> features = model.getFeatureModel().getSpotFeatures();
        Map<String, String> featureNames = model.getFeatureModel().getSpotFeatureNames();
        return new LAPTrackerSettingsPanel(this.getName(), spaceUnits, features, featureNames);
    }
}

