/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.gui.displaysettings.Colormap;
import fiji.plugin.trackmate.visualization.TrackColorGenerator;
import java.awt.Color;
import org.jgrapht.graph.DefaultWeightedEdge;

public class PerEdgeFeatureColorGenerator
implements TrackColorGenerator {
    private final Model model;
    private final String edgeFeature;
    private final Color missingValueColor;
    private final Color undefinedValueColor;
    private final Colormap colormap;
    private final double min;
    private final double max;

    public PerEdgeFeatureColorGenerator(Model model, String edgeFeature, Color missingValueColor, Color undefinedValueColor, Colormap colormap, double min, double max) {
        this.model = model;
        this.edgeFeature = edgeFeature;
        this.missingValueColor = missingValueColor;
        this.undefinedValueColor = undefinedValueColor;
        this.colormap = colormap;
        this.min = min;
        this.max = max;
    }

    @Override
    public Color color(DefaultWeightedEdge edge) {
        Double feat = this.model.getFeatureModel().getEdgeFeature(edge, this.edgeFeature);
        if (null == feat) {
            return this.missingValueColor;
        }
        if (feat.isNaN()) {
            return this.undefinedValueColor;
        }
        double val = feat;
        return this.colormap.getPaint((val - this.min) / (this.max - this.min));
    }
}

