/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.hyperstack;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.visualization.hyperstack.HyperStackDisplayer;
import fiji.plugin.trackmate.visualization.hyperstack.ModelEditActions;
import fiji.plugin.trackmate.visualization.hyperstack.SpotEditToolConfigPanel;
import fiji.tool.AbstractTool;
import fiji.tool.ToolWithOptions;
import ij.ImageListener;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.Toolbar;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;

public class SpotEditTool
extends AbstractTool
implements MouseMotionListener,
MouseListener,
KeyListener,
ToolWithOptions {
    private static final String TOOL_NAME = "Spot edit tool";
    private static final String TOOL_ICON = "CeacD70Cd8bD80D71Cc69D81CfefD91CdbcD72Cb9bD82Cd9bD73Cc8aD83CfefD93CdddD54CbaaD64Cb69D74Cb59D84Cb9aD94CdddDa4CfefD25Cd9bD35Cb8aD45CaaaD55CcccD65CfdeL7585CdccD95CaaaDa5Cb8aDb5Cd7aDc5CfceDd5CfeeD26Cc69D36Cc8aD46CdacDb6Cb59Dc6CecdDd6Cb9aD37CdcdD47CeeeDb7Ca89Dc7CfefD28Cc7aD38Cd9cD48CecdDb8Cb79Dc8CfdeDd8CcabD29Cb59D39Cb69D49CedeD59CeacDb9Cc59Dc9CebdDd9CfdeD0aCc7aD1aCb8aD2aCedeD3aCcbcD4aCb7aD5aCe9cD6aCeeeDbaCa89DcaCfefDdaCebdD0bCc59D1bCebdD2bCfefD4bCc7aL5b6bCeceDbbCb79DcbCfdeDdbCfeeD0cCa89D1cCfefD2cCcabL5c6cCc9bDbcCc59DccCdabDdcCedeD0dCb79D1dCedeD2dCc9bL5d6dCecdD9dCc8aDadCb9aDbdCdbcDcdCb8aDddCd8bDedCfceDfdCebdD0eCc59D1eCebdD2eCfeeD4eCc7aD5eCc6aD6eCfeeD7eCd9bD9eCc59DaeCfdeDbeCebdDdeCc59DeeCeacDfeCfefD0fCdbcD1fCdddD4fCdcdL5f6fCdddD7fCfdeD9fCdbdDafCebdDefCfefDff";
    private static SpotEditTool instance;
    private final Map<ImagePlus, ModelEditActions> editorMap = new HashMap<ImagePlus, ModelEditActions>();
    private boolean autolinkingmode = false;
    private final SpotEditToolParams params = new SpotEditToolParams();
    private final Logger logger = new MyLogger();
    private final SpotEditToolConfigPanel configPanel = new SpotEditToolConfigPanel(this.params);

    private SpotEditTool() {
        this.configPanel.buttonSelectTrackDown.addActionListener(e -> this.selectTrackDownward());
        this.configPanel.buttonSelectTrackUp.addActionListener(e -> this.selectTrackUpward());
        this.configPanel.buttonSemiAutoTracking.addActionListener(e -> this.semiAutoTracking());
        this.configPanel.buttonSelectTrack.addActionListener(e -> this.selectTrack());
        ImagePlus.addImageListener((ImageListener)new ImageListener(){

            public void imageUpdated(ImagePlus imp) {
            }

            public void imageOpened(ImagePlus imp) {
            }

            public void imageClosed(ImagePlus imp) {
                SpotEditTool.this.editorMap.remove(imp);
            }
        });
    }

    public static SpotEditTool getInstance() {
        if (null == instance) {
            instance = new SpotEditTool();
        }
        return instance;
    }

    public static boolean isLaunched() {
        Toolbar toolbar = Toolbar.getInstance();
        return null != toolbar && toolbar.getToolId(TOOL_NAME) >= 0;
    }

    @Override
    public String getToolName() {
        return TOOL_NAME;
    }

    @Override
    public String getToolIcon() {
        return TOOL_ICON;
    }

    @Override
    protected void registerTool(ImageCanvas canvas) {
        MouseListener[] listeners;
        for (MouseListener listener : listeners = canvas.getMouseListeners()) {
            if (listener != this.mouseProxy) continue;
            return;
        }
        super.registerTool(canvas);
    }

    public void register(HyperStackDisplayer displayer) {
        ImagePlus imp = displayer.getImp();
        Model model = displayer.getModel();
        SelectionModel selectionModel = displayer.getSelectionModel();
        ModelEditActions actions = new ModelEditActions(imp, model, selectionModel, this.logger);
        this.editorMap.put(imp, actions);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        ImagePlus lImp = this.getImagePlus(e);
        ModelEditActions actions = this.editorMap.get(lImp);
        if (null == actions) {
            return;
        }
        int addToSelectionMask = 64;
        boolean addToSelection = (e.getModifiersEx() & 0x40) == 64;
        actions.select(e.getPoint(), addToSelection, !this.autolinkingmode);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        ImagePlus imp = this.getImagePlus(e);
        ModelEditActions actions = this.editorMap.get(imp);
        if (actions == null) {
            return;
        }
        actions.selectInRoi(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        ImagePlus imp = this.getImagePlus(e);
        ModelEditActions actions = this.editorMap.get(imp);
        if (null == actions) {
            return;
        }
        actions.roiEdit(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        ImagePlus imp = this.getImagePlus(e);
        ModelEditActions actions = this.editorMap.get(imp);
        if (actions == null) {
            return;
        }
        actions.moveSpot(e.getPoint());
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        ImagePlus imp = this.getImagePlus(e);
        ModelEditActions actions = this.editorMap.get(imp);
        if (null == actions) {
            return;
        }
        switch (e.getKeyCode()) {
            case 38: {
                actions.navigateToParent();
                e.consume();
                break;
            }
            case 40: {
                actions.navigateToChild();
                e.consume();
                break;
            }
            case 37: {
                actions.navigateToPreviousSibling();
                e.consume();
                break;
            }
            case 39: {
                actions.navigateToNextSibling();
                e.consume();
                break;
            }
            case 34: {
                actions.navigateToNextTrack();
                e.consume();
                break;
            }
            case 33: {
                actions.navigateToPreviousTrack();
                e.consume();
                break;
            }
            case 127: {
                actions.deleteSpotSelection();
                e.consume();
                break;
            }
            case 65: {
                if (e.isShiftDown()) {
                    actions.semiAutoTracking(this.params.qualityThreshold, this.params.distanceTolerance, this.params.nFrames);
                } else {
                    actions.addSpot(this.autolinkingmode);
                }
                e.consume();
                break;
            }
            case 68: {
                actions.deleteSpot();
                e.consume();
                break;
            }
            case 32: {
                actions.startMoveSpot();
                e.consume();
                break;
            }
            case 69: 
            case 81: {
                e.consume();
                actions.changeSpotRadius(e.getKeyCode() == 69, e.isShiftDown());
                break;
            }
            case 76: {
                if (e.isShiftDown()) {
                    this.autolinkingmode = !this.autolinkingmode;
                    this.logger.log("Toggled auto-linking mode " + (this.autolinkingmode ? "on.\n" : "off.\n"));
                } else {
                    actions.toggleLink();
                }
                e.consume();
                break;
            }
            case 70: 
            case 71: {
                actions.stepInTime(e.getKeyCode() == 71, this.params.stepwiseTimeBrowsing);
                e.consume();
                break;
            }
            case 87: {
                e.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 32: {
                ImagePlus imp = this.getImagePlus(e);
                ModelEditActions actions = this.editorMap.get(imp);
                if (actions == null) break;
                actions.endMoveSpot();
                break;
            }
        }
    }

    @Override
    public void showOptionDialog() {
        this.configPanel.setLocation(this.toolbar.getLocationOnScreen());
        this.configPanel.setVisible(true);
    }

    private void selectTrack() {
        ImagePlus imp = WindowManager.getCurrentImage();
        ModelEditActions actions = this.editorMap.get(imp);
        if (null == actions) {
            return;
        }
        actions.selectTrack();
    }

    private void semiAutoTracking() {
        ImagePlus imp = WindowManager.getCurrentImage();
        ModelEditActions actions = this.editorMap.get(imp);
        if (null == actions) {
            return;
        }
        actions.semiAutoTracking(this.params.qualityThreshold, this.params.distanceTolerance, this.params.nFrames);
    }

    private void selectTrackDownward() {
        ImagePlus imp = WindowManager.getCurrentImage();
        ModelEditActions actions = this.editorMap.get(imp);
        if (null == actions) {
            return;
        }
        actions.selectTrackDownward();
    }

    private void selectTrackUpward() {
        ImagePlus imp = WindowManager.getCurrentImage();
        ModelEditActions actions = this.editorMap.get(imp);
        if (null == actions) {
            return;
        }
        actions.selectTrackUpward();
    }

    private class MyLogger
    extends Logger {
        private MyLogger() {
        }

        private Logger logger() {
            if (SpotEditTool.this.configPanel.isVisible()) {
                return SpotEditTool.this.configPanel.getLogger();
            }
            return Logger.IJTOOLBAR_LOGGER;
        }

        @Override
        public void log(String message, Color color) {
            this.logger().log(message, color);
        }

        @Override
        public void error(String message) {
            this.logger().error(message);
        }

        @Override
        public void setProgress(double val) {
            this.logger().setProgress(val);
        }

        @Override
        public void setStatus(String status) {
            this.logger().setStatus(status);
        }
    }

    static class SpotEditToolParams {
        double qualityThreshold = 0.5;
        double distanceTolerance = 2.0;
        int nFrames = 10;
        int stepwiseTimeBrowsing = 1;

        SpotEditToolParams() {
        }

        public String toString() {
            return super.toString() + ": QualityThreshold = " + this.qualityThreshold + ", DistanceTolerance = " + this.distanceTolerance + ", nFrames = " + this.nFrames;
        }
    }
}

