/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display;

import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayService;
import net.imagej.display.ZoomService;
import org.scijava.input.InputService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.thread.ThreadService;
import org.scijava.util.IntCoords;
import org.scijava.util.RealCoords;
import org.scijava.util.RealRect;

@Plugin(type=Service.class)
public class DefaultZoomService
extends AbstractService
implements ZoomService {
    @Parameter
    private ThreadService threadService;
    @Parameter
    private InputService inputService;
    @Parameter
    private OverlayService overlayService;

    @Override
    public void zoomIn(final ImageDisplay display) {
        this.threadService.queue(new Runnable(){

            @Override
            public void run() {
                if (DefaultZoomService.this.inputService.getDisplay() == display) {
                    int x = DefaultZoomService.this.inputService.getX();
                    int y = DefaultZoomService.this.inputService.getY();
                    display.getCanvas().zoomIn(new IntCoords(x, y));
                } else {
                    display.getCanvas().zoomIn();
                }
            }
        });
    }

    @Override
    public void zoomOut(final ImageDisplay display) {
        this.threadService.queue(new Runnable(){

            @Override
            public void run() {
                if (DefaultZoomService.this.inputService.getDisplay() == display) {
                    int x = DefaultZoomService.this.inputService.getX();
                    int y = DefaultZoomService.this.inputService.getY();
                    display.getCanvas().zoomOut(new IntCoords(x, y));
                } else {
                    display.getCanvas().zoomOut();
                }
            }
        });
    }

    @Override
    public void zoomOriginalScale(final ImageDisplay display) {
        this.threadService.queue(new Runnable(){

            @Override
            public void run() {
                display.getCanvas().setZoom(0.0);
                display.getCanvas().panReset();
            }
        });
    }

    @Override
    public void zoom100Percent(final ImageDisplay display) {
        this.threadService.queue(new Runnable(){

            @Override
            public void run() {
                display.getCanvas().setZoom(1.0);
            }
        });
    }

    @Override
    public void zoomToSelection(final ImageDisplay display) {
        this.threadService.queue(new Runnable(){

            @Override
            public void run() {
                RealRect selection = DefaultZoomService.this.overlayService.getSelectionBounds(display);
                display.getCanvas().zoomToFit(selection);
            }
        });
    }

    @Override
    public void zoomSet(final ImageDisplay display, final double zoomPercent, final double centerU, final double centerV) {
        this.threadService.queue(new Runnable(){

            @Override
            public void run() {
                display.getCanvas().setZoomAndCenter(zoomPercent / 100.0, new RealCoords(centerU, centerV));
            }
        });
    }
}

