/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.vaa3d.reader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.janelia.vaa3d.reader.PbdInputStream;

public class Pbd16InputStream
extends PbdInputStream {
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private byte[] nibbleBytes = new byte[2];
    private ByteBuffer nibbleByteBuffer = ByteBuffer.wrap(this.nibbleBytes);
    private ShortBuffer nibbleShortBuffer;
    private byte[] singleShortBytes = new byte[2];
    private ByteBuffer singleShortByteBuffer = ByteBuffer.wrap(this.singleShortBytes);
    private ShortBuffer singleShortShortBuffer;
    private short repeatValue;
    private short decompressionPrior;
    private byte d0;
    private byte d1;
    private byte d2;
    private byte d3;
    private byte carryOver;
    private byte oooooool = 1;
    private byte ooooooll = (byte)3;
    private byte ooooolll = (byte)7;
    private Deque<Short> shortValueCache = new ArrayDeque<Short>();
    private boolean haveCachedNibble = false;

    public Pbd16InputStream(InputStream in, ByteOrder byteOrder) {
        super(in);
        this.byteOrder = byteOrder;
        this.nibbleByteBuffer.order(byteOrder);
        this.nibbleShortBuffer = this.nibbleByteBuffer.asShortBuffer();
        this.singleShortByteBuffer.order(byteOrder);
        this.singleShortShortBuffer = this.singleShortByteBuffer.asShortBuffer();
    }

    @Override
    public int read(byte[] b, int off0, int len0) throws IOException {
        int len;
        int off;
        if (len0 < 1) {
            return 0;
        }
        int bytesRead = 0;
        if (this.haveCachedNibble) {
            b[off0] = this.nibbleBytes[1];
            off = off0 + 1;
            len = len0 - 1;
            this.haveCachedNibble = false;
            ++bytesRead;
            if (len == 0) {
                return bytesRead;
            }
        } else {
            off = off0;
            len = len0;
        }
        ByteBuffer byteOut = ByteBuffer.wrap(b, off, len);
        byteOut.order(this.byteOrder);
        ShortBuffer out = byteOut.asShortBuffer();
        int shortValue = this.getNextShort();
        if (shortValue < 0 && bytesRead == 0) {
            return shortValue;
        }
        if (!out.hasRemaining() && this.cacheNibble(shortValue)) {
            b[off0 + len0 - 1] = this.nibbleBytes[0];
            ++bytesRead;
        }
        while (out.hasRemaining() && shortValue >= 0) {
            out.put((short)shortValue);
            bytesRead += 2;
            if (!out.hasRemaining()) continue;
            shortValue = this.getNextShort();
        }
        if (len0 - bytesRead == 1 && this.cacheNibble(shortValue = this.getNextShort())) {
            b[off0 + len0 - 1] = this.nibbleBytes[0];
            ++bytesRead;
        }
        return bytesRead;
    }

    private boolean cacheNibble(int value) {
        if (value < 0) {
            this.haveCachedNibble = false;
            return false;
        }
        this.nibbleShortBuffer.rewind();
        this.nibbleShortBuffer.put((short)value);
        this.haveCachedNibble = true;
        return true;
    }

    private int getNextShort() throws IOException {
        while (true) {
            short value;
            if (!this.shortValueCache.isEmpty()) {
                return this.shortValueCache.pollFirst().shortValue();
            }
            if (this.state == PbdInputStream.State.STATE_BEGIN) {
                int code = this.in.read();
                if (code < 0) {
                    return code;
                }
                assert (code >= 0);
                if (code < 32) {
                    this.state = PbdInputStream.State.STATE_LITERAL;
                    this.leftToFill = code + 1;
                    continue;
                }
                if (code < 80) {
                    this.state = PbdInputStream.State.STATE_DIFFERENCE;
                    this.leftToFill = code - 31;
                    continue;
                }
                if (code < 223) {
                    throw new IOException("Received unimplemented code of " + code);
                }
                this.state = PbdInputStream.State.STATE_REPEAT;
                this.leftToFill = code - 222;
                this.in.read(this.singleShortBytes, 0, 2);
                this.repeatValue = this.singleShortShortBuffer.get(0);
                continue;
            }
            if (this.state == PbdInputStream.State.STATE_LITERAL) {
                for (int s = 0; s < this.leftToFill; ++s) {
                    this.in.read(this.singleShortBytes, 0, 2);
                    value = this.singleShortShortBuffer.get(0);
                    this.shortValueCache.add(value);
                }
                this.state = PbdInputStream.State.STATE_BEGIN;
                this.leftToFill = 1;
                this.decompressionPrior = this.shortValueCache.peekLast();
                continue;
            }
            if (this.state == PbdInputStream.State.STATE_DIFFERENCE) {
                while (this.leftToFill > 0) {
                    this.d3 = 0;
                    this.d2 = 0;
                    this.d1 = 0;
                    this.d0 = 0;
                    int sourceChar2 = this.in.read();
                    this.d0 = (byte)(sourceChar2 >>> 5);
                    value = (short)(this.decompressionPrior + (this.d0 < 5 ? this.d0 : 4 - this.d0));
                    this.shortValueCache.add(value);
                    --this.leftToFill;
                    if (this.leftToFill == 0) break;
                    this.d1 = (byte)(sourceChar2 >>> 2 & this.ooooolll);
                    value = (short)(value + (this.d1 < 5 ? this.d1 : 4 - this.d1));
                    this.shortValueCache.add(value);
                    --this.leftToFill;
                    if (this.leftToFill == 0) break;
                    this.carryOver = this.d2 = (byte)(sourceChar2 & this.ooooooll);
                    this.d3 = 0;
                    this.d2 = 0;
                    this.d1 = 0;
                    this.d0 = 0;
                    sourceChar2 = this.in.read();
                    this.carryOver = (byte)(this.carryOver << 1);
                    this.d0 = (byte)(sourceChar2 >>> 7 | this.carryOver);
                    value = (short)(value + (this.d0 < 5 ? this.d0 : 4 - this.d0));
                    this.shortValueCache.add(value);
                    --this.leftToFill;
                    if (this.leftToFill == 0) break;
                    this.d1 = (byte)(sourceChar2 >>> 4 & this.ooooolll);
                    value = (short)(value + (this.d1 < 5 ? this.d1 : 4 - this.d1));
                    this.shortValueCache.add(value);
                    --this.leftToFill;
                    if (this.leftToFill == 0) break;
                    this.d2 = (byte)(sourceChar2 >>> 1 & this.ooooolll);
                    value = (short)(value + (this.d2 < 5 ? this.d2 : 4 - this.d2));
                    this.shortValueCache.add(value);
                    --this.leftToFill;
                    if (this.leftToFill == 0) break;
                    this.carryOver = this.d3 = (byte)(sourceChar2 & this.oooooool);
                    this.d3 = 0;
                    this.d2 = 0;
                    this.d1 = 0;
                    this.d0 = 0;
                    sourceChar2 = this.in.read();
                    this.carryOver = (byte)(this.carryOver << 2);
                    this.d0 = (byte)(sourceChar2 >>> 6 | this.carryOver);
                    value = (short)(value + (this.d0 < 5 ? this.d0 : 4 - this.d0));
                    this.shortValueCache.add(value);
                    --this.leftToFill;
                    if (this.leftToFill == 0) break;
                    this.d1 = (byte)(sourceChar2 >>> 3 & this.ooooolll);
                    value = (short)(value + (this.d1 < 5 ? this.d1 : 4 - this.d1));
                    this.shortValueCache.add(value);
                    --this.leftToFill;
                    if (this.leftToFill == 0) break;
                    this.d2 = (byte)(sourceChar2 & this.ooooolll);
                    value = (short)(value + (this.d2 < 5 ? this.d2 : 4 - this.d2));
                    this.shortValueCache.add(value);
                    --this.leftToFill;
                    if (this.leftToFill == 0) break;
                    this.decompressionPrior = this.shortValueCache.peekLast();
                }
                if (!this.shortValueCache.isEmpty()) {
                    this.decompressionPrior = this.shortValueCache.peekLast();
                }
                if (this.leftToFill >= 1) continue;
                this.state = PbdInputStream.State.STATE_BEGIN;
                continue;
            }
            if (this.state != PbdInputStream.State.STATE_REPEAT) break;
            for (int j = 0; j < this.leftToFill; ++j) {
                this.shortValueCache.add(this.repeatValue);
            }
            this.leftToFill = 0;
            this.state = PbdInputStream.State.STATE_BEGIN;
            this.decompressionPrior = this.repeatValue;
        }
        throw new IOException("Unexpected state");
    }
}

