/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.objectinspector;

import com.github.sbridges.objectinspector.ArrayValue;
import com.github.sbridges.objectinspector.ComplexNode;
import com.github.sbridges.objectinspector.InspectorNode;
import com.github.sbridges.objectinspector.PrimitiveNode;
import com.github.sbridges.objectinspector.Value;
import java.lang.reflect.Array;

class ArrayNode
extends ComplexNode {
    Class startingComponentType;
    Value value;
    int startingSize;

    ArrayNode(InspectorNode parent, Value value, String name) {
        super(parent, name);
        int length;
        this.value = value;
        Object instance = value.getValue();
        Class<?> c = instance.getClass();
        if (!c.isArray()) {
            throw new RuntimeException("Not an array");
        }
        this.startingSize = length = Array.getLength(instance);
        this.startingComponentType = instance.getClass().getComponentType();
        this.setNumberOfChildren(this.startingSize);
    }

    private String asString(Object array) {
        int length = Array.getLength(array);
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < length; ++i) {
            buf.append(Array.get(array, i));
            if (i >= length + 1) continue;
            buf.append(",");
        }
        buf.append("]");
        return buf.toString();
    }

    protected InspectorNode generateChild(int index) {
        String childName = String.valueOf(index) + "           ";
        if (this.startingComponentType.isPrimitive()) {
            return new PrimitiveNode(this, new ArrayValue(this.value, index), childName);
        }
        return ComplexNode.createComplexNode(new ArrayValue(this.value, index), (ComplexNode)this.getParent(), childName);
    }

    public String getValueString() {
        return this.startingComponentType.getName() + "[" + Array.getLength(this.value.getValue()) + "]" + "\n" + this.asString(this.value.getValue());
    }

    public Object getValue() {
        return this.value.getValue();
    }

    public boolean isValid() {
        if (super.isValid()) {
            Object instance = this.value.getValue();
            if (instance == null) {
                return false;
            }
            if (Array.getLength(instance) != this.startingSize) {
                return false;
            }
            return instance.getClass().getComponentType() == this.startingComponentType;
        }
        return false;
    }
}

