/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.objectinspector;

import com.github.sbridges.objectinspector.ComplexNode;
import com.github.sbridges.objectinspector.ConvolutedClass;
import com.github.sbridges.objectinspector.InspectorNode;
import com.github.sbridges.objectinspector.InspectorWindowListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class Inspector
extends JPanel {
    private Object inspecting;
    private JTree tree;
    private JTextArea text;
    private InspectorNode root;

    public static void main(String[] args) {
        Inspector.inspectAndWait(new ConvolutedClass());
        System.exit(0);
    }

    public static final JFrame inspect(Object obj) {
        JFrame f = Inspector.getInspectorWindow(obj);
        f.addWindowListener(new InspectorWindowListener(null));
        f.show();
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void inspectAndWait(Object obj) {
        Object lock;
        JFrame f = Inspector.getInspectorWindow(obj);
        Object object = lock = new Object();
        synchronized (object) {
            f.addWindowListener(new InspectorWindowListener(lock));
            f.show();
            while (f.isVisible()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    private static final JFrame getInspectorWindow(Object obj) {
        String name = obj == null ? "null" : "a " + obj.getClass().getName() + " - " + obj;
        Inspector p = new Inspector(obj);
        JFrame f = new JFrame(name);
        f.getContentPane().add((Component)p, "Center");
        f.setSize(550, 400);
        f.setDefaultCloseOperation(2);
        return f;
    }

    public Inspector() {
        this.init(null);
    }

    public Inspector(Object obj) {
        this.init(obj);
    }

    public Inspector(boolean doubleBuffered, Object obj) {
        super(doubleBuffered);
        this.init(obj);
    }

    private void init(Object obj) {
        this.tree = new JTree();
        this.setInspecting(obj);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        this.tree.setCellRenderer(renderer);
        this.tree.addTreeSelectionListener(new SelectionListener());
        this.text = new JTextArea();
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        JScrollPane left = new JScrollPane(this.tree);
        JScrollPane right = new JScrollPane(this.text);
        JSplitPane splitPane = new JSplitPane(1, left, right);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        splitPane.setDividerLocation(350);
    }

    public Object getInspecting() {
        return this.inspecting;
    }

    public void setInspecting(Object obj) {
        this.inspecting = obj;
        this.root = ComplexNode.createInspectorTree(this.inspecting);
        this.tree.setModel(new DefaultTreeModel(this.root));
    }

    class SelectionListener
    implements TreeSelectionListener {
        SelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            Object last = Inspector.this.tree.getLastSelectedPathComponent();
            if (last != null) {
                InspectorNode in = (InspectorNode)last;
                if (!in.isValid()) {
                    System.err.println("reseting root value");
                    System.err.println(Inspector.this.root.getValue());
                    Inspector.this.setInspecting(Inspector.this.root.getValue());
                } else {
                    Inspector.this.text.setText(in.getValueString());
                }
            }
        }
    }
}

