/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import fiji.geom.AreaCalculations;
import ij.CommandListener;
import ij.Executer;
import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.WindowManager;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.FakeImagePlus;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Profile;
import ini.trakem2.display.Selection;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.tree.ProjectTree;
import ini.trakem2.utils.M;
import ini.trakem2.utils.Utils;
import java.awt.Menu;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;

public class ImageJCommandListener
implements CommandListener {
    public ImageJCommandListener() {
        Executer.addCommandListener((CommandListener)this);
    }

    public void destroy() {
        Executer.removeCommandListener((CommandListener)this);
    }

    private void niy(String command) {
        Utils.log("'" + command + "' -- not implemented yet.");
    }

    private void notAvailable(String command) {
        Utils.log("'" + command + "' -- is not available in TrakEM2");
    }

    private boolean in(String command, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (!command.equals(list[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isPatch(String command, Displayable active) {
        if (null == active) {
            Utils.log("Nothing selected!");
            return false;
        }
        if (!(active instanceof Patch)) {
            Utils.log("Can't run '" + command + "' on a non-image object.");
            return false;
        }
        return true;
    }

    private String setTempCurrentImage(String command, Displayable active) {
        if (!this.isPatch(command, active)) {
            return null;
        }
        Patch pa = (Patch)active;
        Project project = pa.getProject();
        WindowManager.setTempCurrentImage((ImagePlus)pa.getImagePlus());
        project.getLoader().releaseToFit(project.getLoader().estimateImageFileSize(pa, 0) * 5L);
        return command;
    }

    private String duplicate(String command, Displayable active) {
        if (!this.isPatch(command, active)) {
            return null;
        }
        Patch pa = (Patch)active;
        Project project = pa.getProject();
        project.getLoader().releaseToFit(project.getLoader().estimateImageFileSize(pa, 0) * 5L);
        ImagePlus imp = new ImagePlus("Copy of " + pa.getTitle(), pa.getImageProcessor().duplicate());
        WindowManager.setTempCurrentImage((ImagePlus)imp);
        imp.show();
        return command;
    }

    private String runOnVirtualLayerSet(String command, LayerSet layer_set, Display display) {
        ImagePlus imp = layer_set.createLayerStack(Displayable.class, 4, display.getDisplayChannelAlphas()).getImagePlus();
        WindowManager.setTempCurrentImage((ImagePlus)imp);
        return command;
    }

    public String commandExecuting(String command) {
        ImagePlus current = WindowManager.getCurrentImage();
        if (!(current instanceof FakeImagePlus)) {
            return command;
        }
        FakeImagePlus fimp = (FakeImagePlus)current;
        Display display = fimp.getDisplay();
        LayerSet layer_set = display.getLayer().getParent();
        Project project = display.getProject();
        ProjectTree ptree = project.getProjectTree();
        Displayable active = display.getActive();
        Selection selection = display.getSelection();
        if (command.equals("Save")) {
            project.save();
            return null;
        }
        if (command.equals("Undo")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Cut")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Copy")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Copy to System")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Paste")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Clear")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Clear Outside")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Fill")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Draw")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Invert")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Select All")) {
            if (10 == Toolbar.getToolId()) {
                selection.selectAll();
                return null;
            }
            return command;
        }
        if (command.equals("Select None")) {
            if (10 == Toolbar.getToolId()) {
                display.select(null);
                return null;
            }
            return command;
        }
        if (command.equals("Restore Selection")) {
            if (10 == Toolbar.getToolId()) {
                selection.restore();
                return null;
            }
            return command;
        }
        if (command.equals("8-bit")) {
            this.niy(command);
            return null;
        }
        if (command.equals("16-bit")) {
            this.niy(command);
            return null;
        }
        if (command.equals("32-bit")) {
            this.niy(command);
            return null;
        }
        if (command.equals("8-bit Color")) {
            this.niy(command);
            return null;
        }
        if (command.equals("RGB Color")) {
            this.niy(command);
            return null;
        }
        if (command.equals("RGB Stack") || command.equals("HSB Stack")) {
            Utils.showMessage("Can't convert to " + command);
            return null;
        }
        if (command.equals("Brightness/Contrast...")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Window/Level...")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Color Balance...")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Threshold...")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Size...")) {
            if (null != active) {
                selection.specify();
            }
            return null;
        }
        if (command.equals("Canvas Size...")) {
            display.resizeCanvas();
            return null;
        }
        if (command.equals("Show Info...")) {
            if (null == active) {
                ptree.showInfo(project.getRootProjectThing());
            } else {
                ProjectThing pt = project.findProjectThing(active);
                if (null != pt) {
                    ptree.showInfo(pt);
                }
            }
            return null;
        }
        if (this.in(command, new String[]{"RGB Split", "RGB Merge...", "Stack to RGB", "Make Composite"})) {
            this.notAvailable(command);
            return null;
        }
        if (command.equals("Show LUT")) {
            return this.setTempCurrentImage(command, active);
        }
        if (command.equals("Edit LUT...")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Average Color")) {
            this.niy(command);
            return null;
        }
        if (command.equals("RGB to CIELAB")) {
            this.niy(command);
            return null;
        }
        if (command.equals("RGB to Luminance")) {
            this.niy(command);
            return null;
        }
        if (this.in(command, new String[]{"Add Slice", "Delete Slice"})) {
            Utils.showMessage("Go to the Layer Tree and right-click to add/delete a layer.");
            return null;
        }
        if (command.equals("Next Slice [>]")) {
            display.nextLayer(IJ.shiftKeyDown() ? 1 : 0);
            return null;
        }
        if (command.equals("Previous Slice [<]")) {
            display.previousLayer(IJ.shiftKeyDown() ? 1 : 0);
            return null;
        }
        if (this.in(command, new String[]{"Set Slice", "Images to Stack", "Stack to Images", "Make Montage..."})) {
            this.notAvailable(command);
            return null;
        }
        if (command.equals("Reslice [/]...")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Z Project...")) {
            this.niy(command);
            return null;
        }
        if (command.equals("3D Project...")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Plot Z-axis Profile")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Start Animation [\\]")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Stop Animation")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Crop")) {
            this.notAvailable(command);
            return null;
        }
        if (this.in(command, new String[]{"Translate...", "Scale..."})) {
            if (null != active) {
                selection.specify();
            }
            return null;
        }
        if (command.equals("Duplicate...")) {
            if (null != active && active.getClass().equals(Patch.class)) {
                project.getLoader().releaseToFit((long)((double)project.getLoader().estimateImageFileSize((Patch)active, 0) * 2.5));
                new ImagePlus(active.getTitle(), ((Patch)active).getImageProcessor().duplicate()).show();
            }
            return null;
        }
        if (command.equals("Rename...")) {
            if (null != active) {
                active.adjustProperties();
                Display.updateSelection();
            }
            return null;
        }
        if (command.equals("Flip Horizontally")) {
            selection.apply(2, new double[]{-1.0, 1.0});
            return null;
        }
        if (command.equals("Flip Vertically")) {
            selection.apply(2, new double[]{1.0, -1.0});
            return null;
        }
        if (command.equals("Rotate 90 Degrees Right")) {
            selection.apply(1, new double[]{90.0});
            return null;
        }
        if (command.equals("Rotate 90 Degrees Left")) {
            selection.apply(1, new double[]{-90.0});
            return null;
        }
        if (command.equals("Arbitrarily...")) {
            if (null != active) {
                selection.specify();
            }
            return null;
        }
        if (command.equals("To Selection")) {
            Roi roi = fimp.getRoi();
            if (null != roi) {
                Rectangle b = roi.getBounds();
                b.x -= b.width / 2;
                b.y -= b.height / 2;
                b.width *= 2;
                b.height *= 2;
                display.getCanvas().showCentered(b);
            }
            return null;
        }
        if (command.equals("View 100%")) {
            this.niy(command);
            return null;
        }
        if (command.equals("Measure")) {
            Roi roi = fimp.getRoi();
            if (null != roi) {
                Calibration cal = fimp.getCalibration();
                AffineTransform caff = new AffineTransform();
                caff.scale(cal.pixelWidth, cal.pixelHeight);
                if (M.isAreaROI(roi)) {
                    Area area = M.getArea(roi);
                    area = area.createTransformedArea(caff);
                    ResultsTable rt = Utils.createResultsTable("ROI area", new String[]{"area", "perimeter"});
                    rt.incrementCounter();
                    rt.addLabel("units", cal.getUnit());
                    rt.addValue(0, Math.abs(AreaCalculations.area((PathIterator)area.getPathIterator(null))));
                    rt.addValue(1, roi.getLength());
                    rt.show("ROI area");
                } else {
                    ResultsTable rt = Utils.createResultsTable("ROI length", new String[]{"length"});
                    rt.incrementCounter();
                    rt.addLabel("units", cal.getUnit());
                    rt.addValue(0, roi.getLength());
                    rt.show("ROI length");
                }
                return null;
            }
            if (null != active) {
                if (active.getClass() == Patch.class) {
                    ImagePlus imp = ((Patch)active).getImagePlus();
                    imp.setCalibration(active.getLayer().getParent().getCalibrationCopy());
                    IJ.run((ImagePlus)imp, (String)"Measure", (String)"");
                } else {
                    ProjectThing pt = active.getProject().findProjectThing(active);
                    if (active instanceof Profile) {
                        ((ProjectThing)pt.getParent()).measure();
                    } else {
                        pt.measure();
                    }
                }
                return null;
            }
            Utils.log("Draw a ROI or select an object!");
            return null;
        }
        if (this.in(command, new String[]{"Analyze Particles...", "Histogram", "Plot Profile", "Surface Plot...", "Color Inspector 3D", "3D Surface Plot", "Color Histogram"})) {
            return this.setTempCurrentImage(command, active);
        }
        if (command.equals("Label")) {
            this.notAvailable(command);
            return null;
        }
        if (command.equals("Volume Viewer")) {
            return this.runOnVirtualLayerSet(command, layer_set, display);
        }
        if (command.equals("3D Viewer")) {
            layer_set.createLayerStack(Displayable.class, 4, display.getDisplayChannelAlphas()).getImagePlus().show();
            return command;
        }
        if (this.in(command, new String[]{"FFT", "Fast FFT (2D/3D)"})) {
            return this.setTempCurrentImage(command, active);
        }
        if (this.in(command, new String[]{"Bandpass Filter...", "Custom Filter...", "FD Math...", "Swap Quadrants", "Convolve...", "Gaussian Blur...", "Median...", "Mean...", "Minimum...", "Maximum...", "Unsharp Mask...", "Variance...", "Show Circular Masks...", "Subtract Background..."})) {
            return this.duplicate(command, active);
        }
        if (this.in(command, new String[]{"Smooth", "Sharpen", "Find Edges", "Enhance Contrast", "Add Noise", "Add Specified Noise...", "Salt and Pepper", "Despeckle", "Remove Outliers...", "North", "Northeast", "East", "Southeast", "South", "Southwest", "West", "Northwest", "Make Binary", "Convert to Mask", "Find Maxima...", "Erode", "Dilate", "Open ", "Close-", "Outline", "Fill Holes", "Skeletonize", "Distance Map", "Ultimate Points", "Watershed", "Add...", "Subtract...", "Multiply...", "Divide...", "AND...", "OR...", "XOR...", "Min...", "Max...", "Gamma...", "Log", "Exp", "Square", "Square Root", "Reciprocal", "NaN Background", "Abs"})) {
            return this.duplicate(command, active);
        }
        Menu menu = Menus.getSaveAsMenu();
        for (int i = menu.getItemCount() - 1; i > -1; --i) {
            if (!command.equals(menu.getItem(i).getActionCommand())) continue;
            this.notAvailable(command);
            return null;
        }
        return command;
    }
}

