/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ini.trakem2.display.Connector;
import ini.trakem2.display.Coordinate;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Node;
import ini.trakem2.display.Tree;
import ini.trakem2.display.VectorData;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class TreeConnectorsView {
    private static Map<Tree<?>, TreeConnectorsView> open = Collections.synchronizedMap(new HashMap());
    private JFrame frame;
    private TargetsTableModel outgoing_model = new TargetsTableModel();
    private TargetsTableModel incoming_model = new TargetsTableModel();
    private Tree<?> tree;
    private static final Comparator<Displayable> IDSorter = new Comparator<Displayable>(){

        @Override
        public int compare(Displayable o1, Displayable o2) {
            if (o1.getId() < o1.getId()) {
                return -1;
            }
            return 1;
        }
    };

    public TreeConnectorsView(Tree<?> tree) {
        this.tree = tree;
        this.update();
        this.createGUI();
        open.put(tree, this);
    }

    public static Bureaucrat create(final Tree<?> tree) {
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Opening connectors table"){

            @Override
            public void exec() {
                TreeConnectorsView tcv = (TreeConnectorsView)open.get(tree);
                if (null != tcv) {
                    tcv.update();
                    tcv.frame.setVisible(true);
                    tcv.frame.toFront();
                } else {
                    new TreeConnectorsView(tree);
                }
            }
        }, tree.getProject());
    }

    public static void dispose(Tree<?> tree) {
        TreeConnectorsView tcv = open.remove(tree);
        if (null == tcv) {
            return;
        }
        tcv.frame.dispose();
    }

    public void update() {
        try {
            List<Connector>[] connectors = this.tree.findConnectors();
            this.outgoing_model.setData(connectors[0]);
            this.incoming_model.setData(connectors[1]);
        }
        catch (Exception e) {
            IJError.print(e);
        }
    }

    private void addTab(JTabbedPane tabs, String title, TargetsTableModel model) {
        Table table = new Table();
        table.setModel(model);
        JScrollPane jsp = new JScrollPane(table);
        jsp.setPreferredSize(new Dimension(500, 500));
        tabs.addTab(title, jsp);
    }

    private void createGUI() {
        this.frame = new JFrame("Connectors for Tree #" + this.tree.getId());
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                open.remove(TreeConnectorsView.this.tree);
            }
        });
        JTabbedPane tabs = new JTabbedPane();
        this.addTab(tabs, "Outgoing", this.outgoing_model);
        this.addTab(tabs, "Incoming", this.incoming_model);
        this.frame.getContentPane().add(tabs);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private class TargetsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        List<Row> rows = null;

        private TargetsTableModel() {
        }

        public synchronized void setData(Collection<Connector> connectors) {
            this.rows = new ArrayList<Row>(connectors.size());
            for (Connector c : connectors) {
                int i = 0;
                ArrayList<Displayable> origins = new ArrayList<Displayable>(c.getOrigins(VectorData.class, true));
                Collections.sort(origins, IDSorter);
                for (Set<Displayable> targets : c.getTargets(VectorData.class, true)) {
                    ArrayList<Displayable> ts = new ArrayList<Displayable>(targets);
                    Collections.sort(ts, IDSorter);
                    this.rows.add(new Row(c, i++, origins, ts));
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TargetsTableModel.this.fireTableDataChanged();
                    TargetsTableModel.this.fireTableStructureChanged();
                }
            });
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Connector id";
                }
                case 1: {
                    return "Origin id";
                }
                case 2: {
                    return "Target id";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.rows.get((int)row).connector.getId();
                }
                case 1: {
                    return this.rows.get(row).getOriginIds();
                }
                case 2: {
                    return this.rows.get(row).getTargetIds();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }

        final void sortByColumn(final int col, final boolean descending) {
            ArrayList<Row> rows = new ArrayList<Row>(this.rows);
            Collections.sort(rows, new Comparator<Row>(){

                @Override
                public int compare(Row r1, Row r2) {
                    long op = r1.getColumn(col) - r2.getColumn(col);
                    if (descending) {
                        if (op > 0L) {
                            return -1;
                        }
                        if (op < 0L) {
                            return 1;
                        }
                        return 0;
                    }
                    if (op < 0L) {
                        return -1;
                    }
                    if (op > 0L) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.rows = rows;
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
        }
    }

    private class Table
    extends JTable {
        private static final long serialVersionUID = 1L;

        Table() {
            this.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (2 != me.getClickCount()) {
                        return;
                    }
                    int viewColumn = Table.this.getColumnModel().getColumnIndexAtX(me.getX());
                    int column = Table.this.convertColumnIndexToModel(viewColumn);
                    if (-1 == column) {
                        return;
                    }
                    ((TargetsTableModel)Table.this.getModel()).sortByColumn(column, me.isShiftDown());
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    final int row = Table.this.rowAtPoint(me.getPoint());
                    final int col = Table.this.columnAtPoint(me.getPoint());
                    if (2 == me.getClickCount()) {
                        Table.this.go(col, row);
                    } else if (Utils.isPopupTrigger(me)) {
                        JPopupMenu popup = new JPopupMenu();
                        final JMenuItem go = new JMenuItem("Go");
                        popup.add(go);
                        final JMenuItem goandsel = new JMenuItem("Go and select");
                        popup.add(go);
                        final JMenuItem update = new JMenuItem("Update");
                        popup.add(update);
                        ActionListener listener = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                Object src = ae.getSource();
                                if (src == go) {
                                    Table.this.go(col, row);
                                } else if (src == goandsel) {
                                    Table.this.go(col, row);
                                    if (0 != (ae.getModifiers() ^ 1)) {
                                        Display.getFront().getSelection().clear();
                                    }
                                    TargetsTableModel ttm = (TargetsTableModel)Table.this.getModel();
                                    Display.getFront().getSelection().add(ttm.rows.get((int)row).connector);
                                } else if (src == update) {
                                    Bureaucrat.createAndStart((Worker)new Worker.Task("Updating..."){

                                        @Override
                                        public void exec() {
                                            TreeConnectorsView.this.update();
                                        }
                                    }, TreeConnectorsView.this.tree.getProject());
                                }
                            }
                        };
                        go.addActionListener(listener);
                        goandsel.addActionListener(listener);
                        update.addActionListener(listener);
                        popup.show(Table.this, me.getX(), me.getY());
                    }
                }
            });
        }

        void go(int col, int row) {
            TargetsTableModel ttm = (TargetsTableModel)this.getModel();
            Display.centerAt(ttm.rows.get(row).getCoordinate(col));
        }
    }

    private class Row {
        final Connector connector;
        final int i;
        final ArrayList<Displayable> origins;
        final ArrayList<Displayable> targets;
        String originids;
        String targetids;

        Row(Connector c, int i, ArrayList<Displayable> origins, ArrayList<Displayable> targets) {
            this.connector = c;
            this.i = i;
            this.origins = origins;
            this.targets = targets;
            Iterator<Displayable> it = this.targets.iterator();
            while (it.hasNext()) {
                if (it.next().getClass() != Connector.class) continue;
                it.remove();
            }
        }

        final Coordinate<Node<Float>> getCoordinate(int col) {
            switch (col) {
                case 0: 
                case 1: {
                    return this.connector.getCoordinateAtOrigin();
                }
                case 2: {
                    return this.connector.getCoordinate(this.i);
                }
            }
            Utils.log2("Can't deal with column " + col);
            return null;
        }

        private final long getFirstId(ArrayList<Displayable> c) {
            if (c.isEmpty()) {
                return 0L;
            }
            return c.get(0).getId();
        }

        final long getColumn(int col) {
            switch (col) {
                case 0: {
                    return this.connector.getId();
                }
                case 1: {
                    return this.getFirstId(this.origins);
                }
                case 2: {
                    return this.getFirstId(this.targets);
                }
            }
            Utils.log2("Don't know how to deal with column " + col);
            return 0L;
        }

        private final String getIds(String ids, ArrayList<Displayable> ds) {
            if (null == ids) {
                switch (ds.size()) {
                    case 0: {
                        ids = "";
                        break;
                    }
                    case 1: {
                        ids = ds.get(0).toString();
                        break;
                    }
                    default: {
                        StringBuilder sb = new StringBuilder();
                        for (Displayable d : ds) {
                            sb.append(d).append(',').append(' ');
                        }
                        sb.setLength(sb.length() - 2);
                        ids = sb.toString();
                    }
                }
            }
            return ids;
        }

        final String getTargetIds() {
            this.targetids = this.getIds(this.targetids, this.targets);
            return this.targetids;
        }

        final String getOriginIds() {
            this.originids = this.getIds(this.originids, this.origins);
            return this.originids;
        }
    }
}

