/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ini.trakem2.Project;
import ini.trakem2.display.Bucketable;
import ini.trakem2.display.Display;
import ini.trakem2.display.Display3D;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.utils.Search;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public abstract class ZDisplayable
extends Displayable {
    protected LayerSet layer_set;

    public ZDisplayable(Project project, String title, double x, double y) {
        super(project, title, x, y);
    }

    public ZDisplayable(Project project, long id, String title, boolean locked, AffineTransform at, float width, float height) {
        super(project, id, title, locked, at, width, height);
    }

    public ZDisplayable(Project project, long id, HashMap<String, String> ht, HashMap<Displayable, String> ht_links) {
        super(project, id, ht, ht_links);
        String data = ht.get("layer_set_id");
        if (null != data) {
            this.layer_set = new LayerSet(project, Long.parseLong(data));
        }
    }

    public void setLayerSet(LayerSet layer_set) {
        this.setLayerSet(layer_set, true);
    }

    public void setLayerSet(LayerSet layer_set, boolean update_db) {
        if (layer_set == this.layer_set) {
            return;
        }
        this.layer_set = layer_set;
        if (update_db) {
            this.updateInDatabase("layer_set_id");
        }
    }

    @Override
    public LayerSet getLayerSet() {
        return this.layer_set;
    }

    @Override
    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    @Override
    public abstract boolean linkPatches();

    public abstract Layer getFirstLayer();

    @Override
    public void exportXML(StringBuilder sb_body, String indent, XMLOptions options) {
        super.exportXML(sb_body, indent, options);
        sb_body.append(indent).append("layer_set_id=\"").append(this.layer_set.getId()).append("\"\n");
    }

    public static void exportDTD(String type, StringBuilder sb_header, HashSet<String> hs, String indent) {
        if (hs.contains(type)) {
            return;
        }
        Displayable.exportDTD(type, sb_header, hs, indent);
        sb_header.append(indent).append("<!ATTLIST ").append(type).append(" layer_set_id").append(" NMTOKEN #REQUIRED>\n");
    }

    @Deprecated
    public void transformPoints(Layer layer, double dx, double dy, double rot, double xo, double yo) {
    }

    @Override
    protected boolean remove2(boolean check) {
        return this.project.getProjectTree().remove(check, this.project.findProjectThing(this), null);
    }

    @Override
    public boolean remove(boolean check) {
        if (check && !Utils.check("Really remove " + this.toString() + " ?")) {
            return false;
        }
        if (this.layer_set.remove(this) && this.removeFromDatabase()) {
            this.unlink();
            this.removeLinkedPropertiesFromOrigins();
            Search.remove(this);
            Display.flush(this);
            this.project.decache(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean softRemove() {
        if (this.removeFromDatabase()) {
            this.unlink();
            this.removeLinkedPropertiesFromOrigins();
            Search.remove(this);
            Display.flush(this);
            return true;
        }
        return false;
    }

    public boolean paintsAt(Layer layer) {
        return null != layer && this.layer_set == layer.getParent();
    }

    @Override
    public Collection<Long> getLayerIds() {
        ArrayList<Long> l = new ArrayList<Long>();
        for (Layer la : this.layer_set.getLayers()) {
            l.add(la.getId());
        }
        return l;
    }

    @Override
    public void setColor(Color color) {
        if (null == color || color.equals(this.color)) {
            return;
        }
        this.color = color;
        Displayable.last_color = color;
        this.updateInDatabase("color");
        Display.repaint(this.layer_set, (Displayable)this, 5);
        Display3D.setColor(this, color);
    }

    public abstract boolean intersects(Area var1, double var2, double var4);

    @Override
    public void setVisible(boolean visible, boolean repaint) {
        if (visible == this.visible) {
            return;
        }
        this.visible = visible;
        if (repaint) {
            Display.repaint(this.layer_set, null, this.getBoundingBox(), 5, true);
        }
        this.updateInDatabase("visible");
    }

    @Override
    public Bucketable getBucketable() {
        return this.layer_set;
    }

    public boolean crop(List<Layer> range) {
        return true;
    }

    protected boolean layerRemoved(Layer la) {
        if (null != this.hs_linked) {
            for (Displayable d : this.hs_linked) {
                if (d.layer != la) continue;
                this.unlink(d);
            }
        }
        return true;
    }

    public void updateBucket(Layer la) {
        if (null == la) {
            this.updateBucket();
        } else if (null != this.getBucketable()) {
            this.getBucketable().updateBucket(this, la);
        }
    }

    @Override
    public void updateBucket() {
        if (null == this.getBucketable()) {
            return;
        }
        for (Layer layer : this.getLayersWithData()) {
            this.getBucketable().updateBucket(this, layer);
        }
    }

    protected abstract boolean calculateBoundingBox(Layer var1);
}

