/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.persistence;

import ij.ImagePlus;
import ij.io.FileInfo;
import ini.trakem2.display.MipMapImage;
import ini.trakem2.utils.CachingThread;
import ini.trakem2.utils.TypedHashMap;
import ini.trakem2.utils.Utils;
import java.awt.Image;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Cache {
    private final TypedHashMap<String, ImagePlusUsers> imps = new TypedHashMap();
    private static final int[] PIXEL_SIZE = new int[]{1, 2, 4, 1, 4};
    private static final int OVERHEAD = 1024;
    private static final int[] max_levels = new int[50000];
    private final TypedHashMap<Long, Pyramid> pyramids = new TypedHashMap();
    private final LinkedList<TypedHashMap<Long, Pyramid>> intervals = new LinkedList();
    private int count = 0;
    private long bytes = 0L;
    private long max_bytes = 0L;
    private static final int MAX_INTERVAL_SIZE = 20;
    private TypedHashMap<Long, Pyramid> last_interval = new TypedHashMap(20);

    static final long size(ImagePlus imp) {
        return imp.getWidth() * imp.getHeight() * imp.getNSlices() * PIXEL_SIZE[imp.getType()] + 1024;
    }

    static final long size(Image img) {
        return img.getWidth(null) * img.getHeight(null) * 4 + 1024;
    }

    private static final int computeLevel(int i) {
        return (int)(0.5 + (Math.log(i) - Math.log(32.0)) / Math.log(2.0)) + 1;
    }

    private static int maxLevel(int maxdim) {
        return maxdim < max_levels.length ? max_levels[maxdim] : Cache.computeLevel(maxdim);
    }

    private final int maxLevel(Image image, int starting_level) {
        int max = Math.max(image.getWidth(null), image.getHeight(null));
        return starting_level + (max < max_levels.length ? max_levels[max] : Cache.computeLevel(max));
    }

    public Cache(long max_bytes) {
        this.intervals.add(this.last_interval);
        this.max_bytes = max_bytes;
    }

    private final void addBytes(long b) {
        this.bytes += b;
    }

    public void setMaxBytes(long max_bytes) {
        if (max_bytes < this.max_bytes) {
            this.removeAndFlushSome(this.max_bytes - max_bytes);
        }
        this.max_bytes = max_bytes;
    }

    public final long ensureFree(long min_free_bytes) {
        if (this.bytes + min_free_bytes > this.max_bytes) {
            return this.removeAndFlushSome(this.bytes + min_free_bytes - this.max_bytes);
        }
        return 0L;
    }

    public long getMaxBytes() {
        return this.max_bytes;
    }

    public long getBytes() {
        return this.bytes;
    }

    public final boolean contains(long id) {
        return this.pyramids.hasKey(id);
    }

    public final boolean contains(long id, int level) {
        Pyramid p = this.pyramids.getValue(id);
        return null != p && null != p.images[level];
    }

    public final Image get(long id, int level) {
        Pyramid p = this.pyramids.getValue(id);
        if (null == p) {
            return null;
        }
        if (null == p || null == p.images[level]) {
            return null;
        }
        this.update(p);
        return p.images[level];
    }

    public final ImagePlus get(String path) {
        ImagePlusUsers u = this.imps.getValue(path);
        return null == u ? null : u.getImagePlus();
    }

    public final ImagePlus get(long id) {
        Pyramid p = this.pyramids.getValue(id);
        if (null == p) {
            return null;
        }
        ImagePlus pyrimp = p.getImagePlus();
        if (null == pyrimp) {
            return null;
        }
        this.update(p);
        return pyrimp;
    }

    public final Map<Integer, Image> getAll(long id) {
        Pyramid p = this.pyramids.getValue(id);
        TypedHashMap<Integer, Image> m = new TypedHashMap<Integer, Image>();
        if (null == p) {
            return m;
        }
        for (int i = 0; i < p.images.length; ++i) {
            if (null == p.images[i]) continue;
            m.put(i, p.images[i]);
        }
        this.update(p);
        return m;
    }

    public final MipMapImage getClosestAbove(long id, int level) {
        Pyramid p = this.pyramids.getValue(id);
        if (null == p) {
            return null;
        }
        for (int i = Math.min(level, p.images.length - 1); i > -1; --i) {
            if (null == p.images[i]) continue;
            this.update(p);
            double scale = Math.pow(2.0, i);
            return new MipMapImage(p.images[i], scale, scale);
        }
        return null;
    }

    public final MipMapImage getClosestBelow(long id, int level) {
        Pyramid p = this.pyramids.getValue(id);
        if (null == p) {
            return null;
        }
        for (int i = level; i < p.images.length; ++i) {
            if (null == p.images[i]) continue;
            this.update(p);
            double scale = Math.pow(2.0, i);
            return new MipMapImage(p.images[i], scale, scale);
        }
        return null;
    }

    private final void reset() {
        this.pyramids.clear();
        this.intervals.clear();
        this.count = 0;
        this.bytes = 0L;
        this.last_interval = new TypedHashMap(20);
        this.intervals.add(this.last_interval);
        this.imps.clear();
    }

    private final void update(Pyramid p) {
        if (this.last_interval != p.interval) {
            p.interval.removeEntry(p.id);
            this.append(p);
        }
    }

    private final void append(Pyramid p) {
        if (0 == this.intervals.size()) {
            this.intervals.add(this.last_interval);
        }
        if (this.last_interval.size() >= 20) {
            this.last_interval = new TypedHashMap(20);
            this.intervals.add(this.last_interval);
        }
        this.last_interval.put(p.id, p);
        p.interval = this.last_interval;
    }

    private final void fit(long b) {
        this.addBytes(b);
        if (this.bytes > this.max_bytes) {
            this.removeAndFlushSome(this.bytes - this.max_bytes);
        }
    }

    public final void put(long id, Image image, int level) {
        Pyramid p = this.pyramids.getValue(id);
        if (null == p) {
            p = new Pyramid(id, image, level);
            this.pyramids.put(id, p);
            this.append(p);
            this.fit(Cache.size(image));
            ++this.count;
        } else {
            this.update(p);
            if (null == p.images[level]) {
                ++this.count;
            }
            this.fit(p.replace(image, level));
        }
    }

    public final void updateImagePlusPath(String oldPath, String newPath) {
        ImagePlusUsers u = this.imps.removeEntry(oldPath);
        if (null == u) {
            return;
        }
        this.imps.put(newPath, u);
    }

    public static final String getPath(ImagePlus imp) {
        FileInfo fi = imp.getOriginalFileInfo();
        if (null == fi || -999999 == fi.fileFormat) {
            return null;
        }
        String dir = fi.directory;
        if (null == dir) {
            return fi.url;
        }
        return dir + fi.fileName;
    }

    public final void put(long id, ImagePlus imp, int maxdim) {
        Pyramid p = this.pyramids.getValue(id);
        if (null == p) {
            p = new Pyramid(id, imp, maxdim);
            this.pyramids.put(id, p);
            this.append(p);
            String path = Cache.getPath(imp);
            ImagePlusUsers u = this.imps.getValue(path);
            if (null == u) {
                this.fit(Cache.size(imp));
                if (null != path) {
                    this.imps.put(path, new ImagePlusUsers(imp, id));
                }
            } else {
                u.addUser(id);
            }
            ++this.count;
        } else {
            this.update(p);
            ImagePlus pyrimp = p.getImagePlus();
            if (null == pyrimp) {
                ++this.count;
            } else if (imp != pyrimp) {
                String path1 = Cache.getPath(pyrimp);
                ImagePlusUsers u1 = this.imps.getValue(path1);
                u1.removeUser(id, path1);
                String path2 = Cache.getPath(imp);
                ImagePlusUsers u2 = this.imps.getValue(path2);
                if (null == u2) {
                    if (null != path2) {
                        this.imps.put(path2, new ImagePlusUsers(imp, id));
                    }
                } else {
                    u2.addUser(id);
                }
            }
            this.fit(p.replace(imp));
        }
    }

    public final Image remove(long id, int level) {
        Pyramid p = this.pyramids.getValue(id);
        if (null == p) {
            return null;
        }
        Image im = p.images[level];
        if (null != im) {
            this.addBytes(p.replace(null, level));
            --this.count;
        }
        if (0 == p.n_images && null == p.getImagePlus()) {
            p.interval.removeEntry(id);
            this.pyramids.removeEntry(id);
        }
        return im;
    }

    public final ImagePlus removeImagePlus(long id) {
        return this.removeImagePlus(this.pyramids.getValue(id));
    }

    private final ImagePlus removeImagePlus(Pyramid p) {
        if (null == p) {
            return null;
        }
        ImagePlus pyrimp = p.getImagePlus();
        if (null == pyrimp) {
            return null;
        }
        ImagePlus imp = pyrimp;
        p.setImagePlus(null);
        String path = Cache.getPath(imp);
        ImagePlusUsers u = this.imps.getValue(path);
        if (null != u) {
            u.removeUser(p.id, path);
        }
        if (null == u || u.users.isEmpty()) {
            this.addBytes(p.replace(null));
            --this.count;
            if (0 == p.n_images) {
                p.interval.removeEntry(p.id);
                this.pyramids.removeEntry(p.id);
            }
        }
        return imp;
    }

    public final void remove(long id) {
        Pyramid p = this.pyramids.removeEntry(id);
        if (null == p) {
            return;
        }
        if (null != p.getImagePlus()) {
            this.removeImagePlus(p);
        }
        this.count -= p.n_images;
        for (int i = 0; i < p.images.length; ++i) {
            if (null == p.images[i]) continue;
            this.addBytes(p.replace(null, i));
        }
        p.interval.removeEntry(id);
    }

    public final void removeAndFlushAll() {
        for (Pyramid p : this.pyramids.values()) {
            p.replace(null);
            for (int i = 0; i < p.images.length; ++i) {
                if (null == p.images[i]) continue;
                p.images[i].flush();
                CachingThread.storeArrayForReuse(p.images[i]);
            }
        }
        this.reset();
    }

    public final void removeAndFlushPyramid(long id) {
        Pyramid p = this.pyramids.getValue(id);
        if (null == p) {
            return;
        }
        this.count -= p.n_images;
        for (int i = 0; i < p.images.length; ++i) {
            if (null == p.images[i]) continue;
            this.addBytes(p.replace(null, i));
        }
        if (null == p.getImagePlus()) {
            this.pyramids.removeEntry(id);
            p.interval.removeEntry(id);
        }
    }

    public final long removeAndFlushSome(long min_bytes) {
        long size = 0L;
        while (this.intervals.size() > 0) {
            TypedHashMap<Long, Pyramid> interval = this.intervals.getFirst();
            Iterator it = interval.values().iterator();
            while (it.hasNext()) {
                Pyramid p = (Pyramid)it.next();
                ImagePlus pyrimp = p.getImagePlus();
                if (null != pyrimp) {
                    String path = Cache.getPath(pyrimp);
                    ImagePlusUsers u = this.imps.getValue(path);
                    if (null == path || null == u || 1 == u.users.size()) {
                        this.imps.removeEntry(path);
                        long s = p.replace(null);
                        this.addBytes(s);
                        --this.count;
                        if ((size -= s) >= min_bytes) {
                            if (0 == p.n_images) {
                                this.pyramids.removeEntry(p.id);
                                it.remove();
                                if (interval.isEmpty()) {
                                    this.intervals.removeFirst();
                                }
                            }
                            return size;
                        }
                    }
                }
                for (int i = 0; i < p.images.length && p.n_images > 0; ++i) {
                    if (null == p.images[i]) continue;
                    long s = p.replace(null, i);
                    this.addBytes(s);
                    --this.count;
                    if ((size -= s) < min_bytes) continue;
                    if (0 == p.n_images) {
                        this.pyramids.removeEntry(p.id);
                        it.remove();
                        if (interval.isEmpty()) {
                            this.intervals.removeFirst();
                        }
                    }
                    return size;
                }
                this.pyramids.removeEntry(p.id);
                it.remove();
            }
            this.intervals.removeFirst();
        }
        return size;
    }

    public final long removeAndFlushSome(int n) {
        long size = 0L;
        while (this.intervals.size() > 0) {
            TypedHashMap<Long, Pyramid> interval = this.intervals.getFirst();
            Iterator it = interval.values().iterator();
            while (it.hasNext()) {
                Pyramid p = (Pyramid)it.next();
                ImagePlus pyrimp = p.getImagePlus();
                if (null != pyrimp) {
                    String path = Cache.getPath(pyrimp);
                    ImagePlusUsers u = this.imps.getValue(path);
                    if (null == path || null == u || 1 == u.users.size()) {
                        this.imps.removeEntry(path);
                        long s = p.replace(null);
                        size -= s;
                        this.addBytes(s);
                        p.replace(null);
                        --this.count;
                        if (0 == --n) {
                            if (0 == p.n_images) {
                                this.pyramids.removeEntry(p.id);
                                it.remove();
                                if (interval.isEmpty()) {
                                    this.intervals.removeFirst();
                                }
                            }
                            return size;
                        }
                    }
                }
                for (int i = 0; i < p.images.length; ++i) {
                    if (null == p.images[i]) continue;
                    long s = p.replace(null, i);
                    size -= s;
                    this.addBytes(s);
                    --this.count;
                    if (0 != --n) continue;
                    if (0 == p.n_images) {
                        this.pyramids.removeEntry(p.id);
                        it.remove();
                        if (interval.isEmpty()) {
                            this.intervals.removeFirst();
                        }
                    }
                    return size;
                }
                this.pyramids.removeEntry(p.id);
                it.remove();
            }
            this.intervals.removeFirst();
        }
        return size;
    }

    public final int size() {
        return this.count;
    }

    public void debug() {
        Utils.log2("@@@@@@@@@@ START");
        Utils.log2("pyramids: " + this.pyramids.size());
        for (Map.Entry<Long, Pyramid> entry : new TreeMap<Long, Pyramid>(this.pyramids).entrySet()) {
            Pyramid pyramid = entry.getValue();
            Utils.log2("p id:" + entry.getKey() + ";  images: " + pyramid.n_images + " / " + pyramid.images.length + ";  imp: " + entry.getValue().getImagePlus());
        }
        Utils.log2("----");
        int i = 0;
        for (TypedHashMap typedHashMap : this.intervals) {
            Utils.log2("interval " + ++i);
            for (Map.Entry e : new TreeMap(typedHashMap).entrySet()) {
                Pyramid p = (Pyramid)e.getValue();
                Utils.log2("p id:" + e.getKey() + ";  images: " + p.n_images + " / " + p.images.length + "; imp: " + ((Pyramid)e.getValue()).getImagePlus());
                int[] levels = new int[p.images.length];
                for (int k = 0; k < levels.length; ++k) {
                    levels[k] = null == p.images[k] ? 0 : 1;
                }
                Utils.log2("      levels: " + Utils.toString(levels));
            }
        }
        Utils.log2("----");
        for (Map.Entry entry : this.imps.entrySet()) {
            ImagePlusUsers imagePlusUsers = (ImagePlusUsers)entry.getValue();
            Utils.log2(imagePlusUsers.users.size() + " ImagePlusUsers of " + (String)entry.getKey());
        }
        Utils.log2("----");
        Utils.log2("imps: " + this.imps.size());
        Utils.log2("----");
        Utils.log2("count is: " + this.count + ", size is: " + this.bytes + " / " + this.max_bytes + ", intervals.size = " + this.intervals.size() + ", pyr.size = " + this.pyramids.size());
        TypedHashMap<Integer, Integer> typedHashMap = new TypedHashMap<Integer, Integer>();
        for (TypedHashMap typedHashMap2 : this.intervals) {
            int l = typedHashMap2.size();
            Integer in = (Integer)typedHashMap.getValue(l);
            if (null == in) {
                typedHashMap.put(l, 1);
                continue;
            }
            typedHashMap.put(l, in + 1);
        }
        Utils.log2("interval size distribution: ", typedHashMap);
    }

    public final long seqFindId(ImagePlus imp) {
        for (Pyramid p : this.pyramids.values()) {
            if (p.getImagePlus() != imp) continue;
            return p.id;
        }
        return Long.MIN_VALUE;
    }

    static {
        for (int i = 32; i < max_levels.length; ++i) {
            Cache.max_levels[i] = Cache.computeLevel(i);
        }
    }

    private final class ImagePlusUsers {
        final Set<Long> users = new HashSet<Long>();
        final SoftReference<ImagePlus> srimp;

        ImagePlusUsers(ImagePlus imp, Long firstUser) {
            this.srimp = new SoftReference<ImagePlus>(imp);
            this.users.add(firstUser);
        }

        final ImagePlus getImagePlus() {
            return null == this.srimp ? null : this.srimp.get();
        }

        final void addUser(Long id) {
            this.users.add(id);
        }

        final void removeUser(Long id, String path) {
            this.users.remove(id);
            if (this.users.isEmpty() && null != path) {
                Cache.this.imps.removeEntry(path);
            }
        }
    }

    private final class Pyramid {
        private final Image[] images;
        private TypedHashMap<Long, Pyramid> interval = null;
        private final long id;
        private SoftReference<ImagePlus> srimp;
        private long impSize;
        private int n_images;

        Pyramid(long id, Image image, int level) {
            this.id = id;
            this.images = new Image[Cache.this.maxLevel(image, level)];
            this.images[level] = image;
            this.n_images = 1;
        }

        Pyramid(long id, ImagePlus imp, int maxdim) {
            this.id = id;
            this.setImagePlus(imp);
            this.images = new Image[Cache.maxLevel(maxdim)];
            this.n_images = 0;
        }

        final long replace(Image img, int level) {
            if (null == this.images[level]) {
                if (null == img) {
                    return 0L;
                }
                this.images[level] = img;
                ++this.n_images;
                return Cache.size(img);
            }
            if (null == img) {
                --this.n_images;
                long b = -Cache.size(this.images[level]);
                this.images[level].flush();
                CachingThread.storeArrayForReuse(this.images[level]);
                this.images[level] = null;
                return b;
            }
            if (img != this.images[level]) {
                long b = Cache.size(img) - Cache.size(this.images[level]);
                this.images[level].flush();
                CachingThread.storeArrayForReuse(this.images[level]);
                this.images[level] = img;
                return b;
            }
            return 0L;
        }

        final long replace(ImagePlus impNew) {
            ImagePlus pyrimp = this.getImagePlus();
            if (null == impNew) {
                if (null == pyrimp) {
                    return 0L;
                }
                if (null != this.srimp) {
                    this.srimp.clear();
                }
                return -this.impSize;
            }
            if (null == pyrimp) {
                this.setImagePlus(impNew);
                return this.impSize;
            }
            long pyrimpSize = this.impSize;
            this.setImagePlus(impNew);
            return this.impSize - pyrimpSize;
        }

        final void setImagePlus(ImagePlus imp) {
            if (null == imp) {
                this.impSize = 0L;
                this.srimp = null;
                return;
            }
            this.impSize = Cache.size(imp);
            this.srimp = new SoftReference<ImagePlus>(imp);
        }

        final ImagePlus getImagePlus() {
            return null == this.srimp ? null : this.srimp.get();
        }
    }
}

