/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.intensity;

import ij.ImageJ;
import ij.ImagePlus;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealViews;
import net.imglib2.realtransform.Scale;
import net.imglib2.realtransform.Translation;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.RealComposite;

public class LinearIntensityMap<T extends RealType<T>> {
    protected final Dimensions dimensions;
    protected final Translation translation;
    protected final RealRandomAccessible<RealComposite<T>> coefficients;
    protected final InterpolatorFactory<RealComposite<T>, RandomAccessible<RealComposite<T>>> interpolatorFactory;

    private static final <T extends RealType<T>> InterpolatorFactory<RealComposite<T>, RandomAccessible<RealComposite<T>>> interpolatorFactory(Interpolation interpolation) {
        switch (interpolation) {
            case NN: {
                return new NearestNeighborInterpolatorFactory();
            }
        }
        return new NLinearInterpolatorFactory();
    }

    public LinearIntensityMap(RandomAccessibleInterval<T> source, InterpolatorFactory<RealComposite<T>, RandomAccessible<RealComposite<T>>> interpolatorFactory) {
        this.interpolatorFactory = interpolatorFactory;
        CompositeIntervalView collapsedSource = Views.collapseReal(source);
        this.dimensions = new FinalInterval((Interval)collapsedSource);
        double[] shift = new double[this.dimensions.numDimensions()];
        for (int d = 0; d < shift.length; ++d) {
            shift[d] = 0.5;
        }
        this.translation = new Translation(shift);
        ExtendedRandomAccessibleInterval extendedCollapsedSource = Views.extendBorder((RandomAccessibleInterval)collapsedSource);
        this.coefficients = Views.interpolate((EuclideanSpace)extendedCollapsedSource, interpolatorFactory);
    }

    public LinearIntensityMap(RandomAccessibleInterval<T> source) {
        this(source, (InterpolatorFactory<RealComposite<T>, RandomAccessible<RealComposite<T>>>)new NLinearInterpolatorFactory());
    }

    public LinearIntensityMap(RandomAccessibleInterval<T> source, Interpolation interpolation) {
        this(source, LinearIntensityMap.interpolatorFactory(interpolation));
    }

    public <S extends NumericType<S>> void run(RandomAccessibleInterval<S> image) {
        assert (image.numDimensions() == this.dimensions.numDimensions()) : "Number of dimensions do not match.";
        double[] s = new double[this.dimensions.numDimensions()];
        for (int d = 0; d < s.length; ++d) {
            s[d] = image.dimension(d) / this.dimensions.dimension(d);
        }
        Scale scale = new Scale(s);
        IntervalView stretchedCoefficients = Views.offsetInterval((RandomAccessible)Views.raster((RealRandomAccessible)RealViews.transform((RealRandomAccessible)RealViews.transform(this.coefficients, (InvertibleRealTransform)this.translation), (InvertibleRealTransform)scale)), image);
        NumericType t = (NumericType)image.randomAccess().get();
        if (ARGBType.class.isInstance(t)) {
            LinearIntensityMap.mapARGB((IterableInterval<ARGBType>)Views.flatIterable(image), Views.flatIterable((RandomAccessibleInterval)stretchedCoefficients));
        } else if (RealComposite.class.isInstance(t)) {
            LinearIntensityMap.mapComposite(Views.flatIterable(image), Views.flatIterable((RandomAccessibleInterval)stretchedCoefficients));
        } else if (RealType.class.isInstance(t)) {
            RealType r = (RealType)t;
            if (r.getMinValue() > -1.7976931348623157E308 || r.getMaxValue() < Double.MAX_VALUE) {
                LinearIntensityMap.mapCrop(Views.flatIterable(image), Views.flatIterable((RandomAccessibleInterval)stretchedCoefficients));
            } else {
                LinearIntensityMap.map(Views.flatIterable(image), Views.flatIterable((RandomAccessibleInterval)stretchedCoefficients));
            }
        }
    }

    protected static final <S extends RealType<S>, T extends RealType<T>> void map(IterableInterval<S> image, IterableInterval<RealComposite<T>> coefficients) {
        Cursor cs = image.cursor();
        Cursor ct = coefficients.cursor();
        while (cs.hasNext()) {
            RealType s = (RealType)cs.next();
            RealComposite t = (RealComposite)ct.next();
            s.setReal(s.getRealDouble() * ((RealType)t.get(0L)).getRealDouble() + ((RealType)t.get(1L)).getRealDouble());
        }
    }

    protected static final <S extends RealType<S>, T extends RealType<T>> void mapCrop(IterableInterval<S> image, IterableInterval<RealComposite<T>> coefficients) {
        Cursor cs = image.cursor();
        Cursor ct = coefficients.cursor();
        RealType firstValue = (RealType)cs.next();
        double minS = firstValue.getMinValue();
        double maxS = firstValue.getMaxValue();
        while (cs.hasNext()) {
            RealType s = (RealType)cs.next();
            RealComposite t = (RealComposite)ct.next();
            s.setReal(Math.max(minS, Math.min(maxS, s.getRealDouble() * ((RealType)t.get(0L)).getRealDouble() + ((RealType)t.get(1L)).getRealDouble())));
        }
    }

    protected static final <S extends RealType<S>, T extends RealType<T>> void mapComposite(IterableInterval<RealComposite<S>> image, IterableInterval<RealComposite<T>> coefficients) {
        Cursor cs = image.cursor();
        Cursor ct = coefficients.cursor();
        while (cs.hasNext()) {
            RealComposite c = (RealComposite)cs.next();
            RealComposite t = (RealComposite)ct.next();
            for (RealType s : c) {
                s.setReal(s.getRealDouble() * ((RealType)t.get(0L)).getRealDouble() + ((RealType)t.get(1L)).getRealDouble());
            }
        }
    }

    protected static final <T extends RealType<T>> void mapARGB(IterableInterval<ARGBType> image, IterableInterval<RealComposite<T>> coefficients) {
        Cursor cs = image.cursor();
        Cursor ct = coefficients.cursor();
        while (cs.hasNext()) {
            RealComposite t = (RealComposite)ct.next();
            double alpha = ((RealType)t.get(0L)).getRealDouble();
            double beta = ((RealType)t.get(1L)).getRealDouble();
            ARGBType s = (ARGBType)cs.next();
            int argb = s.get();
            int a = argb >> 24 & 0xFF;
            double r = (double)(argb >> 16 & 0xFF) * alpha + beta;
            double g = (double)(argb >> 8 & 0xFF) * alpha + beta;
            double b = (double)(argb & 0xFF) * alpha + beta;
            s.set(a << 24 | (r < 0.0 ? 0 : (r > 255.0 ? 255 : (int)(r + 0.5))) << 16 | (g < 0.0 ? 0 : (g > 255.0 ? 255 : (int)(g + 0.5))) << 8 | (b < 0.0 ? 0 : (b > 255.0 ? 255 : (int)(b + 0.5))));
        }
    }

    public static void main(String[] args) {
        new ImageJ();
        double[] coefficients = new double[]{0.0, 2.0, 4.0, 8.0, 1.0, 1.0, 1.0, 1.0, 1.0, 10.0, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0, 110.0, 120.0, 130.0, 140.0, 150.0};
        LinearIntensityMap transform = new LinearIntensityMap(ArrayImgs.doubles((double[])coefficients, (long[])new long[]{4L, 4L, 2L}));
        ImagePlus imp1 = new ImagePlus("http://fly.mpi-cbg.de/~saalfeld/Pictures/norway.jpg");
        ArrayImg image1 = ArrayImgs.floats((float[])((float[])imp1.getProcessor().convertToFloatProcessor().getPixels()), (long[])new long[]{imp1.getWidth(), imp1.getHeight()});
        ArrayImg image2 = ArrayImgs.unsignedBytes((byte[])((byte[])imp1.getProcessor().convertToByteProcessor().getPixels()), (long[])new long[]{imp1.getWidth(), imp1.getHeight()});
        ArrayImg image3 = ArrayImgs.unsignedShorts((short[])((short[])imp1.getProcessor().convertToShortProcessor().getPixels()), (long[])new long[]{imp1.getWidth(), imp1.getHeight()});
        ArrayImg image4 = ArrayImgs.argbs((int[])((int[])imp1.getProcessor().getPixels()), (long[])new long[]{imp1.getWidth(), imp1.getHeight()});
        ImageJFunctions.show((RandomAccessibleInterval)ArrayImgs.doubles((double[])coefficients, (long[])new long[]{4L, 4L, 2L}));
        transform.run((RandomAccessibleInterval)image1);
        transform.run((RandomAccessibleInterval)image2);
        transform.run((RandomAccessibleInterval)image3);
        transform.run((RandomAccessibleInterval)image4);
        ImageJFunctions.show((RandomAccessibleInterval)image1);
        ImageJFunctions.show((RandomAccessibleInterval)image2);
        ImageJFunctions.show((RandomAccessibleInterval)image3);
        ImageJFunctions.show((RandomAccessibleInterval)image4);
    }

    public static enum Interpolation {
        NN,
        NL;

    }
}

