/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.python;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Parameter;
import org.scijava.script.AbstractScriptEngine;

public class PythonScriptEngine
extends AbstractScriptEngine {
    @Parameter
    private ObjectService objectService;
    @Parameter
    private LogService logService;

    public PythonScriptEngine(Context context) {
        context.inject((Object)this);
        this.setLogService(this.logService);
        this.engineScopeBindings = new ScriptBindings();
    }

    public Object eval(String script) throws ScriptException {
        Optional<Function> pythonScriptRunner = this.objectService.getObjects(Function.class).stream().filter(obj -> "PythonScriptRunner".equals(this.objectService.getName(obj))).findFirst();
        if (!pythonScriptRunner.isPresent()) {
            throw new IllegalStateException("The PythonScriptRunner could not be found in the ObjectService. To use the\nPython script engine, you must call scyjava.enable_scijava_scripting(context)\nwith this script engine's associated SciJava context before using it.");
        }
        return pythonScriptRunner.get().apply(new Args(script, this.engineScopeBindings, this.scriptContext));
    }

    public Object eval(Reader reader) throws ScriptException {
        StringBuilder buf = new StringBuilder();
        char[] cbuf = new char[65536];
        try {
            int nChars;
            while ((nChars = reader.read(cbuf)) > 0) {
                buf.append(cbuf, 0, nChars);
            }
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        return this.eval(buf.toString());
    }

    public Bindings createBindings() {
        return new ScriptBindings();
    }

    private static class Args {
        public final String script;
        public final Map<String, Object> vars;
        public final ScriptContext scriptContext;

        public Args(String script, Map<String, Object> vars, ScriptContext scriptContext) {
            this.script = script;
            this.vars = vars;
            this.scriptContext = scriptContext;
        }
    }

    private static class ScriptBindings
    implements Bindings {
        private Map<String, Object> bindingsMap = new HashMap<String, Object>();

        ScriptBindings() {
        }

        @Override
        public int size() {
            return this.bindingsMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.bindingsMap.isEmpty();
        }

        @Override
        public boolean containsValue(Object value) {
            return this.bindingsMap.containsValue(value);
        }

        @Override
        public void clear() {
            this.bindingsMap.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.bindingsMap.keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.bindingsMap.values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.bindingsMap.entrySet();
        }

        @Override
        public Object put(String name, Object value) {
            return this.bindingsMap.put(name, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> toMerge) {
            this.bindingsMap.putAll(toMerge);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.bindingsMap.containsKey(key);
        }

        @Override
        public Object get(Object key) {
            return this.bindingsMap.get(key);
        }

        @Override
        public Object remove(Object key) {
            return this.bindingsMap.remove(key);
        }
    }
}

