/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.gadgets;

import java.util.Arrays;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import sc.fiji.coloc.algorithms.MissingPreconditionException;
import sc.fiji.coloc.gadgets.ThresholdMode;

public class MaskFactory {
    public static RandomAccessibleInterval<BitType> createMask(long[] dim) {
        ArrayImgFactory imgFactory = new ArrayImgFactory();
        return imgFactory.create(dim, (Object)new BitType());
    }

    public static RandomAccessibleInterval<BitType> createMask(long[] dim, boolean val) {
        RandomAccessibleInterval<BitType> mask = MaskFactory.createMask(dim);
        for (BitType t : Views.iterable(mask)) {
            t.set(val);
        }
        return mask;
    }

    public static RandomAccessibleInterval<BitType> createMask(long[] dim, long[] roiOffset, long[] roiDim) throws MissingPreconditionException {
        if (dim.length != roiOffset.length || dim.length != roiDim.length) {
            throw new MissingPreconditionException("The dimensions of the mask as well as the ROIs and his offset must be the same.");
        }
        RandomAccessibleInterval<BitType> mask = MaskFactory.createMask(dim);
        int dims = mask.numDimensions();
        long[] pos = new long[dims];
        long[] roiOffsetMax = new long[dims];
        for (int i = 0; i < dims; ++i) {
            roiOffsetMax[i] = roiOffset[i] + roiDim[i];
        }
        Cursor cursor = Views.iterable(mask).localizingCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(pos);
            boolean valid = true;
            for (int i = 0; i < dims; ++i) {
                valid &= pos[i] >= roiOffset[i] && pos[i] < roiOffsetMax[i];
            }
            ((BitType)cursor.get()).set(valid);
        }
        return mask;
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<BitType> createMask(RandomAccessibleInterval<T> ch1, RandomAccessibleInterval<T> ch2, T threshold1, T threshold2, ThresholdMode tMode, CombinationMode cMode) {
        long[] dims = new long[ch1.numDimensions()];
        ch1.dimensions(dims);
        RandomAccessibleInterval<BitType> mask = MaskFactory.createMask(dims);
        Cursor cursor1 = Views.iterable(ch1).cursor();
        Cursor cursor2 = Views.iterable(ch2).cursor();
        Cursor maskCursor = Views.iterable(mask).cursor();
        while (cursor1.hasNext() && cursor2.hasNext() && maskCursor.hasNext()) {
            boolean ch2Valid;
            boolean ch1Valid;
            cursor1.fwd();
            cursor2.fwd();
            maskCursor.fwd();
            RealType data1 = (RealType)cursor1.get();
            RealType data2 = (RealType)cursor2.get();
            if (tMode == ThresholdMode.Above) {
                ch1Valid = data1.compareTo(threshold1) > 0;
                ch2Valid = data2.compareTo(threshold2) > 0;
            } else if (tMode == ThresholdMode.Below) {
                ch1Valid = data1.compareTo(threshold1) < 0;
                ch2Valid = data2.compareTo(threshold2) < 0;
            } else {
                throw new UnsupportedOperationException();
            }
            BitType maskData = (BitType)maskCursor.get();
            if (cMode == CombinationMode.AND) {
                maskData.set(ch1Valid && ch2Valid);
                continue;
            }
            if (cMode == CombinationMode.OR) {
                maskData.set(ch1Valid || ch2Valid);
                continue;
            }
            if (cMode == CombinationMode.NONE) {
                maskData.set(!ch1Valid && !ch2Valid);
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return mask;
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<BitType> createMask(long[] dim, RandomAccessibleInterval<T> origMask) {
        RandomAccessibleInterval<BitType> mask = MaskFactory.createMask(dim);
        long[] origDim = new long[origMask.numDimensions()];
        origMask.dimensions(origDim);
        if (Arrays.equals(dim, origDim)) {
            Cursor origCursor = Views.iterable(origMask).localizingCursor();
            RandomAccess maskCursor = mask.randomAccess();
            while (origCursor.hasNext()) {
                origCursor.fwd();
                maskCursor.setPosition((Localizable)origCursor);
                boolean value = ((RealType)origCursor.get()).getRealDouble() > 0.001;
                ((BitType)maskCursor.get()).set(value);
            }
        } else if (dim.length > origDim.length) {
            for (int i = 0; i < origDim.length; ++i) {
                if (origDim[i] == dim[i]) continue;
                throw new UnsupportedOperationException("Masks with lower dimensionality than the image,  but a different extent are not yet supported.");
            }
            Cursor origCursor = Views.iterable(origMask).localizingCursor();
            RandomAccess maskCursor = mask.randomAccess();
            long[] pos = new long[origMask.numDimensions()];
            while (origCursor.hasNext()) {
                int i;
                origCursor.fwd();
                origCursor.localize(pos);
                boolean value = ((RealType)origCursor.get()).getRealDouble() > 0.001;
                for (i = 0; i < origDim.length; ++i) {
                    maskCursor.setPosition(pos[i], i);
                }
                for (i = origDim.length; i < dim.length; ++i) {
                    int j = 0;
                    while ((long)j < dim[i]) {
                        maskCursor.setPosition(j, i);
                        ((BitType)maskCursor.get()).set(value);
                        ++j;
                    }
                }
            }
        } else {
            if (dim.length < origDim.length) {
                throw new UnsupportedOperationException("Masks with more dimensions than the image are not supported, yet.");
            }
            throw new UnsupportedOperationException("Masks with same dimensionality, but a different extent than the image are not supported, yet.");
        }
        return mask;
    }

    public static enum CombinationMode {
        AND,
        OR,
        NONE;

    }
}

