/*
 * Decompiled with CFR 0.152.
 */
package fiji.selection;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Toolbar;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;

public class Select_Bounding_Box
implements PlugInFilter {
    Mode mode = Mode.SELECTION;
    ImagePlus image;

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        if ("autocrop".equals(arg)) {
            this.mode = Mode.AUTOCROP;
        } else if ("autoautocrop".equals(arg)) {
            this.mode = Mode.AUTOAUTOCROP;
        } else if ("autoselect".equals(arg)) {
            this.mode = Mode.AUTOSELECTION;
        }
        return 255;
    }

    public void run(ImageProcessor ip) {
        double background;
        if (this.mode == Mode.AUTOAUTOCROP || this.mode == Mode.AUTOSELECTION) {
            background = this.guessBackground(ip);
        } else if (ip instanceof ColorProcessor) {
            Color color = Toolbar.getBackgroundColor();
            background = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        } else {
            background = ip.getBestIndex(Toolbar.getBackgroundColor());
            if (!(ip instanceof ByteProcessor)) {
                background = ip.getMin() + background * (ip.getMax() - ip.getMin()) / 255.0;
            }
        }
        Rectangle rect = Select_Bounding_Box.getBoundingBox(ip, ip.getRoi(), background);
        switch (this.mode) {
            case SELECTION: 
            case AUTOSELECTION: {
                this.image.setRoi(rect);
                break;
            }
            case AUTOCROP: 
            case AUTOAUTOCROP: {
                Select_Bounding_Box.crop(this.image, rect);
            }
        }
    }

    public double guessBackground(ImageProcessor ip) {
        Rectangle rect = ip.getRoi();
        if (rect == null) {
            rect = new Rectangle(0, 0, ip.getWidth(), ip.getHeight());
        }
        float[] values = new float[(rect.width + rect.height - 2) * 2];
        if (ip instanceof ColorProcessor) {
            int i;
            ColorProcessor cp = (ColorProcessor)ip;
            for (i = 0; i < rect.width; ++i) {
                values[i] = cp.get(rect.x + i, rect.y + 0) & 0xFFFFFF;
                values[i + rect.width] = cp.get(rect.x + i, rect.y + rect.height - 1) & 0xFFFFFF;
            }
            for (i = 1; i < rect.height - 1; ++i) {
                values[i + 2 * rect.width - 1] = cp.get(rect.x + 0, rect.y + i) & 0xFFFFFF;
                values[i + 2 * rect.width - 1 + rect.height - 2] = cp.get(rect.x + rect.width - 1, rect.y + i) & 0xFFFFFF;
            }
        } else {
            int i;
            for (i = 0; i < rect.width; ++i) {
                values[i] = ip.getf(rect.x + i, rect.y + 0);
                values[i + rect.width] = ip.getf(rect.x + i, rect.y + rect.height - 1);
            }
            for (i = 1; i < rect.height - 1; ++i) {
                values[i + 2 * rect.width - 1] = ip.getf(rect.x + 0, rect.y + i);
                values[i + 2 * rect.width - 1 + rect.height - 2] = ip.getf(rect.x + rect.width - 1, rect.y + i);
            }
        }
        Arrays.sort(values);
        int best = 0;
        int bestCount = 1;
        int currentCount = 1;
        for (int i = 1; i < values.length; ++i) {
            if (values[i] != values[i - 1]) {
                currentCount = 1;
                continue;
            }
            if (++currentCount <= bestCount) continue;
            best = i;
            bestCount = currentCount;
        }
        return values[best];
    }

    public static Rectangle getBoundingBox(ImageProcessor ip, Rectangle rect, double background) {
        if (rect == null) {
            rect = new Rectangle(0, 0, ip.getWidth(), ip.getHeight());
        } else {
            rect = (Rectangle)rect.clone();
            rect.width += rect.x;
            rect.height += rect.y;
        }
        Cropper cropper = ip instanceof ColorProcessor ? new CropperRGB(ip, background) : new CropperDefault(ip, background);
        cropper.findMinY(rect);
        cropper.findMaxY(rect);
        cropper.findMinX(rect);
        cropper.findMaxX(rect);
        rect.width -= rect.x;
        rect.height -= rect.y;
        return rect;
    }

    public static ImageProcessor crop(ImageProcessor ip, Rectangle rect) {
        ip.setRoi(rect);
        return ip.crop();
    }

    public static void crop(ImagePlus image, Rectangle rect) {
        if (image.getWidth() == rect.width && image.getHeight() == rect.height) {
            return;
        }
        image.changes = true;
        if (image.getStackSize() == 1) {
            image.setProcessor(image.getTitle(), Select_Bounding_Box.crop(image.getProcessor(), rect));
            return;
        }
        ImageStack stack = new ImageStack(rect.width, rect.height);
        ImageStack orig = image.getStack();
        for (int i = 1; i < orig.getSize(); ++i) {
            stack.addSlice("", Select_Bounding_Box.crop(orig.getProcessor(i), rect));
        }
        image.setStack(image.getTitle(), stack);
    }

    static final class CropperRGB
    extends Cropper {
        int[] pixels;
        int w;
        int backgroundRGB;

        CropperRGB(ImageProcessor ip, double background) {
            super(ip, background);
            this.pixels = (int[])ip.getPixels();
            this.w = ip.getWidth();
            this.backgroundRGB = (int)background & 0xFFFFFF;
        }

        @Override
        final boolean isBackground(int x, int y) {
            return (this.pixels[x + this.w * y] & 0xFFFFFF) == this.backgroundRGB;
        }
    }

    static final class CropperDefault
    extends Cropper {
        CropperDefault(ImageProcessor ip, double background) {
            super(ip, background);
        }

        @Override
        final boolean isBackground(int x, int y) {
            return (double)this.ip.getf(x, y) == this.background;
        }
    }

    static abstract class Cropper {
        ImageProcessor ip;
        double background;

        Cropper(ImageProcessor ip, double background) {
            this.ip = ip;
            this.background = background;
        }

        abstract boolean isBackground(int var1, int var2);

        final void findMinY(Rectangle rect) {
            for (int y = rect.y; y < rect.height; ++y) {
                for (int x = rect.x; x < rect.width; ++x) {
                    if (this.isBackground(x, y)) continue;
                    rect.y = y;
                    return;
                }
            }
        }

        final void findMaxY(Rectangle rect) {
            for (int y = rect.height - 1; y >= rect.y; --y) {
                for (int x = rect.x; x < rect.width; ++x) {
                    if (this.isBackground(x, y)) continue;
                    rect.height = y + 1;
                    return;
                }
            }
        }

        final void findMinX(Rectangle rect) {
            for (int x = rect.x; x < rect.width; ++x) {
                for (int y = rect.y; y < rect.height; ++y) {
                    if (this.isBackground(x, y)) continue;
                    rect.x = x;
                    return;
                }
            }
        }

        final void findMaxX(Rectangle rect) {
            for (int x = rect.width - 1; x >= rect.x; --x) {
                for (int y = rect.y; y < rect.height; ++y) {
                    if (this.isBackground(x, y)) continue;
                    rect.width = x + 1;
                    return;
                }
            }
        }
    }

    static enum Mode {
        SELECTION,
        AUTOCROP,
        AUTOAUTOCROP,
        AUTOSELECTION;

    }
}

