/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.APIRequestThread;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import java.applet.Applet;
import java.io.DataInputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ArchiveClient {
    Applet applet;
    Hashtable<String, String> parameterHash;
    String cgiRoot;

    public ArchiveClient(Applet applet) {
        this(applet, Macro.getOptions());
    }

    public ArchiveClient(Applet applet, String arguments) {
        this.applet = applet;
        this.extractArchiveParameters(arguments);
        this.cgiRoot = this.getValue("cgi-root");
    }

    static byte[] justGetFile(String string_url) {
        HttpURLConnection connection = null;
        Object dos = null;
        int initialBufferSize = 0x100000;
        byte[] buffer = new byte[initialBufferSize];
        int bytesRead = 0;
        try {
            int bytesJustRead;
            URL url = new URL(string_url);
            URLConnection urlConnection = url.openConnection();
            if (!(urlConnection instanceof HttpURLConnection)) {
                return null;
            }
            connection = (HttpURLConnection)urlConnection;
            connection.setDoInput(true);
            connection.setDoOutput(false);
            connection.setUseCaches(false);
            connection.setRequestMethod("GET");
            DataInputStream dis = new DataInputStream(connection.getInputStream());
            do {
                if (bytesRead == buffer.length) {
                    byte[] newBuffer = new byte[(int)((double)buffer.length * 1.5)];
                    System.arraycopy(buffer, 0, newBuffer, 0, bytesRead);
                    buffer = newBuffer;
                }
                bytesJustRead = dis.read(buffer, bytesRead, buffer.length - bytesRead);
                bytesRead += bytesJustRead;
            } while (bytesJustRead >= 0);
            dis.close();
            System.out.println("Finished reading data from input (download) stream.");
        }
        catch (Exception e) {
            IJ.error((String)("Fetching " + string_url + " failed with:\n" + e));
            return null;
        }
        System.out.println("Upload finished.");
        byte[] result = new byte[bytesRead];
        System.arraycopy(buffer, 0, result, 0, bytesRead);
        return result;
    }

    public static String justGetFileAsString(String url) {
        byte[] data = ArchiveClient.justGetFile(url);
        if (data == null) {
            return null;
        }
        try {
            String result = new String(data, "UTF-8");
            return result;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public ArrayList<String[]> synchronousRequest(Hashtable parametersForPost, byte[] data) {
        String cookie_value = this.parameterHash.get("cookie-value");
        APIRequestThread requestThread = new APIRequestThread();
        System.err.println("cgiRoot is " + this.cgiRoot);
        ArrayList<String[]> returned_data = requestThread.doUploadRequest(this.cgiRoot + "api", parametersForPost, data, cookie_value);
        for (int i = 0; i < returned_data.size(); ++i) {
            String[] line = returned_data.get(i);
            System.err.print("Got line: ");
            for (int j = 0; j < line.length; ++j) {
                System.err.print(line[j] + ";\t");
            }
            System.err.println("");
        }
        return returned_data;
    }

    private void extractArchiveParameters(String arguments) {
        StringTokenizer tokenizer = new StringTokenizer(arguments, ";");
        this.parameterHash = new Hashtable();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            System.err.println("got token: " + token);
            int indexOfFirstEquals = token.indexOf(61);
            if (indexOfFirstEquals < 0) {
                this.parameterHash.put(token, "");
                continue;
            }
            String key = token.substring(0, indexOfFirstEquals);
            String value = token.substring(indexOfFirstEquals + 1);
            this.parameterHash.put(key, value);
        }
    }

    public String getValue(String key) {
        return this.parameterHash.get(key);
    }

    public boolean hasKey(String key) {
        return this.parameterHash.containsKey(key);
    }

    public Enumeration keys() {
        return this.parameterHash.keys();
    }

    public void closeChannelsWithTag(String tag) {
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        parameters.put("method", "channel-tags");
        parameters.put("md5sum", this.getValue("md5sum"));
        ArrayList<String[]> tsv_results = this.synchronousRequest(parameters, null);
        int tags = Integer.parseInt(tsv_results.get(0)[1]);
        int matching_channel = -1;
        for (int i = 0; i < tags; ++i) {
            String[] row = tsv_results.get(i);
            if (!tag.equalsIgnoreCase(row[1])) continue;
            matching_channel = Integer.parseInt(row[0]);
            break;
        }
        if (matching_channel >= 0) {
            String lookFor = "Ch" + (matching_channel + 1);
            int[] wList = WindowManager.getIDList();
            if (wList == null) {
                IJ.error((String)"Neurite Tracer: no images have been loaded");
                return;
            }
            for (int i = 0; i < wList.length; ++i) {
                ImagePlus imp = WindowManager.getImage((int)wList[i]);
                String title = imp != null ? imp.getTitle() : "";
                int indexOfChannel = title.indexOf(lookFor);
                if (indexOfChannel < 0) continue;
                imp.close();
                break;
            }
        }
    }
}

